<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/NetObj.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/NetObj.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> NetObj.i3 </EM></BLOCKQUOTE><PRE>
</PRE> A {\it network object} is an object whose methods can be invoked by
   other programs, in addition to the program that allocated the object.
   The program invoking the method is called the {\it client} and the
   program containing the network object is called the {\it owner}.  The
   client and owner can be running on different machines or in different
   address spaces on the same machine.
   \index{network object}\index{network object!client}
   \index{network object!owner} 

<P> This is the primary public interface for using network objects.
   Before listing the interface, here are a few definitions.
<P>
   A {\it program instance} is an activation of a program.
   The same program can have many instances running concurrently
   or consecutively.  A program instance can be thought of 
   as an address space, although the design does not 
   preclude the implementation of a program instance by a
   suite of address spaces.\index{program instance}
<P>
   An {\it agent}\index{agent} is a program that provides a table that
   maps names to network objects.  Any program can be an agent, but every
   machine has a particular default agent.  Owners typically make 
   network objects available to clients by inserting them 
   into an agent's table, using the procedure <CODE>NetObj.Export</CODE>.  
   Clients typically use <CODE>NetObj.Import</CODE> to retrieve network objects 
   from the table.


<P><PRE>INTERFACE <interface><A HREF="../../netobj/src/NetObj.m3">NetObj</A></interface>;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

TYPE
  T &lt;: ROOT;
  <A HREF="Transport.i3#Address">Address</A> &lt;: REFANY;
</PRE> <CODE>NetObj.T</CODE> is the root type of all network objects.
   A <CODE>NetObj.Address</CODE> designates a program instance.
   \ttindex{NetObj.T}\ttindex{NetObj.Address} 

<P><PRE>PROCEDURE <A HREF="../../netobj/src/NetObj.m3#Locate">Locate</A> (host: TEXT): Address
    RAISES {Invalid, Error, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Return an address for the standard agent at the machine whose
   human-sensible name is <CODE>host</CODE>. \ttindex{NetObj.Locate} </EM></BLOCKQUOTE><PRE>
</PRE> The naming convention used by <CODE>Locate</CODE> is system-dependent.  For 
   example, in an Internet environment, <CODE>Locate(\dq decsrc.pa.dec.com\dq )</CODE> 
   returns the address of the default agent on the machine <CODE>decsrc</CODE> in 
   the DEC Palo Alto Internet domain.
<P>
   <CODE>Locate</CODE> raises <CODE>Invalid</CODE> if it determines that <CODE>host</CODE> is not a 
   valid name.  It raises <CODE>Error</CODE> if it is unable to interpret the 
   name or determine its validity, typically because it is unable 
   to contact the naming authority, or if there is no standard
   agent running on the specified host.  

<P><PRE>PROCEDURE <A HREF="../../netobj/src/NetObj.m3#Export">Export</A>(
    name: TEXT; obj: T; where: Address := NIL)
    RAISES {Error, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Set <CODE>table[name] := obj</CODE> where <CODE>table</CODE> is the table provided by the
   agent whose address is <CODE>where</CODE>, or by the default agent for the local
   machine if <CODE>where = NIL</CODE>.  This can be used with <CODE>obj=NIL</CODE> to
   remove an entry from the table.  \ttindex{NetObj.Export} </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="../../netobj/src/NetObj.m3#Import">Import</A>(name: TEXT; where: Address := NIL): T
    RAISES {Error, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Return <CODE>table[name]</CODE> where <CODE>table</CODE> is the table provided by the
   agent whose address is <CODE>where</CODE>, or by the default agent for the local
   machine if <CODE>where = NIL</CODE>.  <CODE>Import</CODE> returns <CODE>NIL</CODE> if <CODE>table</CODE>
   contains no entry for <CODE>name</CODE>. \ttindex{NetObj.Import} </EM></BLOCKQUOTE><PRE>

EXCEPTION
  Error(AtomList.T);
  Invalid;

VAR (*CONST*)
  CommFailure, MissingObject,
    NoResources, NoTransport,
    UnsupportedDataRep, Alerted: Atom.T;

END NetObj.
</PRE> \ttindex{NetObj.Error}%
   The exception <CODE>NetObj.Error</CODE> indicates possible failures in a remote 
   method invocation.  Every remote method should therefore include
   <CODE>NetObj.Error</CODE> in its raises clause.  If <CODE>NetObj.Error</CODE> is not raised,
   then the invocation completed successfully.  If it is raised, it may
   or may not have completed successfully.  It is possible that an
   {\it orphaned} remote invocation continued to execute at the owner,
   while the client raised <CODE>NetObj.Error</CODE>.\index{orphan computation}
<P>
   The first atom in the argument to <CODE>NetObj.Error</CODE> explains the
   reason for the failure.  The subsequent atoms may provide additional
   implementation-dependent details about the failure.  Here are the
   interpretations of the first atom:
<P>
   The atom <CODE>CommFailure</CODE> indicates communication failure, which might be 
   network failure or a crash on a remote machine.  <CODE>MissingObject</CODE> 
   indicates that some network object, either the one whose method 
   is invoked or an argument to that method, has been garbage-collected 
   by its owner.  (This indicates that the owner mistakenly determined 
   that one of its clients was dead.)  <CODE>NoResources</CODE> indicates that 
   the call failed because of a lack of resources, for example Unix 
   file descriptors.  <CODE>NoTransport</CODE> indicates that an attempt to 
   unmarshal an object failed because the client and owner shared no
   common transport protocol implementation and were therefore unable
   to communicate.  <CODE>UnsupportedDataRep</CODE> indicates a mismatch 
   between the network representation of data and the ability of a 
   receiver to handle it, for example a 64-bit <CODE>INTEGER</CODE> with non-zero 
   high-order bits is not meaningful as an <CODE>INTEGER</CODE> on a 32-bit 
   machine. <CODE>Alerted</CODE> indicates that a client thread was alerted in 
   the middle of a remote call and that an orphaned remote 
   computation might still be in progress.  (Threads alerted in remote 
   calls might also raise <CODE>Thread.Alerted</CODE>; in which case 
   it is guaranteed that no orphans remain.)  Any other atoms indicate 
   errors inside the network object runtime. 


</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
