<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/NetObjNotifier.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/NetObjNotifier.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> NetObjNotifier.i3 </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>NetObjNotifier</CODE> interface allows the holder of a
   surrogate object to request notification of when the object's
   owner becomes inaccessible.  This can be useful, for example,
   if it is necessary to remove surrogates from a table upon
   termination of the programs holding their corresponding concrete
   objects.


<P><PRE>INTERFACE <interface><A HREF="NetObjRT.m3">NetObjNotifier</A></interface>;

IMPORT <A HREF="NetObj.i3">NetObj</A>;

TYPE
  OwnerState = {Dead, Failed};

  NotifierClosure = OBJECT METHODS
    notify(obj: NetObj.T; st: OwnerState);
  END;

PROCEDURE <A HREF="NetObjRT.m3#AddNotifier">AddNotifier</A>(obj: NetObj.T; cl: NotifierClosure);
</PRE><BLOCKQUOTE><EM> Arrange that a call to <CODE>cl.notify</CODE> will be
   scheduled when <CODE>obj</CODE> becomes inaccessible.
   If <CODE>obj</CODE> is not a surrogate object then <CODE>AddNotifier</CODE> has no effect.
   If <CODE>obj</CODE> is already inaccessible at the time <CODE>AddNotifier</CODE> is called,
   then a call to <CODE>cl.notify</CODE> is scheduled immediately.
   \ttindex{NetObjNotifier.AddNotifier} </EM></BLOCKQUOTE><PRE>

END NetObjNotifier.
</PRE> The <CODE>notify</CODE> method of a <CODE>NotifierClosure</CODE> is invoked
   when the concrete object corresponding to the surrogate <CODE>obj</CODE>
   becomes inaccessible.  The procedure <CODE>AddNotifier</CODE> must have
   been called to enable this notification.  There may be more than
   one <CODE>NotifierClosure</CODE> for the same surrogate.  At notification time,
   the <CODE>st</CODE> argument is <CODE>Dead</CODE> if and only if the object owner
   is known to be permanently inaccessible.  Otherwise <CODE>st</CODE> is
   <CODE>Failed</CODE>.  It is possible for <CODE>notify</CODE> to be called multiple
   times on the same object.  Any invocations on <CODE>obj</CODE> are guaranteed
   to fail in a timely fashion subsequent to a closure notification
   with <CODE>st = Dead</CODE>.
<P>
   In general, a surrogate object can still be collected if a notifier
   closure is registered for it.  However, if the closure object
   contains a reference to the surrogate, then its registration
   might delay or prevent collection.  Therefore this should be avoided.
<P>
   Although this interface is organized to enable notification of
   owner death on a per object basis, in practice this is achieved by
   monitoring the state of the owner's address space.  This means
   that death notification will be more or less simultaneous for
   all surrogates whose concrete objects have the same owner.  

<P>
<P>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
