<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/NetObjRT.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/NetObjRT.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> NetObjRT.i3 </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>NetObjRT</CODE> interface defines procedures which are necessary for
   the maintenance of the network object runtime {\it object table}.
   This table is a mapping from <CODE>WireRep.T</CODE> to <CODE>NetObj.T</CODE>.  All
   surrogate objects appear in this table, as do all concrete objects
   which might be remotely referenced. 
   
<P><PRE>INTERFACE <interface><A HREF="NetObjRT.m3">NetObjRT</A></interface>;

IMPORT <A HREF="NetObj.i3">NetObj</A>, <A HREF="StubLib.i3">StubLib</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="Transport.i3">Transport</A>, <A HREF="WireRep.i3">WireRep</A>;

PROCEDURE <A HREF="NetObjRT.m3#FindTarget">FindTarget</A>(
    wrep: WireRep.T;
    stubProt: StubLib.StubProtocol;
    VAR dispatcher: StubLib.Dispatcher) : NetObj.T
  RAISES {NetObj.Error};
</PRE> <CODE>FindTarget</CODE> searches the object table for an object matching <CODE>wrep</CODE>. 
   If one is found, and it is a concrete object, then the object is 
   returned along with the <CODE>StubLib.Dispatcher</CODE> procedure corrsponding 
   to its type and to the supplied <CODE>stubProt</CODE>.  Otherwise, <CODE>NetObj.Error</CODE>
   is raised with the argument <CODE>NetObj.MissingObject</CODE>.  (We might want
   to raise an explicit error here if the object exists but no dispatcher
   matching <CODE>stubProt</CODE> is found.)
<P>
   <CODE>FindTarget</CODE> is intended for use only when the supplied <CODE>wrep</CODE> is 
   expected to correspond to a local concrete object.  This is the 
   case, for example, when the network object runtime unmarshals the 
   target object of a remote invocation. 
   
<P><PRE>PROCEDURE <A HREF="NetObjRT.m3#Find">Find</A>(
    wrep: WireRep.T;
    loc: Transport.Location) : NetObj.T
  RAISES {NetObj.Error, Thread.Alerted};
</PRE> <CODE>Find</CODE> searches the object table for an object matching <CODE>wrep</CODE>.
   If one is found, it is returned.  Otherwise, a surrogate object
   is constructed for <CODE>wrep</CODE>.  <CODE>loc</CODE> must generate connections back to
   the party who provided <CODE>wrep</CODE>.  This need not be the owner of the
   concrete object, but if not, it must at least be able to provide
   sufficient information to construct a <CODE>Transport.Location</CODE> to the
   real owner. This procedure is called as part of unmarshalling a
   <CODE>NetObj.T</CODE>.
   <P>
   If <CODE>wrep</CODE> is <CODE>WireRep.NullT</CODE>, then <CODE>Find</CODE> produces undefined results. 

<P><PRE>PROCEDURE <A HREF="NetObjRT.m3#InsertAndPin">InsertAndPin</A>(o: NetObj.T) : WireRep.T;
</PRE> If <CODE>o</CODE> is not registered in the local object table, <CODE>InsertAndPin</CODE> 
   assigns a wire representation to <CODE>o</CODE> and inserts it into the table. 
   (This can happen only for concrete objects.)  In all cases, the 
   wire representation of <CODE>o</CODE> is returned.  This procedure is called 
   as part of marshalling a <CODE>NetObj.T</CODE>.
   <P>
   <CODE>InsertAndPin</CODE> increments a reference count associated with <CODE>o</CODE> 
   which {\it pins} it in the object table, this is, <CODE>o</CODE> is considered 
   unremovable.  When marshalling of <CODE>o</CODE> is complete, and the 
   destination is known to have either successfully unmarshalled <CODE>o</CODE> 
   or failed in doing so, then this reference count must be decremented 
   with <CODE>Unpin</CODE>.
   <P>
   It is a checked runtime error for <CODE>o</CODE> to be <CODE>NIL</CODE>. 

<P><PRE>PROCEDURE <A HREF="NetObjRT.m3#Unpin">Unpin</A>(READONLY arr: ARRAY OF NetObj.T);
</PRE> <CODE>Unpin</CODE> decrements the pin count associated with each element of
   <CODE>arr</CODE>.  When this count becomes zero for any object, that object
   can be removed from the object table (by some surrogate-holder
   reporting in clean).
   <P>
   It is a checked runtime error for any element of <CODE>arr</CODE> to be <CODE>NIL</CODE>,
   or to have a pin count of zero. 

<P><PRE>END NetObjRT.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
