<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/NetObjRT.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/NetObjRT.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> NetObjRT.m3 </EM></BLOCKQUOTE><PRE>

MODULE <module>NetObjRT</module> EXPORTS <A HREF="NetObjRT.i3"><implements>NetObjRT</A></implements>, <A HREF="NetObjNotifier.i3"><implements>NetObjNotifier</A></implements>,
                        <A HREF="NGCMonitor.i3"><implements>NGCMonitor</A></implements>, <A HREF="SpecialObj.i3"><implements>SpecialObj</A></implements>, <A HREF="StubLib.i3"><implements>StubLib</A></implements>;

&lt;* PRAGMA LL *&gt;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>;
IMPORT <A HREF="NetObj.i3">NetObj</A>, <A HREF="NetObjRep.i3">NetObjRep</A>, <A HREF="Transport.i3">Transport</A>, <A HREF="TransportUtils.i3">TransportUtils</A>, <A HREF="TransportRegistry.i3">TransportRegistry</A>;
IMPORT <A HREF="SpaceID.i3">SpaceID</A>, <A HREF="WireRep.i3">WireRep</A>, <A HREF="../../fingerprint/src/Fingerprint.i3">Fingerprint</A>;
IMPORT <A HREF="../../libm3/derived/IntRefTbl.i3">IntRefTbl</A>, <A HREF="../../libm3/derived/TextRefTbl.i3">TextRefTbl</A>, <A HREF="ObjTbl.i3">ObjTbl</A>, <A HREF="ObjElem.i3">ObjElem</A>,
       <A HREF="FPRefTbl.i3">FPRefTbl</A>, <A HREF="DirtyTbl.i3">DirtyTbl</A>, <A HREF="DirtyElem.i3">DirtyElem</A>;
IMPORT <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../libm3/derived/RefList.i3">RefList</A>;
IMPORT <A HREF="../../runtime/src/common/RTAllocator.i3">RTAllocator</A>, <A HREF="../../runtime/src/common/RTType.i3">RTType</A>, <A HREF="../../runtime/src/common/RTTypeFP.i3">RTTypeFP</A>, <A HREF="../../runtime/src/common/RTTypeSRC.i3">RTTypeSRC</A>, <A HREF="../../weakref/src/WeakRef.i3">WeakRef</A>;

VAR
  mu := NEW(MUTEX);
  cond := NEW(Thread.Condition);
  MissingDispatcher: Atom.T;

VAR                             &lt;* LL &gt;= {mu} *&gt;
  objTbl: ObjTbl.T;
</PRE> The table <CODE>objTbl</CODE> maps wire representations to network objects;
   it maps <CODE>wr</CODE> to <CODE>ob</CODE> if and only if <CODE>ob</CODE> is an exported object
   represented by <CODE>wr</CODE> or <CODE>ob</CODE> is a surrogate for the object represented
   by <CODE>wr</CODE>.
<P>
<PRE>
      T1  ob reachable /\ ob.w # WireRep.NullT =&gt;
          ob.w in domain(objTbl) /\ ob'.w = ob.w =&gt; ob' = ob
</PRE>
   Note that after InitAgent() we have WireRep.SpecialT in domain(objTbl),
   but there is no object ob with ob.w = WireRep.SpecialT.  The special
   object itself, sp = objTbl[WireRep.SpecialT], has sp.w = WireRep.NullT
   if it has not been explicitly exported or sp.w = some proper WireRep.T
   if it has.
   

<P> invariant: for any <CODE>v: ObjElem.T</CODE> in <CODE>range(objTbl)</CODE>,
<PRE>
       v.ref # NIL =&gt; TYPECODE(v.ref.r) = TYPECODE(ExportInfo)
       v.ref = NIL /\ v.ready =&gt;
          v.weakRef <KBD>is a valid (possibly dead)</KBD> WeakRef.T <KBD>for a
|     surrogate</KBD> NetObj.T 


<P><PRE>VAR &lt;* LL &gt;= {mu} *&gt;
  typeTbl: IntRefTbl.T;
  fpToTc: FPRefTbl.T;

CONST MaxVersions = 3;

TYPE
  TypeInfo = REF RECORD
    pureTC: Typecode;
    fp: Fingerprint.T;
    nvers: CARDINAL := 0;
    vers := ARRAY [0..MaxVersions-1] OF StubProtocol {NullStubProtocol, ..};
    surrTCs := ARRAY [0..MaxVersions-1] OF Typecode {LAST(Typecode), ..};
    procs := ARRAY [0..MaxVersions-1] OF Dispatcher {NIL, ..};
    fpTower: FpTower := NIL;
  END;
</PRE> The table <CODE>typeTbl</CODE> maps typecodes to the <CODE>TypeInfo</CODE> needed to 
   handle method invocations and type inquiries for objects of that 
   type.  If it maps <CODE>tc</CODE> to <CODE>r</CODE>, then <CODE>r</CODE> refers to stub information 
   for the first supertype of <CODE>tc</CODE> for which this address space has 
   stubs.  Furthermore if this address space has stubs for a type, 
   then <CODE>typeTbl</CODE> has an entry for the type.  Also, if this address 
   space has ever marshaled an object of allocated type <CODE>t</CODE> then 
   <CODE>typeTbl</CODE> has an entry for <CODE>t</CODE>.
<P>
   The stub-generated code for marshalling objects of type <CODE>T</CODE> calls
   <CODE>Register</CODE> to make entries in <CODE>typeTbl</CODE> before any objects are
   marshaled or unmarshaled.
<P>
   The table <CODE>fpToTc</CODE> maps fingerprints to typeinfo object.  If it maps <CODE>fp</CODE>
   to <CODE>info</CODE>, then <CODE>info</CODE> describes the most specific type for which
   this address space has stubs. 
<P>
   The table <CODE>fpToTc</CODE> is strictly a performance optimatization for 
   converting fingerprints into surrogate type codes.  Given an ordered 
   list of fingerprints representing the type structure of a network 
   object, it is always possible to traverse the list from subtype 
   to supertype searching for a match in the local Modula-3 runtime 
   fingerprint table. If a match is discovered, then the resulting 
   type code can be looked up in <CODE>typeTable</CODE>.  If an entry exists 
   there, then the type code is the the narrowest subtype of the 
   network object for which the local address space has stubs.  
   <CODE>fpToTc</CODE> is used to cache the results of this computation. 


<P><PRE>VAR &lt;* LL &gt;= {mu} *&gt;
  spaceTbl: FPRefTbl.T; (* Table(SpaceID, NetObj.Address) *)
</PRE> <CODE>spaceTbl</CODE> maps <CODE>s</CODE> to information needed for communication with the
   address space identified by <CODE>s</CODE>.  <CODE>adr</CODE> is the address of <CODE>s</CODE>.  There is
   an entry in <CODE>spaceTbl</CODE> for this address space, and an entry
   for every address space that is the owner of a surrogate in this address
   space.  

<P><PRE>TYPE
  Notifier = REF RECORD
    wr: WeakRef.T;    (* to a surrogate object *)
    cl: NotifierClosure;
  END;
</PRE> Objects of type <CODE>Notifier</CODE> are appended to each <CODE>Transport.Location</CODE>
   and used to inform clients when object owners become inaccessible. 

<P><PRE>REVEAL
  Transport.<A NAME="Location">Location</A> = TransportUtils.LocationP BRANDED OBJECT
    &lt;* LL &gt;= {mu} *&gt;
    exports: DirtyTbl.T := NIL;
    (* maps exported w: WireRep.T for which this location is dirty, or
       for which the latest clean call received from this location was
       strong, to the latest EventID received from this location
       for w.  *)
    notifiers: RefList.T := NIL;
    (* a list of Notifier objects for surrogates whose
       owner is the target of this location. *)
    cleaner: Cleaner := NIL;
    locTblIndex: CARDINAL;
    isDead: BOOLEAN := FALSE;
  OVERRIDES
    dead := DeadLocation;
  END;

VAR
  &lt;* LL &gt;= {mu} *&gt;
  locTbl: RECORD
    locs: REF ARRAY OF Transport.Location := NIL;
    free: CARDINAL := 0;
  END;
</PRE> <CODE>locTbl</CODE> is a list of locations which hold surrogates for objects
   owned by this address space.  It is required to prevent the cleanup
   of locations for which the transport is not maintaining any active
   server threads, (There are no other references to locations in this
   state.)


<P><PRE>TYPE
  ExportInfo = BRANDED OBJECT
    typeInfo: TypeInfo;
    &lt;* LL &gt;= {mu} *&gt;
    pinCount: CARDINAL := 0;(* # of incomplete marshalling actions from owner +
      	      	      	       # of dirty locations for this object *)
  END;
</PRE> For any exported concrete object c, writing c.xi = NARROW (c.r, ExportInfo),
<P>
   c.xi.pinCount =  # loc: Location st. ( c.w in domain(loc.exports) /\
                                         loc.exports[c.w].dirty )
                 + # incomplete outbound marshalling attempts for c from
                     this address space (which is c's owner)
<P>
   c is `exported' iff c.w # WireRep.NullT. 

<P><PRE>TYPE
  AgentT = ST OBJECT
    table: TextRefTbl.T;
  OVERRIDES
    get := AgentGet;
    put := AgentPut;
    getAdr := AgentGetAdr;
    dirty := AgentDirty;
    clean := AgentClean;
  END;

VAR  &lt;* LL &gt;= {mu} *&gt;
  started: BOOLEAN := FALSE;
  localAgentT: AgentT;
</PRE>------------------------- exports to NetObjRT ----------------------------

<P><PRE>PROCEDURE <A NAME="FindTarget"><procedure>FindTarget</procedure></A>(
    wrep: WireRep.T;
    stubProt: StubProtocol;
    VAR dispatcher: Dispatcher) : NetObj.T
    RAISES {NetObj.Error} =
  &lt;* LL.sup &lt; mu *&gt;
  VAR oe: ObjElem.T;
  BEGIN
    LOCK mu DO
      IF NOT started THEN RuntimeInit(); END;
      IF NOT objTbl.get(wrep, oe) OR oe.ref = NIL THEN
        RaiseError(NetObj.MissingObject);
      END;
      dispatcher := FindDispatcher(oe.ref.r, stubProt);
      IF dispatcher = NIL THEN RaiseError(MissingDispatcher); END;
      RETURN oe.ref;
    END;
  END FindTarget;

PROCEDURE <A NAME="FindDispatcher"><procedure>FindDispatcher</procedure></A>(exp: ExportInfo; stubProt: StubProtocol): Dispatcher =
  VAR tt := exp.typeInfo;
  BEGIN
    FOR i := 0 TO LAST(tt.vers) DO
      IF stubProt = tt.vers[i] THEN RETURN tt.procs[i]; END;
    END;
    RETURN NIL;
  END FindDispatcher;

PROCEDURE <A NAME="Find"><procedure>Find</procedure></A> (wrep: WireRep.T; loc: Transport.Location): NetObj.T
    RAISES {NetObj.Error, Thread.Alerted} =
  &lt;* LL.sup &lt; mu *&gt;
  VAR
    oe: ObjElem.T;
    res: NetObj.T;
    ts: EventID;
  BEGIN
    LOCK mu DO
      IF NOT started THEN RuntimeInit(); END;
      WHILE objTbl.get(wrep, oe) DO
      	(* concrete object ?*)
      	IF oe.ref # NIL THEN
      	  &lt;* ASSERT TYPECODE(oe.ref.r) = TYPECODE(ExportInfo) *&gt;
          (* Note that we are not logging concrete object lookup *)
      	  RETURN oe.ref
      	ELSE
      	  IF NOT oe.ready THEN
      	    Thread.Wait(mu, cond)
      	    (* reenter loop; last attempt at surrogate creation might
               have failed, so we have to test wrep again. *)
      	  ELSE
      	    res := WeakRef.ToRef(oe.weakRef);
      	    IF res # NIL THEN
              RETURN res;
      	    ELSE
      	      EXIT;
      	      (* the cleanup for val.weakRef's death is scheduled but has
      	    	 not yet started.  There is no sensible way to resurrect
      	    	 the old surrogate at this stage. *)
      	    END;
      	  END;
      	END;
      END;
      (* make a new surrogate, possibly overwriting a dead old one *)
      oe.ref := NIL;
      oe.ready := FALSE;
      EVAL objTbl.put(wrep, oe);
      ts := NextEventID();
    END;
    TRY
      res := NIL;
      res := NewSrgt(wrep, loc, ts);
    FINALLY
      LOCK mu DO
        IF res # NIL THEN
      	  (* no exception was raised *)
      	  oe.weakRef := WeakRef.FromRef(res, CleanupSrgt);
      	  oe.ready := TRUE;
          EVAL objTbl.put(wrep, oe);
        ELSE
      	  (* an exception was raised or NewSrgt returned NIL *)
          EVAL objTbl.delete(wrep, oe);
      	  VAR r: REFANY; loc: Transport.Location;
          BEGIN
	    IF spaceTbl.get(WireRep.GetSpaceID(wrep), r) THEN
              loc := TransportRegistry.LocationFromAdr(r);
              IF loc # NIL THEN CleanerEnqueue(loc, wrep, TRUE); END;
      	    END;
            (* else we can't make a special for owner(wrep).  This
               implies we've never been able to make a dirty call,
               and need not send a clean. *)
          END;
        END;
      END;
      Thread.Broadcast(cond);
    END;
    RETURN res;
  END Find;

PROCEDURE <A NAME="InsertAndPin"><procedure>InsertAndPin</procedure></A> (o: NetObj.T) : WireRep.T =
  &lt;* LL.sup &lt; mu *&gt;
  VAR oe: ObjElem.T;
  BEGIN
    TYPECASE o.r OF
    | NULL, ExportInfo =&gt;
      LOCK mu DO
	IF NOT started THEN RuntimeInit(); END;
	IF o.w = WireRep.NullT THEN
	  (* need to export this (concrete) object *)
      	  IF o.r = NIL THEN
	    o.r := NewExportInfo(TYPECODE(o));
      	  ELSE
      	    &lt;* ASSERT NARROW(o.r, ExportInfo).pinCount = 0 *&gt;
      	  END;
	  oe.ref := o;
	  o.w := WireRep.New();
	  EVAL objTbl.put(o.w, oe);
	END;
	INC(NARROW(o.r, ExportInfo).pinCount);
	(* o will live whilst pinCount &gt; 0 since =&gt; in range(objTbl) *)
      END;
      RETURN o.w;
    | Transport.Location =&gt;
      RETURN o.w; (* surrogate *)
    ELSE
      &lt;* NOWARN *&gt; Die();
    END;
  END InsertAndPin;

PROCEDURE <A NAME="Unpin"><procedure>Unpin</procedure></A>(READONLY arr: ARRAY OF NetObj.T) =
  &lt;* LL.sup &lt; mu *&gt;
  BEGIN
    LOCK mu DO
      FOR i := 0 TO LAST(arr) DO
      	TYPECASE arr[i].r OF
      	| ExportInfo(ei) =&gt;
      	  DEC(ei.pinCount);
      	  CheckedRemove(arr[i]);
      	ELSE (* skip *)
      	END;
      END;
    END;
  END Unpin;

PROCEDURE <A NAME="DeadLocation"><procedure>DeadLocation</procedure></A>(loc: Transport.Location; st: OwnerState) =
  &lt;* LL.sup &lt; mu *&gt;
  VAR
    wrep: WireRep.T;
    de: DirtyElem.T;
    it: DirtyTbl.Iterator;
    oe: ObjElem.T;
    list: RefList.T;
    n: Notifier;
    obj: NetObj.T;
  BEGIN
    LOCK mu DO
      IF loc.exports # NIL THEN
      	it := loc.exports.iterate();
        WHILE it.next(wrep, de) DO
          IF de.dirty THEN
            IF NOT objTbl.get(wrep, oe) THEN Die(); END;
      	    DEC(NARROW(oe.ref.r, ExportInfo).pinCount);
            CheckedRemove(oe.ref);
          END;
        END;
      	locTbl.locs[loc.locTblIndex] := NIL;
        locTbl.free := MIN(locTbl.free, loc.locTblIndex);
        loc.exports := NIL;
      END;
      list := loc.notifiers;
      IF st = OwnerState.Dead THEN loc.isDead := TRUE; END;
    END;
    WHILE list # NIL DO
      n := list.head;
      obj := WeakRef.ToRef(n.wr);
      IF obj # NIL THEN n.cl.notify(obj, st); END;
      list := list.tail;
    END;
  END DeadLocation;

&lt;* INLINE *&gt;
PROCEDURE <A NAME="CheckedRemove"><procedure>CheckedRemove</procedure></A>(c: NetObj.T) =
  &lt;* LL.sup = mu *&gt;
  VAR xi: ExportInfo := c.r;
      waste: ObjElem.T;
  BEGIN
    IF xi.pinCount = 0 THEN
      IF NOT objTbl.delete(c.w, waste) THEN Die(); END;
      c.w := WireRep.NullT;
    END;
  END CheckedRemove;

PROCEDURE <A NAME="CleanupSrgt"><procedure>CleanupSrgt</procedure></A> (READONLY w: WeakRef.T; x: REFANY) =
  &lt;* LL.sup &lt; mu *&gt;
  VAR
    oe: ObjElem.T;
    s: NetObj.T := x;
    loc: Transport.Location := s.r;
  BEGIN
    WITH wrep = s.w DO
      LOCK mu DO
        s.r := NIL;
        IF NOT objTbl.get(wrep, oe) THEN
      	  RETURN; (* beaten by fresh unmarshal, death, cleanup sequence *)
      	END;
	&lt;* ASSERT oe.ref = NIL *&gt;
	IF NOT oe.ready OR w # oe.weakRef THEN
      	      	      	(*  WeakRef.ToRef(oe.weakRef) # NIL also works *)
      	  RETURN; (* beaten by fresh unmarshal *)
      	END;
	EVAL objTbl.delete(wrep, oe);
	CleanerEnqueue(loc, wrep, FALSE);
      END;
    END;
  END CleanupSrgt;

TYPE
  Cleaner = Thread.Closure OBJECT
    loc: Transport.Location;
    queue, queueTail: CleanQElem := NIL;
  OVERRIDES
    apply := CleanerApply;
  END;

TYPE
  CleanQElem = REF RECORD
    next: CleanQElem := NIL;
    elem: CleanElem;
    strong: BOOLEAN;
  END;

PROCEDURE <A NAME="CleanerEnqueue"><procedure>CleanerEnqueue</procedure></A>(
    loc: Transport.Location; wrep: WireRep.T; strong: BOOLEAN) =
  &lt;* LL.sup = mu *&gt;
  VAR e := NEW(CleanQElem,
              elem := CleanElem{wrep, NextEventID()}, strong := strong);
  BEGIN
    IF loc.isDead THEN RETURN; END;
    IF loc.cleaner = NIL THEN
      loc.cleaner := NEW(Cleaner, loc := loc, queue := e, queueTail := e);
      EVAL Thread.Fork(loc.cleaner);
    ELSE
      loc.cleaner.queueTail.next := e;
      loc.cleaner.queueTail := e;
    END;
  END CleanerEnqueue;

PROCEDURE <A NAME="CleanerApply"><procedure>CleanerApply</procedure></A>(cl: Cleaner): REFANY =
  CONST tries = 3;
  (* The next call after a failed call is guaranteed to make a new connection.
     If that connection cannot be made, the location will be declare dead. *)
  VAR
    st := New(cl.loc);
    nElem: CARDINAL;
    batch: ARRAY [0..DefaultBatchLen-1] OF CleanElem;
    ok := TRUE;
    strong: BOOLEAN;
  BEGIN
    LOOP
      nElem := 0;
      LOCK mu DO
        WHILE ok AND cl.queue # NIL AND nElem &lt; NUMBER(batch)
                 AND (nElem = 0 OR strong = cl.queue.strong) DO
          batch[nElem] := cl.queue.elem;
          strong := cl.queue.strong;
          INC(nElem);
          cl.queue := cl.queue.next;
        END;
        IF nElem = 0 THEN cl.loc.cleaner := NIL; cl.loc := NIL; EXIT; END;
      END;
      FOR try := 1 TO tries DO
        IF cl.loc.isDead THEN EXIT; END;
        TRY
          st.clean(SUBARRAY(batch, 0, nElem), strong);
          EXIT;
        EXCEPT
        | NetObj.Error, Thread.Alerted  =&gt;
            IF try = tries THEN
              ok := FALSE;   (* give up !!! *)
            ELSE
              Thread.Pause(6.0d1);
            END;
        END;
      END;
    END;
    RETURN NIL;
  END CleanerApply;
</PRE>------------------------- exports to NetObjNotifier ----------------------

<P><PRE>PROCEDURE <A NAME="AddNotifier"><procedure>AddNotifier</procedure></A>(obj: NetObj.T; cl: NotifierClosure) =
  &lt;* LL.sup &lt; mu *&gt;
  VAR n: Notifier;
  BEGIN
    LOCK mu DO
      TYPECASE obj.r OF
      | NULL =&gt;
      | Transport.Location(loc) =&gt;
          n := NEW(Notifier, wr := WeakRef.FromRef(obj), cl := cl);
          loc.notifiers := RefList.Cons(n, loc.notifiers);
      ELSE
      END;
    END;
  END AddNotifier;
</PRE>------------------------- exports to StubLib -----------------------------

<P><PRE>PROCEDURE <A NAME="Register"><procedure>Register</procedure></A>(
    pureTC: Typecode;
    vers: StubProtocol;
    surrTC: Typecode;
    disp  : Dispatcher) =
  &lt;* LL.sup &lt; mu *&gt;
  VAR
    info: TypeInfo;
    r: REFANY;
  BEGIN
    LOCK mu DO
      IF typeTbl.get(pureTC, r) THEN
        info := NARROW(r, TypeInfo);
      ELSE
        info := NEW(TypeInfo, pureTC := pureTC,
                              fp := RTTypeFP.ToFingerprint(pureTC));
        EVAL typeTbl.put(pureTC, info);
        EVAL fpToTc.put(info.fp, info);
      END;
      VAR n := info.nvers; BEGIN
        IF n = NUMBER(info.vers) THEN Die(); END;
        info.vers[n] := vers;
        info.procs[n] := disp;
        info.surrTCs[n] := surrTC;
        INC(info.nvers);
      END;
    END;
  END Register;

PROCEDURE <A NAME="BuildFpTower"><procedure>BuildFpTower</procedure></A>(tt: TypeInfo) : FpTower =
  &lt;* LL.sup = mu *&gt;
  VAR n: CARDINAL := 0;
      tc: Typecode := tt.pureTC;
      r: REFANY;
  BEGIN
    IF tt.fpTower = NIL THEN
      WHILE tc # TYPECODE(NetObj.T) DO
        IF typeTbl.get(tc, r) THEN INC(n); END;
        tc := RTType.Supertype(tc);
        IF tc = RTType.NoSuchType THEN Die(); END;
      END;
      IF n # 0 THEN
        tt.fpTower := NEW(FpTower, n);
        n := 0;
        tc := tt.pureTC;
        WHILE tc # TYPECODE(NetObj.T) DO
          IF typeTbl.get(tc, r) THEN
            tt.fpTower[n] := NARROW(r, TypeInfo).fp;
            INC(n);
          END;
          tc := RTType.Supertype(tc);
          IF tc = RTType.NoSuchType THEN Die(); END;
        END;
      END;
    END;
    RETURN tt.fpTower;
  END BuildFpTower;
</PRE>------------------------------ utilities ---------------------------------

<P> <CODE>NewSrgt(wrep, loc)</CODE> returns a surrogate for the object represented by
   <CODE>wrep</CODE>, assuming that <CODE>loc</CODE> is a location which issues connections to
   the address space from which <CODE>wrep</CODE> was received.  This need not be a
   location of owner of the object. 

<P><PRE>PROCEDURE <A NAME="NewSrgt"><procedure>NewSrgt</procedure></A>(
    READONLY wrep: WireRep.T; loc: Transport.Location; ts: EventID) : NetObj.T
    RAISES {NetObj.Error, Thread.Alerted} =
  &lt;* LL.sup &lt; mu *&gt;
  VAR
    st := SpaceToSpecial(WireRep.GetSpaceID(wrep), loc);
    tc: CARDINAL;
    fpTower: FpTower;
    vers: ARRAY [0..MaxVersions-1] OF Int32;
  BEGIN
    fpTower := st.dirty(wrep, ts, vers);
    tc := TowerToSurrogateTC(fpTower, vers);
    VAR res: NetObj.T := RTAllocator.NewTraced(tc); BEGIN
      res.w := wrep;
      res.r := st.r;
      RETURN res
    END
  END NewSrgt;

PROCEDURE <A NAME="SpaceToSpecial"><procedure>SpaceToSpecial</procedure></A>(space: SpaceID.T; loc: Transport.Location) : ST
    RAISES {NetObj.Error, Thread.Alerted} =
    &lt;* LL.sup &lt; mu *&gt;
  VAR r: REFANY;
      adr: NetObj.Address;
      found: BOOLEAN;
      rloc: Transport.Location;
  BEGIN
    LOCK mu DO
      found := spaceTbl.get(space, r);
    END;
    IF found THEN
      adr := r;
    ELSE
      adr := New(loc).getAdr(space);
      LOCK mu DO
        EVAL spaceTbl.put(space, adr);
      END;
    END;
    rloc := TransportRegistry.LocationFromAdr(adr);
    IF rloc = NIL THEN RaiseError(NetObj.NoTransport); END;
    RETURN New(rloc);
  END SpaceToSpecial;

PROCEDURE <A NAME="TowerToSurrogateTC"><procedure>TowerToSurrogateTC</procedure></A>(fpTower: FpTower; VAR vers: VersionList): Typecode
  &lt;* LL.sup &lt; mu *&gt; =
  VAR r: REFANY;
      i: CARDINAL := 0;
      tc: Typecode := TYPECODE(NetObj.T);
      firstInfo: TypeInfo := NIL;
  BEGIN
    LOCK mu DO
      IF fpTower # NIL THEN
        REPEAT
          IF fpToTc.get(fpTower[i], r) THEN
            (* r = NIL means no fingerprint match *)
            IF r = NIL THEN EXIT; END;
            IF firstInfo = NIL THEN firstInfo := r; END;
            IF MatchVersion(r, vers, tc) THEN EXIT; END;
          END;
          INC(i)
        UNTIL i = NUMBER(fpTower^);
        IF i # 0 THEN
          EVAL fpToTc.put(fpTower[0], firstInfo);
        END;
      END;
    END;
    RETURN tc;
  END TowerToSurrogateTC;

PROCEDURE <A NAME="MatchVersion"><procedure>MatchVersion</procedure></A>(
    info: TypeInfo; VAR vers: VersionList;
    VAR (*out*) tc: Typecode) : BOOLEAN =
  BEGIN
    FOR i := 0 TO LAST(vers) DO
      FOR j := 0 TO info.nvers-1 DO
        IF vers[i] = info.vers[j] THEN
          tc := info.surrTCs[j]; RETURN TRUE;
        END;
      END;
    END;
    RETURN FALSE;
  END MatchVersion;

PROCEDURE <A NAME="NewExportInfo"><procedure>NewExportInfo</procedure></A>(tc: Typecode) : ExportInfo =
  &lt;* LL.sup = mu *&gt;
  VAR r: REFANY; res: ExportInfo;
  BEGIN
    IF tc = RTType.NoSuchType THEN Die(); END;
    IF typeTbl.get(tc, r) THEN
      res := NEW(ExportInfo, typeInfo := r);
    ELSE
      res := NewExportInfo(RTType.Supertype(tc));
      EVAL typeTbl.put(tc, res.typeInfo);
    END;
    RETURN res;
  END NewExportInfo;
</PRE>----------------------- exports to SpecialObj -----------------------------

<P> for now we're assuming that the NetObj runtime needn't be 'started'
   until either NetObj.Import or NetObj.Export are called.  Both of those
   procedures must invoke SpecialObj.New to do anything.
<P>
   This might need to be made more explicit at some later time.


<P><PRE>PROCEDURE <A NAME="New"><procedure>New</procedure></A>(loc: Transport.Location) : ST =
  &lt;* LL.sup ???? *&gt;
  VAR st: ST;
  BEGIN
    st := RTAllocator.NewTraced(TYPECODE(Surrogate));
    st.w := WireRep.SpecialT;
    st.r := loc;
    RETURN st;
  END New;
</PRE> special object init + methods 

<P><PRE>PROCEDURE <A NAME="InitAgent"><procedure>InitAgent</procedure></A>() =
  &lt;* LL.sup = mu *&gt;
  BEGIN
    localAgentT := NEW(AgentT,
      table := NEW(TextRefTbl.Default).init(),
      r := NewExportInfo(TYPECODE(AgentT)));
    (* Note that this object is inserted into the table without
       filling in the st.w field.  It is never removed.
       It could be inserted into the table in another slot under
       some other concrete non-special wire rep. *)
    EVAL objTbl.put(WireRep.SpecialT, ObjElem.T{ref := localAgentT});
  END InitAgent;

TYPE
  Note = NotifierClosure OBJECT
    name: TEXT;
  OVERRIDES
    notify := DeadEntry;
  END;

PROCEDURE <A NAME="DeadEntry"><procedure>DeadEntry</procedure></A>(n: Note; obj: NetObj.T; &lt;*UNUSED*&gt; st: OwnerState) =
    &lt;* LL.sup &lt; mu *&gt;
  VAR r: REFANY;
  BEGIN
    LOCK mu DO
      IF localAgentT.table.get(n.name, r) AND r = obj THEN
        EVAL localAgentT.table.delete(n.name, r);
      END;
    END;
  END DeadEntry;

PROCEDURE <A NAME="AgentGet"><procedure>AgentGet</procedure></A>(t: AgentT; name: TEXT) : NetObj.T =
    &lt;* LL.sup &lt; mu *&gt;
  VAR r: REFANY;
  BEGIN
    LOCK mu DO
      IF NOT t.table.get(name, r) THEN
        RETURN NIL;
      ELSE
        RETURN r;
      END;
    END;
  END AgentGet;

PROCEDURE <A NAME="AgentPut"><procedure>AgentPut</procedure></A>(t: AgentT; name: TEXT; obj: NetObj.T) =
    &lt;* LL.sup &lt; mu *&gt;
  BEGIN
    IF obj # NIL THEN AddNotifier(obj, NEW(Note, name := name)); END;
    LOCK mu DO EVAL t.table.put(name, obj); END;
  END AgentPut;

PROCEDURE <A NAME="AgentGetAdr"><procedure>AgentGetAdr</procedure></A>(
    &lt;*UNUSED*&gt; t: AgentT; sp: SpaceID.T) : NetObj.Address =
  &lt;* LL.sup &lt; mu *&gt;
  VAR r: REFANY;
  BEGIN
    LOCK mu DO
      IF spaceTbl.get(sp, r) THEN
        RETURN r;
      ELSE
        RETURN NIL;
      END;
    END;
  END AgentGetAdr;

PROCEDURE <A NAME="AgentDirty"><procedure>AgentDirty</procedure></A>(
    &lt;*UNUSED*&gt; t: AgentT;
    wrep: WireRep.T; eventID: EventID;
    VAR (*OUT*) vers: VersionList;
    loc: Transport.Location := NIL): FpTower
    RAISES {NetObj.Error} =
  &lt;* LL.sup &lt; mu *&gt;
  VAR
    oe: ObjElem.T;
    de: DirtyElem.T;
    rti: REFANY := NIL;
    c: NetObj.T;
    bump: BOOLEAN; (* did we make a clean -&gt; dirty transition ? *)
  BEGIN
    LOCK mu DO
      IF NOT objTbl.get(wrep, oe) OR (oe.ref = NIL) THEN
        RaiseError(NetObj.MissingObject);
      END;
      (* loc # NIL because the Agent stubs provide it *)
      c := oe.ref;
      IF NOT typeTbl.get(TYPECODE(c), rti) THEN
        (* There must be an entry for &quot;TYPECODE(c)&quot;, since &quot;c&quot; has been
           marshaled by this address space *)
        Die();
      END;
      IF loc.exports = NIL THEN
        loc.exports := NEW(DirtyTbl.Default).init();
        AddToLocTbl(loc);
      END;
      IF loc.exports.get(c.w, de) THEN
      	IF EventLE(eventID, de.ts) THEN
      	  (* dirty call orphaned or beaten by a clean - ignore *)
      	  RaiseError(NetObj.CommFailure);
      	ELSIF de.keep THEN
      	  bump := NOT de.dirty;
      	  de := DirtyElem.T {dirty := TRUE, keep := TRUE, ts := eventID};
      	ELSE
      	  &lt;* ASSERT de.dirty *&gt;
      	  bump := FALSE;
    	  de := DirtyElem.T {dirty := TRUE, keep := FALSE, ts := eventID};
      	END;
      ELSE
      	bump := TRUE;
    	de := DirtyElem.T {dirty := TRUE, keep := FALSE, ts := eventID};
      END;
      EVAL loc.exports.put(c.w, de);
      IF bump THEN
        INC(NARROW(c.r, ExportInfo).pinCount);
      END;
      VAR tt := NARROW(c.r, ExportInfo).typeInfo;
      BEGIN
        IF tt.nvers &gt;= NUMBER(vers) THEN
          vers := SUBARRAY(tt.vers, 0, NUMBER(vers));
        ELSE
          vers := tt.vers;
          FOR i := tt.nvers TO LAST(vers) DO vers[i] := NullStubProtocol; END;
        END;
        RETURN BuildFpTower(tt);
      END;
    END;
  END AgentDirty;

PROCEDURE <A NAME="AgentClean"><procedure>AgentClean</procedure></A>(
    &lt;*UNUSED*&gt; t: AgentT;
    READONLY batch: CleanBatch; strong: BOOLEAN := FALSE;
    loc: Transport.Location := NIL) =
  &lt;* LL.sup &lt; mu *&gt;
  VAR
    oe: ObjElem.T;
    de, wasteDE: DirtyElem.T;
    c: NetObj.T;
    removals: BOOLEAN := FALSE;
  BEGIN
    LOCK mu DO
      FOR i := 0 TO LAST(batch) DO
        IF objTbl.get(batch[i].wrep, oe) AND (oe.ref # NIL) THEN
          (* we ignore a missing object here *)
          c := oe.ref;
          IF loc.exports # NIL THEN
            IF loc.exports.get(c.w, de) AND
                 NOT EventLE(batch[i].id, de.ts) THEN
              IF strong OR de.keep THEN
      	        EVAL loc.exports.put(c.w,
 	          DirtyElem.T{
                    dirty := FALSE, keep := TRUE, ts := batch[i].id})
              ELSE
      	        EVAL loc.exports.delete(c.w, wasteDE);
              END;
      	      IF de.dirty THEN
      	        removals := TRUE;
                DEC(NARROW(c.r, ExportInfo).pinCount);
      	        CheckedRemove(c);
      	      END;
            END;
          ELSE
            (* clean call orphaned or beaten by a dirty - ignore *)
          END;
        END;
      END;
      IF removals AND loc.exports.size() = 0 THEN
        locTbl.locs[loc.locTblIndex] := NIL;
        locTbl.free := MIN(locTbl.free, loc.locTblIndex);
      	loc.exports := NIL;
      END;
    END;
  END AgentClean;
</PRE>----------------------- SpecialObj.EventIDs -----------------------------

<P><PRE>VAR
  eCount := EventID {0, 0}; &lt;* LL &gt; { mu } *&gt;
  (* two bits of count thrown away in the interests of ease of inspection
     by people *)

PROCEDURE <A NAME="NextEventID"><procedure>NextEventID</procedure></A> (): EventID =
  &lt;* LL.sup = mu *&gt;
  BEGIN
    IF eCount[0] = LAST(Int32) THEN
      INC(eCount[1]);
      eCount[0] := 0;
    ELSE
      INC(eCount[0]);
    END;
    RETURN eCount;
  END NextEventID;

PROCEDURE <A NAME="EventLE"><procedure>EventLE</procedure></A> (e1, e2: EventID): BOOLEAN =
  BEGIN
    IF e1[1] = e2[1] THEN
      IF e1[0] &lt;= e2[0] THEN RETURN TRUE
      ELSE RETURN FALSE
      END;
    ELSIF e1[1] &lt; e2[1] THEN RETURN TRUE
    ELSE RETURN FALSE
    END;
  END EventLE;
</PRE>----------------------- exports to NCGMonitor ----------------------------

<P><PRE>PROCEDURE <A NAME="MonitorDump"><procedure>MonitorDump</procedure></A> (): Dump =
  &lt;* LL.sup &lt; mu *&gt;
  VAR res := NEW(Dump);
      it: ObjTbl.Iterator;
      wrep: WireRep.T;
      oe: ObjElem.T;

  PROCEDURE DumpLoc (loc: Transport.Location; &lt;*UNUSED*&gt; cl: REFANY): BOOLEAN=
    VAR
      ld := NEW(LDump);
      wrep: WireRep.T;
      de: DirtyElem.T;
      it: DirtyTbl.Iterator;
    BEGIN
      ld.info := loc.getInfo();
      ld.ep   := loc.getEp();
      IF loc.exports # NIL THEN
	it := loc.exports.iterate();
        WHILE it.next(wrep, de) DO
	  ld.exports := RefList.Cons(
            NEW (DDump, wrep := wrep, de := de), ld.exports);
        END;
      END;
      res.locs := RefList.Cons(ld, res.locs);
      RETURN FALSE;
    END DumpLoc;

  (* &lt;* FATAL ANY *&gt; *)
  BEGIN
    LOCK mu DO
      IF NOT started THEN RuntimeInit(); END;
      it := objTbl.iterate();
      WHILE it.next(wrep, oe) DO
        IF oe.ref # NIL THEN
      	  (* exported concrete object *)
      	  VAR c := oe.ref; xi := NARROW(c.r, ExportInfo); tc := TYPECODE(c);
          BEGIN
      	    &lt;* ASSERT wrep = c.w OR wrep = WireRep.SpecialT *&gt;
	    res.concs := RefList.Cons(
              NEW(CDump,
	        obj := wrep, fp := RTTypeFP.ToFingerprint(tc),
                typeName := RTTypeSRC.TypecodeName(tc),
	        pinCount := xi.pinCount),
              res.concs);
      	  END;
        ELSIF oe.ready THEN
      	  VAR s: NetObj.T := WeakRef.ToRef(oe.weakRef); tc := TYPECODE(s);
          BEGIN
            IF s # NIL THEN
      	      (* live surrogate object *)
      	      &lt;* ASSERT wrep = s.w *&gt;
      	      res.srgts := RefList.Cons(
                NEW(SDump,
      	          obj := s.w, fp := RTTypeFP.ToFingerprint(tc),
                  typeName := RTTypeSRC.TypecodeName(tc),
      	          owner := NARROW(s.r, Transport.Location).getEp()),
                res.srgts);
      	    END;
      	  END;
        ELSE (* creating a surrogate *)
        END;
      END;
      VAR it := TransportRegistry.Iterate (); tr: Transport.T; BEGIN
        WHILE it.next (tr) DO tr.enumerateLocs (DumpLoc) END;
      END;
      RETURN res;
    END;
  END MonitorDump;

PROCEDURE <A NAME="MonitorDumpNames"><procedure>MonitorDumpNames</procedure></A> (): RefList.T =
  &lt;* LL.sup &lt; mu *&gt;
  VAR
    res: RefList.T := NIL;
    key: TEXT; r: REFANY;
    it: TextRefTbl.Iterator;
  BEGIN
    LOCK mu DO
      IF NOT started THEN RuntimeInit(); END;
      it := localAgentT.table.iterate();
      WHILE it.next(key, r) DO
        VAR w: WireRep.T; BEGIN
          IF r = NIL THEN
            w := WireRep.NullT;
          ELSE
            w := NARROW(r, NetObj.T).w;
          END;
          res := RefList.Cons(NEW(NDump, name := key, obj := w), res);
        END;
      END;
      RETURN res;
    END;
  END MonitorDumpNames;
</PRE>-------------------------- initialization -------------------------------

<P><PRE>PROCEDURE <A NAME="RuntimeInit"><procedure>RuntimeInit</procedure></A>() =
  &lt;* LL.sup = mu *&gt;
  BEGIN
    objTbl := NEW(ObjTbl.Default).init();
    spaceTbl := NEW(FPRefTbl.Default).init();
    EVAL spaceTbl.put(SpaceID.Mine(), TransportRegistry.LocalAdr());
    InitAgent();
    started := TRUE;
  END RuntimeInit;

PROCEDURE <A NAME="AddToLocTbl"><procedure>AddToLocTbl</procedure></A>(loc: Transport.Location) =
  VAR ol := locTbl.locs;
  BEGIN
    IF ol = NIL THEN
      locTbl.free := 0;
      locTbl.locs := NEW(REF ARRAY OF Transport.Location, 10);
      FOR i := 0 TO LAST(locTbl.locs^) DO locTbl.locs[i] := NIL; END;
    ELSE
      WHILE locTbl.locs[locTbl.free] # NIL DO
        INC(locTbl.free);
        IF locTbl.free = NUMBER(locTbl.locs^) THEN
          locTbl.locs := NEW(REF ARRAY OF Transport.Location, NUMBER(ol^) * 2);
          SUBARRAY(locTbl.locs^, 0, NUMBER(ol^)) := ol^;
          FOR i := NUMBER(ol^) TO LAST(locTbl.locs^) DO
            locTbl.locs[i] := NIL;
          END;
        END;
      END;
    END;
    locTbl.locs[locTbl.free] := loc;
    loc.locTblIndex := locTbl.free;
  END AddToLocTbl;

PROCEDURE <A NAME="RaiseError"><procedure>RaiseError</procedure></A>(a: Atom.T) RAISES {NetObj.Error} =
  BEGIN
    RAISE NetObj.Error(AtomList.List1(a));
  END RaiseError;

EXCEPTION FatalError;

PROCEDURE <A NAME="Die"><procedure>Die</procedure></A>() RAISES {} =
  &lt;* FATAL FatalError *&gt;
  BEGIN
    RAISE FatalError;
  END Die;

BEGIN
  &lt;* ASSERT BITSIZE (Int32) = 32 *&gt;
  (* TODO: remove this assertion when the compiler problem mentioned in
     SpecialObj.i3 is fixed. *)
  MissingDispatcher := Atom.FromText(&quot;NetObj.MissingDispatcher&quot;);
  typeTbl := NEW(IntRefTbl.Default).init();
  fpToTc := NEW(FPRefTbl.Default).init();
END NetObjRT.
</PRE>  old version of TowerToSurrogateTC
<P>
PROCEDURE TowerToSurrogateTC(fpTower: FpTower; VAR vers: VersionList): Typecode
  &lt;* LL.sup &lt; mu *&gt; =
  VAR tc: Typecode;
      r: REFANY;
      firstInfo: TypeInfo := NIL;
  BEGIN
    LOCK mu DO
      IF fpToTc.get(fpTower[0], r) THEN
        RETURN MatchVer(r);
      END;
      FOR i := 0 TO LAST(fpTower^) DO
        tc := RTTypeFP.FromFingerprint(fpTower[i]);
        IF tc # RTType.NoSuchType THEN
          IF typeTbl.get(tc, r) THEN
            info := NARROW(r, TypeInfo);
            EVAL fpToTc.put(fpTower[0], info);
            RETURN MatchVer(info);
          END;
        END;
      END;
    END;
    Die();
  END TowerToSurrogateTC;


<P>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
