<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/NetStream.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/NetStream.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> NetStream.i3 </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>NetStream</CODE> interface describes the marshaling of readers and
   writers, and provides procedures that you will need to use if
   you plan to reuse a stream after marshaling it.
<P>
   The network object runtime allows subtypes of <CODE>Rd.T</CODE> and <CODE>Wr.T</CODE> to be
   marshaled as parameters and as results of remote method invocation.
   To communicate a reader or writer from one program to
   another, a surrogate stream is created in the receiving program.
   We call the original reader or writer the concrete stream.
   Data is copied over the network between the concrete stream and the
   surrogate stream.  Surrogate streams are free-standing entities,
   valid beyond the scope of the remote call that produced them.
   Data can be transmitted on a surrogate stream at close to the
   bandwidth supported by the underlying transport.  \index{buffered
   streams}\ttindex{Rd.T}\ttindex{Wr.T}
<P>
   The initial position of the surrogate reader or writer equals the
   position of the corresponding concrete stream at the time it was
   marshaled.  All surrogate readers and writers are unseekable.  Data
   is transferred between surrogates and concrete streams in
   background.  Therefore, undefined behaviour will result if you 1)
   perform local operations on the concrete stream while a surrogate
   for it exists, or 2) create two surrogates for the same stream by
   marshaling it twice.  There is a mechanism, described below, for
   shutting down a surrogate stream so that the underlying stream can
   be remarshaled.
<P>
   Calling <CODE>Wr.Flush</CODE> on a surrogate writer flushes all
   outstanding data to the concrete writer and flushes the concrete
   writer.  Calling <CODE>Wr.Close</CODE> flushes and then closes both the
   surrogate and the concrete writer.  Similarly, a call on
   <CODE>Rd.Close</CODE> on a surrogate closes both readers.
<P>
   Clients who marshal streams retain responsibility for closing them.
   For example, <CODE>Rd.Close</CODE> on a surrogate can fail due to the network,
   leaving the owner responsible for closing the concrete reader.
   The <CODE>WeakRef</CODE> interface can be used to register a GC cleanup
   procedure for this purpose.  
<P>
   The <CODE>ReleaseWr</CODE> procedure is used to shut down a surrogate
   writer so that the underlying writer can be reused.  It flushes
   any buffered data, closes the surrogate, and frees any network
   resources associated with the surrogate.  It leaves the concrete
   writer in a state where it can be reused locally or remarshaled.
<P>
   Similarly. the <CODE>ReleaseRd</CODE> procedure is used to shut down a
   surrogate reader so that the underlying reader can be reused.  It
   closes the surrogate, frees any network resources associated with
   the surrogate, and leaves the concrete reader in a state where it
   can be reused locally or remarshaled.  There is an important
   difference between releasing readers and writers: <CODE>ReleaseRd</CODE>
   discards any data buffered in the surrogate or in transit. 

<P><PRE>INTERFACE <interface><A HREF="VoucherStubs.m3">NetStream</A></interface>;

IMPORT <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

PROCEDURE <A HREF="VoucherStubs.m3#ReleaseRd">ReleaseRd</A>(rd: Rd.T)
    RAISES {Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> If <CODE>rd</CODE> is a surrogate reader, release all network
   resources associated with <CODE>rd</CODE>, discard all buffered data,
   close <CODE>rd</CODE>, but do not close the concrete reader for <CODE>rd</CODE>.
   This procedure is a no-op if <CODE>rd</CODE> is not a surrogate.
   \ttindex{NetStream.ReleaseRd} </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="VoucherStubs.m3#ReleaseWr">ReleaseWr</A>(wr: Wr.T)
    RAISES {Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> If <CODE>wr</CODE> is a surrogate writer, flush <CODE>wr</CODE>, release
   all network resources associated with <CODE>wr</CODE>, close <CODE>wr</CODE>,
   but do not close the concrete writer for <CODE>wr</CODE>.
   This procedure is a no-op if <CODE>wr</CODE> is not a surrogate.
   \ttindex{NetStream.ReleaseWr} </EM></BLOCKQUOTE><PRE>

END NetStream.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
