<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/Protocol.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/Protocol.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Protocol.i3 </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>Protocol</CODE> interface defines header formats of messages
   that encode remote method invocations and stream marshaling.
   Clients who wish to write optimized stubs that operate directly
   on transport connections should use the types in this interface
   to produce the appropriate wire representation. 
   
<P><PRE>INTERFACE <interface><A HREF="Protocol.m3">Protocol</A></interface>;

IMPORT <A HREF="StubLib.i3">StubLib</A>, <A HREF="WireRep.i3">WireRep</A>;

TYPE
  Header = StubLib.DataRep;
  Op = { MethodCall, Return, CallFailed, w1, w2, ResultAck,
            StreamData, StreamClose, StreamRelease,
            StreamOK, StreamError };
</PRE> This header appears in all messages.  The <CODE>intFmt</CODE>, <CODE>floatFmt</CODE>, and
   <CODE>charSet</CODE> fields of a <CODE>Header</CODE> indicate the native data representation
   of the sender.   For a header <CODE>hdr</CODE>, <CODE>VAL(hdr.private, Op)</CODE> indicates
   the message type as follows:
<P>
   <CODE>MethodCall</CODE> indicates a method invocation.  A header of type <CODE>CallHeader</CODE>
      (below) is expected.  It is followed by the arguments of the call.
      A reponse of type <CODE>Return</CODE> or <CODE>CallFailed</CODE> is expected.
<P>
   <CODE>Return</CODE> indicates a successful return from a method invocation.  The
      header is followed by marshaled results.  If the result contains
      a marshaled subtype of <CODE>NetObj.T</CODE>, a reponse of type <CODE>ResultAck</CODE>
      is expected. 
<P>
   <CODE>CallFailed</CODE> indicates that a remote method invocation failed,
      and that the message contains an <CODE>AtomList.T</CODE> which specifies the
      failure reason. 
<P>
   <CODE>ResultAck</CODE> indicates an acknowledgement for result marshaling where
      the results included a stubtype of <CODE>NetObj.T</CODE>.  This message
      type has null content.
<P>
   <CODE>StreamData</CODE> indicates that the message contains the characters
      for the source of a remote <CODE>Rd.T</CODE> or for the target of a
      remote <CODE>Wr.T</CODE>.  In the former case, the following message
      will be of type <CODE>StreamOK</CODE> or <CODE>StreamError</CODE> and this will
      indicate success or failure upon reading the concrete reader.
      In the latter case, target <CODE>Wr.T</CODE> should be flushed after the
      entire message is received and written to the target, and a
      <CODE>StreamOK</CODE> or <CODE>StreamError</CODE> response is expected.
<P>
   <CODE>StreamClose</CODE> indicates that the associated concrete <CODE>Rd.T</CODE> or
      <CODE>Wr.T</CODE> should be closed.  This message type has null content.
      A response message of <CODE>StreamOK</CODE> or <CODE>StreamError</CODE> is expected.
<P>
   <CODE>StreamRelease</CODE> indicates that the resources associated with
      a surrogate <CODE>Rd.T</CODE> or <CODE>Wr.T</CODE> should be released without closing
      the concrete stream.  This message type has null content.
      A response message of <CODE>StreamOK</CODE> or <CODE>StreamError</CODE> is expected.
<P>
   <CODE>StreamOK</CODE> indicates that no error occured while reading,
      writing, flushing, closing, or releasing the concrete target
      of a surrogate <CODE>Rd.T</CODE> or <CODE>Wr.T</CODE>.   If the target is a writer,
      this message type is sent in response to a <CODE>StreamData</CODE> message.
      If the target is a reader, then this message type follows the
      successful marshaling of reader data.  In either case, a <CODE>StreamOK</CODE>
      message can be sent in response to a <CODE>StreamClose</CODE> or <CODE>StreamRelease</CODE>
      message.  The message itself has no content.
<P>
   <CODE>StreamError</CODE> indicates that an error occured while reading,
      writing, flushing, closing, or releasing  the concrete target of
      a surrogate <CODE>Rd.T</CODE> or <CODE>Wr.T</CODE>.  The message contains an <CODE>AtomList.T</CODE>
      describing the failure.
<P>
   <CODE>w1</CODE> and <CODE>w2</CODE> are placeholders for protocol backward compatibility.


<P>  <PRE>CallHeader = RECORD
    hdr: Header;
    prot: StubLib.StubProtocol;
    obj: WireRep.T;
  END;
</PRE> A <CODE>CallHeader</CODE> prefixes every message initiating a remote method call.
   It contains a <CODE>Header</CODE>, the stub protocol employed by the invoker's stub
   (in native byte order), and the object ID of the target object. 

<P>  <PRE>MsgHeader = RECORD
    hdr: Header;
    pad: StubLib.Int32;
  END;
</PRE> A <CODE>MsgHeader</CODE> prefixes every message other than a remote method call.
   It is padded to 64-bit alignment so that data streams will be aligned
   correctly in memory on 64-bit machines.


<P><PRE>END Protocol.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
