<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/Protocol.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/Protocol.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Protocol.m3 </EM></BLOCKQUOTE><PRE>

MODULE <module><implements><A HREF="Protocol.i3">Protocol</A></implements></module>;

IMPORT <A HREF="NetObj.i3">NetObj</A>, <A HREF="StubLib.i3">StubLib</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

PROCEDURE <A NAME="RecvOp"><procedure>RecvOp</procedure></A>(c: StubLib.Conn; state: State; VAR rep: StubLib.DataRep) : Op
     RAISES {NetObj.Error, Rd.Failure, Thread.Alerted} =
  VAR i: CARDINAL;
      op: Op;
  BEGIN
    IF state # State.CallWait THEN
      IF NOT c.rd.nextMsg() THEN
        StubLib.RaiseUnmarshalFailure();
      END;
    END;
    StubLib.InBytes(c, rep.byte);
    i := StubLib.InInt32(c, rep, 0, ORD(LAST(Op)));
    op := VAL(i, Op);
    CASE state OF
    | State.CallWait =&gt;
        IF op # Op.MethodCall THEN StubLib.RaiseUnmarshalFailure(); END;
    | State.ReturnWait =&gt;
        IF op # Op.Return AND op # Op.CallFailed THEN
          StubLib.RaiseUnmarshalFailure();
        END;
    | State.AckWait =&gt;
        IF op # Op.ResultAck THEN StubLib.RaiseUnmarshalFailure(); END;
    | State.StreamWait =&gt;
        IF op # Op.StreamData THEN StubLib.RaiseUnmarshalFailure(); END;
    | State.StreamResWait =&gt;
        IF op # Op.StreamRes THEN StubLib.RaiseUnmarshalFailure(); END;
    END;
    RETURN op;
  END RecvOp;

PROCEDURE <A NAME="SendOp"><procedure>SendOp</procedure></A>(c: StubLib.Conn; op: Op)
     RAISES {Wr.Failure, Thread.Alerted} =
  BEGIN
    StubLib.OutBytes(c, StubLib.NativeRep.byte);
    StubLib.OutInt32(c, ORD(op));
  END SendOp;

BEGIN
END Protocol.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
