<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/SpecialObj.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/SpecialObj.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> SpecialObj.i3 </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>SpecialObj</CODE> interface defines the network object runtime {\it 
   special object}.  This object provides methods for maintenance 
   of the per-space agent export table (see <CODE>NetObj.i3</CODE>) as well as 
   methods to support object marshalling and garbage collection.  
   There is one such concrete object per address space instance.  
   In addition, there are potentially many special object surrogates 
   used to invoke corresponding methods in different address spaces. 
   
<P><PRE>INTERFACE <interface><A HREF="NetObjRT.m3">SpecialObj</A></interface>;

IMPORT <A HREF="NetObj.i3">NetObj</A>, <A HREF="../../fingerprint/src/Fingerprint.i3">Fingerprint</A>, <A HREF="SpaceID.i3">SpaceID</A>, <A HREF="StubLib.i3">StubLib</A>, <A HREF="Transport.i3">Transport</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="WireRep.i3">WireRep</A>;

TYPE
  FpTower = REF ARRAY OF Fingerprint.T;
</PRE> A <CODE>Fingerprint</CODE> is a hashed representation of a Modula-3 type. 
   Every network object type can be represented by such a hash. The 
   hash function must yield uniform results across all network object 
   clients.  An <CODE>FpTower</CODE> is an ordered list of <CODE>Fingerprint</CODE> which 
   represents the type hierarchy for a single network object.  Each list 
   is ordered from subtype to supertype.  The fingerprint of the common
   supertype NetObj.T is omitted, but implied. 

<P>  <PRE>VersionList = ARRAY OF StubLib.StubProtocol;
</PRE> A <CODE>VersionList</CODE> is an array of <CODE>StubLib.StubProtocol</CODE>.  For any given
   surrogate type, there may be multiple stub instances corresponding to
   compilations under different stub compilers.  Similarly, an object
   owner may support dispatchers for several stub protocol version.
<P>
   Items of the type <CODE>FpTower</CODE> are always accompanied by a <CODE>VersionList</CODE>.
   The general scheme for attributing stub versions to the elements of a
   <CODE>FpTower</CODE> is as follows:
<P>
       let <CODE>fp</CODE> be a <CODE>FpTower</CODE>;
       let <CODE>ver</CODE> be a set of pairs
               <CODE>(StubLib.StubProtocol,INTEGER)</CODE>;
<P>
       for any element <CODE>ver(v,n)</CODE>:
           version <CODE>v</CODE> stubs exist for <CODE>fp[i]</CODE> where <CODE>n &lt;= i</CODE>
<P>
   We adopt a more restrictive scheme where <CODE>ver</CODE> is simply an
   array of <CODE>StubLib.StubProtocol</CODE>.  This corresponds exactly to
   the general form where <CODE>n</CODE> is always zero.
<P>
   The effect of this is that the stub versions appearing in <CODE>ver</CODE>
   apply to all the elements of <CODE>fp</CODE>.  However, stub versions that don't
   exist for <CODE>fp[0]</CODE> will not appear in the representation.
<P>
   For example, if a server has stubs for <CODE>(A, v1)</CODE> and <CODE>(AB, v2)</CODE>, then
   then <CODE>v1</CODE> stubs will not be accessible for <CODE>AB</CODE> objects.
<P>
   For a version list <CODE>ver</CODE>, if <CODE>ver[i] = StubLib.NullStubProtocol</CODE>, then
   <CODE>ver[j] = StubLib.NullStubProtocol</CODE> where j &gt;= i.


<P>  <PRE>EventID = ARRAY [0..1] OF StubLib.Int32; (* lsw..msw *)
</PRE> An <CODE>EventID</CODE> is a monotonically increasing value which identifies 
   events communicated between a client's garbage collector and the 
   object owners for which that client hold surrogates.  This value 
   serves to serialize calls which otherwise might arrive and be 
   processed asynchronously. 

<P>  <PRE>CleanElem = RECORD wrep: WireRep.T; id: EventID; END;
  CleanBatch = ARRAY OF CleanElem;
</PRE> A <CODE>CleanBatch</CODE> is a list of wire representations which refer to
   network objects to be marked clean.  It is used only in the
   <CODE>ST.clean: call below.  Each </CODE>wrep<CODE> is tagged with an </CODE>EventID<CODE>
   to logically serialize calls to </CODE>dirty<CODE> and </CODE>clean<CODE> according to
   the order in which they were generated. 
   
<P><PRE>CONST DefaultBatchLen = 50;

TYPE
  ST = NetObj.T OBJECT METHODS
    get(name: TEXT) : NetObj.T
      RAISES {NetObj.Error, Thread.Alerted};
    put(name: TEXT; obj: NetObj.T)
      RAISES {NetObj.Error, Thread.Alerted};
    getAdr(sp: SpaceID.T): NetObj.Address
      RAISES {NetObj.Error, Thread.Alerted};
    dirty(
      wrep: WireRep.T; eventID: EventID;
      VAR (*OUT*) vers: VersionList;
      loc: Transport.Location := NIL): FpTower
      RAISES {NetObj.Error, Thread.Alerted};
    clean(
      READONLY batch: CleanBatch; strong: BOOLEAN := FALSE;
      loc: Transport.Location := NIL)
      RAISES {NetObj.Error, Thread.Alerted};
  END;
</PRE> The special object <CODE>ST</CODE> for each address space instance implements
   an agent table describing a set of exported objects.  The <CODE>get</CODE>
   method performs a table lookup and returns the object registered
   under <CODE>name</CODE>, or <CODE>NIL</CODE> is there isn't one.  The <CODE>put</CODE> method
   registers <CODE>obj</CODE> in the table under <CODE>name</CODE>, overwriting any existing
   entry.
<P>
   Each address space contains a table holding a <CODE>NetObj.Address</CODE> 
   for itself and for every other address space for which it has any
   surrogates.  <CODE>getAdr</CODE> performs a lookup in this table and returns
   the result.  This is used by the object unmarshalling code to
   construct a <CODE>Transport.Location</CODE> to the object owner if no such
   location exists.
   <P>
   The <CODE>dirty</CODE> method is used to inform the object owner of the 
   existence of a surrogate with wire representation <CODE>wrep</CODE> at the 
   address space whose local garbage collector is identified by 
   <CODE>loc</CODE>.  The caller must tag each call with a unique and 
   monotonically increasing <CODE>eventID</CODE>.  Dirty calls must possess a 
   more recent <CODE>eventID</CODE> than the most recent one attributed to <CODE>wrep</CODE> 
   and <CODE>loc</CODE> by the object owner.  Otherwise the call is considered 
   out-of-date and is ignored.  The <CODE>loc</CODE> argument is always defaulted 
   during surrogate invocations and is supplied by the server stub 
   during concrete method invocation.  <CODE>loc</CODE> is required so that the 
   liveness of the surrogate's address space can be monitored.
<P>
   The <CODE>dirty</CODE> call uses the out parameter <CODE>vers</CODE> to return a subset of
   the stub protocol versions supported by the object owner for the
   object class of <CODE>wrep</CODE>.  If the result array is too small, the owner
   will choose which elements to omit.  If the result array is too large,
   empty slots will be filled with the value <CODE>StubLib.NullStubProtocol</CODE>.
   <P>
   The <CODE>clean</CODE> method notifies an object owner that a surrogate for
   <CODE>wrep</CODE> no longer exists at <CODE>loc</CODE>.  The <CODE>batch</CODE> argument is an
   array of [<CODE>wrep</CODE>, <CODE>eventID</CODE>] tuples.  As with <CODE>dirty</CODE>, each
   <CODE>wrep</CODE>, is tagged with an <CODE>eventID</CODE>, and this <CODE>eventID</CODE> must be
   the most recent id received by the owner for <CODE>wrep</CODE> and <CODE>loc</CODE>. 
   The <CODE>loc</CODE> argument is always defaulted during surrogate invocations
   and is supplied by the server stub during concrete method invocation.
   If <CODE>clean</CODE> fails due to communication problems, it must be retried
   with <CODE>strong = TRUE</CODE> until it is determined that such attempts will
   never succeed, for instance because it is determined that the communication
   problem is permanent.
 

<P><PRE>TYPE <A HREF="AgentStubs.m3#Surrogate">Surrogate</A> &lt;: ST;
</PRE> <CODE>Surrogate</CODE> is the type of surrogate special objects. 

<P><PRE>PROCEDURE <A HREF="NetObjRT.m3#New">New</A>(loc: Transport.Location) : ST;
</PRE> <CODE>New</CODE> returns a surrogate for the concrete special object at the
   target address space of <CODE>loc</CODE>. 

<P><PRE>END SpecialObj.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
