<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/StubConn.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/StubConn.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> StubConn.i3 </EM></BLOCKQUOTE><PRE>
</PRE> A <CODE>StubLib.Conn</CODE> represents a bi-directional connection used to invoke
   remote methods by the network objects runtime.  Here we reveal that
   a connection <CODE>c</CODE> consists of a message reader <CODE>c.rd</CODE> and a message
   writer <CODE>c.wr</CODE>.\ttindex{StubLib.Conn}
<P>
   Connections come in matching pairs; the two elements of the pair 
   are typically in different address spaces.  If <CODE>c1</CODE> and <CODE>c2</CODE>
   are paired, the target of <CODE>c1.wr</CODE> is equal to the source of <CODE>c2.rd</CODE>, 
   and vice versa.  Thus the messages written to <CODE>c1.wr</CODE> can be read 
   from <CODE>c2.rd</CODE>, and vice versa. 
  
<P><PRE>INTERFACE <interface>StubConn</interface>;

IMPORT <A HREF="../../rw/src/Common/MsgRd.i3">MsgRd</A>, <A HREF="../../rw/src/Common/MsgWr.i3">MsgWr</A>, <A HREF="StubLib.i3">StubLib</A>;

REVEAL StubLib.Conn &lt;: Public;

TYPE
  T = StubLib.Conn;      (* compatibility with old stub generator, remove *)
  Public = OBJECT rd: MsgRd.T; wr: MsgWr.T END;

END StubConn.
</PRE> Clients can use this interface to bypass the procedures in the
   <CODE>StubLib</CODE> interface and marshal and unmarshal arguments using
   inline code, for example to write directly to the underlying
   writer.  To do this, import the <CODE>RdClass</CODE> and <CODE>WrClass</CODE>
   interfaces\cite{Modula3} to reveal the internal structure of
   readers and writers.  You will have to be careful about locks.  All
   readers and writers contain an internal lock used to serialize
   operations.  It is a requirement of the <CODE>StubLib</CODE> interface that
   all parameters of type <CODE>Conn</CODE> be passed with both streams unlocked.
   It is a further requirement that no client thread operate on the
   streams while an activation of a <CODE>StubLib</CODE> procedure is in
   progress.
<P>
   There are two final clauses in the specification of the message
   readers and message writers that appear in a <CODE>StubConn.T</CODE>.  First,
   their buffers must be word-aligned in memory. More precisely, if
   byte <CODE>i</CODE> in the data stream is stored in the buffer at memory
   address <CODE>j</CODE>, then <CODE>i</CODE> and <CODE>j</CODE> must be equal modulo the
   machine word size. This requirement allows optimized stubs to read
   and write scalar values from the buffer efficiently.  Second, their
   buffers must not be too small.  More precisely, when the
   <CODE>nextMsg</CODE> method of a writer returns, there must be at least 24
   bytes of free space in the writer buffer, and when the
   <CODE>nextMsg</CODE> method of a reader returns, there must be at least 24
   bytes of message data in the reader buffer. This requirement allows
   the runtime to efficiently read and write the headers required by
   the network object protocol.\index{buffered streams}  

<P>
<P>
<P>
<P>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
