<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/StubLib.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/StubLib.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> StubLib.i3 </EM></BLOCKQUOTE><PRE>
</PRE> This interface contains procedures to be used by stub code for
   invoking remote object methods and servicing remote invocations.
<P>
   Each stub module provides type-dependent network 
   support for marshaling and unmarshaling method calls for a 
   specific subtype of <CODE>NetObj.T</CODE>.  Usually, stubs are 
   built automatically.\ttindex{NetObj.T}
<P>
   For each <CODE>NetObj.T</CODE> subtype <CODE>T</CODE> intended to support remote method 
   invocation there must be both a client and a server stub. 
   \index{stubs}
<P>
   The client stub defines a subtype of <CODE>T</CODE> in which every method is 
   overridden by a procedure implementing remote method invocation. 
   Such a {\it surrogate} object is constructed by the network 
   object runtime whenever a reference to a non-local object 
   is encountered.\index{stubs!client} 
<P>
   The server stub consists of a single procedure of type <CODE>Dispatcher</CODE>
   that is called to unmarshal and dispatch remote invocations.
   \index{stubs!server}
<P>
   A surrogate type and null dispatcher for <CODE>NetObj.T</CODE> are defined and
   registered by the network object system itself. 

<P><PRE>INTERFACE <interface><A HREF="#x1">StubLib</A></interface>;

IMPORT <A HREF="../../atom/src/Atom.i3">Atom</A>, <A HREF="../../libm3/derived/AtomList.i3">AtomList</A>, <A HREF="NetObj.i3">NetObj</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

TYPE
  <A HREF="#x2">Conn</A> &lt;: ROOT;
</PRE> A remote object invocation can be viewed as an exchange of messages 
   between client and server.  The messages are exchanged via
   an object of type <CODE>Conn</CODE>, which is opaque in this interface.
   The <CODE>StubConn</CODE> interface reveals more of this type's structure
   to clients who wish to hand-code stubs for efficiency.
<P>
   A <CODE>Conn</CODE> is unmonitored: clients must not access it from two threads
   concurrently. \ttindex{StubLib.Conn} 

<P><PRE>TYPE
  Byte8 = BITS 8 FOR [0..255];
  DataRep = RECORD
    private, intFmt, floatFmt, charSet: Byte8;
  END;

VAR (*CONST*) NativeRep: DataRep;
</PRE> The type <CODE>DataRep</CODE> describes the format used to encode characters, 
   integers, and floating point numbers in network data.  Data is 
   always marshaled in the sender's native format.  <CODE>NativeRep</CODE> is 
   a runtime constant that describes the native format of the current 
   environment.\ttindex{StubLib.DataRep}\ttindex{StubLib.NativeRep}
   <P>
   Stubs may optimize in-line unmarshaling by first checking that the 
   incoming representation is the same as the native one for all data types
   relevant to the call.  If it is not, then the generic data unmarshaling
   routines at the end of this interface should be used.
<P>
   Automatic conversion between the data representations is performed wherever
   possible.  If automatic conversion is impossible, the the exception
   <CODE>NetObj.Error(NetObj.UnsupportedDataRep)</CODE> is raised.
<P>
   Concrete values for the elements of <CODE>DataRep</CODE> are not defined here
   as it is sufficient to compare against <CODE>NativeRep</CODE> and invoke the
   marshaling procedures defined below if the encoding is non-native. 

<P><PRE>TYPE
  Int32 =  BITS 32 FOR [-16_7FFFFFFF-1..16_7FFFFFFF];
  StubProtocol = Int32;

CONST
  NullStubProtocol = -1;
  SystemStubProtocol = 0;
</PRE> The type <CODE>StubProtocol</CODE> indicates the version of the stub compiler
   used to generate a particular stub.  Multiple stubs for the same
   network object can coexist within the same program (for example, 
   the outputs of different stub compilers).  During surrogate creation,
   the network object runtime negotiates the stub protocol version
   with the object owner.\ttindex{StubLib.StubProtocol}
<P>
   <CODE>NullStubProtocol</CODE> is a placeholder to indicate the absence of
   a stub protocol value.  <CODE>SystemStubProtocol</CODE> indicates the fixed
   stub encoding used by the runtime to implement primitives
   that operate prior to any version negotiation.
   \ttindex{StubLib.NullStubProtocol}\ttindex{StubLib.SystemStubProtocol} 

<P><PRE>VAR (*CONST*) UnmarshalFailure: Atom.T;
</PRE> <CODE>UnmarshalFailure</CODE> should be used as an argument to <CODE>NetObj.Error</CODE>
   whenever stubs encounter a network datum that is incompatible with
   the target type.  For example, the stub code might encounter a
   <CODE>CARDINAL</CODE> greater than <CODE>LAST(CARDINAL)</CODE> or an unrecognized remote
   method specification. 

<P><PRE>TYPE Typecode = CARDINAL;
</PRE> <CODE>Typecode</CODE> is the type of those values returned by the Modula-3
    <CODE>TYPECODE</CODE> operator. \index{typecodes}
   
    
<P><PRE>PROCEDURE <A HREF="NetObjRT.m3#Register">Register</A>(
    pureTC: Typecode;
    stubProt: StubProtocol;
    surrTC: Typecode;
    disp: Dispatcher);
</PRE><BLOCKQUOTE><EM> Let <CODE>T</CODE> be the type whose typecode is <CODE>pureTC</CODE>, and
   let <CODE>srgT</CODE> be the type whose typecode is <CODE>surrTC</CODE>.
   Set the client surrogate type and dispatch procedure
   for <CODE>T</CODE> to be <CODE>srgT</CODE> and <CODE>disp</CODE>, respectively.
   The <CODE>stubProt</CODE> parameter indicates the stub compiler
   version that generated the stub being registered.
   \ttindex{StubLib.Register}  </EM></BLOCKQUOTE><PRE>
</PRE> The following constraint applies to stub registration.
   If stubs are registered for types <CODE>A</CODE> and <CODE>B</CODE>, where <CODE>B</CODE> is 
   a supertype of <CODE>A</CODE>, then the protocol versions registered for 
   <CODE>B</CODE> must be a superset of the versions registered for <CODE>A</CODE>. 
   If this rule is violated, attempts to invoke remote methods
   may raise <CODE>NetObj.Error</CODE>.
   <P>
   Note that a concrete object of type <CODE>A</CODE> will receive method 
   invocations only for stub versions for which <CODE>A</CODE> is registered.  
   This is true even if a supertype of <CODE>A</CODE> is registered with 
   additional stub versions.
<P>
   <CODE>Register</CODE> must be called before any object of type <CODE>T</CODE> is 
   marshaled or unmarshaled.  

<P>
\paragraph{Client stub procedures.}
\index{stubs!client}
<P>
Here is a simplified sketch of the procedure calls performed by a 
client to make a remote call to a method of <CODE>obj</CODE>:
<P>
<PRE>
       VAR 
         c := StartCall(obj, stubProt); 
         resDataRep: DataRep;
       BEGIN
         &lt;marshal to &quot;c&quot; the number of this method&gt;
         &lt;marshal to &quot;c&quot; the method arguments&gt;
         resDataRep := AwaitResult(conn);
         &lt;unmarshal from &quot;c&quot; the method results&gt;
         &lt;results will be in wire format &quot;resDataRep&quot;&gt;
         EndCall(c, TRUE)
       END;
</PRE>
For both arguments and results, the sender always marshals values 
in its native format; the receiver performs any conversions that may 
be needed.  The procedure result typically begins with an integer 
specifying either a normal return or an exceptional return.  If a 
protocol error occurs, the client should call <CODE>EndCall(c, FALSE)</CODE> 
instead of <CODE>EndCall(c, TRUE)</CODE>. This requires <CODE>TRY FINALLY</CODE> instead 
of the simple straight-line code above; a more complete example is 
presented in the next section. 
<P>
Here are the specifications of the client protocol procedures: 

<P><PRE>PROCEDURE <A HREF="#x3">StartCall</A>(obj: NetObj.T;
                    stubProt: StubProtocol) : Conn
    RAISES {NetObj.Error, Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Return a connection to the owner of <CODE>obj</CODE>,  
   write to the connection a protocol request to 
   perform a remote method call to <CODE>obj</CODE>, using the 
   data representation <CODE>NativeRep</CODE>.  The value <CODE>stubProt</CODE> is the
   stub protocol version under which the arguments and results
   will be encoded.\ttindex{StubLib.StartCall} </EM></BLOCKQUOTE><PRE>
</PRE> Upon return from <CODE>StartCall</CODE>,  the client stub should marshal 
   a specification of the method being invoked followed by any arguments. 
   
<P><PRE>PROCEDURE <A HREF="#x4">AwaitResult</A>(c: Conn): DataRep
    RAISES {NetObj.Error, Rd.Failure, Wr.Failure,
            Thread.Alerted};
</PRE><BLOCKQUOTE><EM> <CODE>AwaitResult</CODE> indicates the end of the arguments for the current 
    method invocation, and blocks waiting for a reply message
    containing the result of the invocation.  It returns
    the data representation used to encode the result
    message.\ttindex{StubLib.AwaitResult} </EM></BLOCKQUOTE><PRE>
</PRE>  Upon return from <CODE>AwaitResult</CODE> the client stub should unmarshal
    any results. 
    
<P><PRE>PROCEDURE <A HREF="#x5">EndCall</A>(c: Conn; reUse: BOOLEAN)
    RAISES {NetObj.Error, Rd.Failure, Wr.Failure,
            Thread.Alerted};
</PRE><BLOCKQUOTE><EM> <CODE>EndCall</CODE> must be called at the end of processing a remote 
   invocation, whether or not the invocation raised an exception. 
   The argument <CODE>reUse</CODE> must be <CODE>FALSE</CODE> if the client has been 
   unable, for any reason, to unmarshal either a 
   normal or exceptional result. It is always safe to 
   call <CODE>EndCall</CODE> with <CODE>reUse</CODE> set to <CODE>FALSE</CODE>, but performance 
   will be improved if <CODE>reUse</CODE> is <CODE>TRUE</CODE> whenever possible.
   \ttindex{StubLib.EndCall} </EM></BLOCKQUOTE><PRE>
</PRE> <CODE>EndCall</CODE> determines, by examining <CODE>c</CODE>, whether the result message 
   requires acknowledgment, that is, whether the result contained 
   any network objects.  If an acknowledgment is required, it is sent.  
   <CODE>EndCall</CODE> then releases <CODE>c</CODE>.  After <CODE>EndCall</CODE> returns, <CODE>c</CODE> should not 
   be used.
<P>
\paragraph{Server dispatcher procedures.}  
\index{stubs!server}\index{dispatching}
Next we consider the server-side stub, which consists of
a registered dispatcher procedure.


<P><PRE>TYPE
  Dispatcher =
    PROCEDURE(c: Conn; obj: NetObj.T;
              rep: DataRep; stubProt: StubProtocol)
    RAISES {NetObj.Error, Rd.Failure, Wr.Failure,
            Thread.Alerted};
</PRE> A procedure of type <CODE>Dispatcher</CODE> is registered for each network
   object type <CODE>T</CODE> for which stubs exist.  The dispatcher 
   is called by the network object runtime when it receives a remote
   object invocation for an object of type <CODE>T</CODE>.  The <CODE>rep</CODE> argument
   indicates the data representation used to encode the arguments of the
   invocation.  The <CODE>stubProt</CODE> argument indicates the version of
   stub protocol used to encode the call arguments.  The same protocol
   should be used to encode any results.\ttindex{StubLib.Dispatcher}
   <P>
   The dispatcher procedure is responsible for unmarshaling the method
   number and any arguments, invoking the concrete object's
   method, and marshaling any results.
   <P>
   Here is a simplified sketch of a typical dispatcher:
<P>
<PRE>
      PROCEDURE Dispatch(c, obj, rep) =
         &lt;unmarshal from &quot;c&quot; the method number&gt;
         &lt;unmarshal from &quot;c&quot; the method arguments&gt;
         &lt;arguments will be in the wire format &quot;rep&quot;)&gt;
         &lt;call the appropriate method of &quot;obj&quot;&gt;
         StartResult(c);
         &lt;marshal to &quot;c&quot; the method result or exception&gt;
       END Dispatch;
</PRE>
Here is the specification of <CODE>StartResult</CODE>: 

<P><PRE>PROCEDURE <A HREF="#x6">StartResult</A>(c: Conn)
    RAISES {Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> <CODE>StartResult</CODE> must be called by the server stub to initiate return 
   from a remote invocation before marshaling any results.
   \ttindex{StubLib.StartResult} </EM></BLOCKQUOTE><PRE>
</PRE> Upon return from <CODE>StartResult</CODE> the stub 
   code should marshal any results or error indications on <CODE>c</CODE>. 
 <P>
\paragraph{Marshaling of reference types.}  
\index{marshaling!of reference types}
  The following procedures are made available for marshaling of 
  subtypes of <CODE>REFANY</CODE>. 

<P><PRE>PROCEDURE <A HREF="StubLib.m3#OutRef">OutRef</A>(c: Conn; r: REFANY)
    RAISES {Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Marshal the data structure reachable from <CODE>r</CODE>.  Certain datatypes
   are handled specially: subtypes of <CODE>NetObj.T</CODE> are
   marshaled as network references.  Subtypes of <CODE>Rd.T</CODE> and <CODE>Wr.T</CODE>
   are marshaled as surrogate streams.  The types <CODE>TEXT</CODE> and <CODE>REF ARRAY
   OF TEXT</CODE> are marshaled by copying via
   custom code for speed.  All others are marshaled by copying as pickles.
   Subtypes of <CODE>NetObj.T</CODE>, <CODE>Rd.T</CODE>, and <CODE>Wr.T</CODE> which are embedded within
   other datatypes are also marshaled by reference.
   \ttindex{StubLib.OutRef} </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#InRef">InRef</A>(c: Conn; rep: DataRep; tc:=-1): REFANY
    RAISES {NetObj.Error, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Unmarshal a marshaled subtype of <CODE>REFANY</CODE> as pickled by <CODE>OutRef</CODE>.
   If <CODE>tc</CODE> is non-negative, it is the typecode for the intended 
   type of the reference.  The exception <CODE>NetObj.Error(UnmarshalFailure)</CODE> 
   is raised if the unpickled result is not a subtype of this type.  If
   <CODE>tc</CODE> is negative, no type checking is performed.
   \ttindex{StubLib.InRef} </EM></BLOCKQUOTE><PRE>
</PRE> For any subtypes of <CODE>NetObj.T</CODE> in the pickled datatype, a surrogate
   network object is substituted for the concrete object.  The runtime
   guarantees that within a single address space, only one surrogate
   for any single concrete object will exist at any given time.
<P>
   For any unmarshaled subtypes of <CODE>Rd.T</CODE>, the concrete reader
   is replaced by a surrogate reader whose source is the remaining
   source of the concrete reader.  Similarly for subtypes of <CODE>Wr.T</CODE>,
   the concrete writer is replaced by a surrogate writer whose target
   is the target of the concrete writer.  The operations on
   surrogate streams are described in <CODE>NetStream.i3</CODE>.
   <P>
\paragraph{Marshaling of generic data.}  
\index{marshaling!of generic data}
  The following procedures are made available to permit the generic
  marshaling of various primitive data types. 

<P><PRE>PROCEDURE <A HREF="StubLib.m3#OutChars">OutChars</A>(
    c: Conn; READONLY chars: ARRAY OF CHAR)
    RAISES {Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Marshal a char array in native format. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#OutBytes">OutBytes</A>(
    c: Conn; READONLY bytes: ARRAY OF Byte8)
    RAISES {Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Marshal a byte array. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#OutInteger">OutInteger</A>(c: Conn; i: INTEGER)
    RAISES {Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Marshal an integer in native format. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#OutInt32">OutInt32</A>(c: Conn; i: Int32)
    RAISES {Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Marshal a 32-bit integer in native format. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#OutByte">OutByte</A>(c: Conn; i: Byte8)
    RAISES {Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Marshal a byte. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#OutBoolean">OutBoolean</A>(c: Conn; bool: BOOLEAN)
    RAISES {Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Marshal a boolean value. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#OutReal">OutReal</A>(c: Conn; r: REAL)
    RAISES {Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Marshal a real in native format. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#OutLongreal">OutLongreal</A>(c: Conn; card: LONGREAL)
    RAISES {Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Marshal a longreal in native format. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#OutExtended">OutExtended</A>(c: Conn; card: EXTENDED)
    RAISES {Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Marshal an extended in native format. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#OutCardinal">OutCardinal</A>(c: Conn; card: CARDINAL)
    RAISES {Wr.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Marshal a cardinal in native format. </EM></BLOCKQUOTE><PRE>
</PRE> The following procedures are provided in support of generic 
   unmarshaling of data.  In all cases, <CODE>rep</CODE> indicates the encoding
   of the incoming data.  These procedures could be replaced 
   by inline unmarshaling code whenever the relevant elements of
   <CODE>rep</CODE> match the corresponding elements of <CODE>NativeRep</CODE>. 

<P><PRE>PROCEDURE <A HREF="StubLib.m3#InChars">InChars</A>(
    c: Conn; rep: DataRep;
    VAR chars: ARRAY OF CHAR)
    RAISES {NetObj.Error, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Unmarshal a char array of length <CODE>NUMBER(chars)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#InBytes">InBytes</A>(
    c: Conn; VAR bytes: ARRAY OF Byte8)
    RAISES {NetObj.Error, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Unmarshal a byte array of length <CODE>NUMBER(bytes)</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#InInteger">InInteger</A>(
    c: Conn;
    rep: DataRep;
    min := FIRST(INTEGER);
    max := LAST(INTEGER)): INTEGER
    RAISES {NetObj.Error, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Unmarshal an integer, checking that its value is in  <CODE>[min..max]</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#InInt32">InInt32</A>(
    c: Conn;
    rep: DataRep;
    min := FIRST(Int32);
    max := LAST(Int32)): Int32
    RAISES {NetObj.Error, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Unmarshal a 32-bit integer, checking that its value is in  <CODE>[min..max]</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#InByte">InByte</A>(
    c: Conn;
    max := LAST(Byte8)): Byte8
    RAISES {NetObj.Error, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Unmarshal a byte, checking that its value is in <CODE>[0..max]</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#InBoolean">InBoolean</A>(c: Conn): BOOLEAN
    RAISES {NetObj.Error, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Unmarshal a boolean value. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#InReal">InReal</A>(c: Conn; rep: DataRep): REAL
    RAISES {NetObj.Error, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Unmarshal a real value. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#InLongreal">InLongreal</A>(c: Conn; rep: DataRep): LONGREAL
    RAISES {NetObj.Error, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Unmarshal a longreal value. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#InExtended">InExtended</A>(c: Conn; rep: DataRep): EXTENDED
    RAISES {NetObj.Error, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Unmarshal an extended value. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#InCardinal">InCardinal</A>(
    c: Conn; rep: DataRep;
    lim: CARDINAL := LAST(CARDINAL)): CARDINAL
    RAISES {NetObj.Error, Rd.Failure, Thread.Alerted};
</PRE><BLOCKQUOTE><EM> Unmarshal a cardinal, checking that its value is in <CODE>[0..lim]</CODE>. </EM></BLOCKQUOTE><PRE>
</PRE> \smallskip
<P>
   Here are two procedures for raising <CODE>NetObj</CODE> exceptions conveniently:
<P>
   \smallskip


<P><PRE>PROCEDURE <A HREF="StubLib.m3#RaiseUnmarshalFailure">RaiseUnmarshalFailure</A>()
    RAISES {NetObj.Error};
</PRE><BLOCKQUOTE><EM> Raise <CODE>NetObj.Error(AtomList.List1(UnmarshalFailure))</CODE>. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="StubLib.m3#RaiseCommFailure">RaiseCommFailure</A>(ec: AtomList.T)
    RAISES {NetObj.Error};
</PRE><BLOCKQUOTE><EM> Raise <CODE>NetObj.Error(AtomList.Cons(NetObj.CommFailure, ec))</CODE>. </EM></BLOCKQUOTE><PRE>

END StubLib.
</PRE>
</inInterface>
<HR>
<A NAME="x1">StubLib's implementation  is in:
</A><UL>
<LI><A HREF="NetObjRT.m3#0TOP0">netobjrt/src/NetObjRT.m3</A>
<LI><A HREF="StubLib.m3#0TOP0">netobjrt/src/StubLib.m3</A>
<LI><A HREF="StubProt.m3#0TOP0">netobjrt/src/StubProt.m3</A>
</UL>
<P>
<HR>
<A NAME="x2">opaque type StubLib.Conn is in:
</A><UL>
<LI><A HREF="StubLib.m3#Conn">netobjrt/src/StubLib.m3</A>
<LI><A HREF="StubProt.m3#Conn">netobjrt/src/StubProt.m3</A>
</UL>
<P>
<HR>
<A NAME="x3">procedure StubLib.StartCall is in:
</A><UL>
<LI><A HREF="StubLib.m3#StartCall">netobjrt/src/StubLib.m3</A>
<LI><A HREF="StubProt.m3#StartCall">netobjrt/src/StubProt.m3</A>
</UL>
<P>
<HR>
<A NAME="x4">procedure StubLib.AwaitResult is in:
</A><UL>
<LI><A HREF="StubLib.m3#AwaitResult">netobjrt/src/StubLib.m3</A>
<LI><A HREF="StubProt.m3#AwaitResult">netobjrt/src/StubProt.m3</A>
</UL>
<P>
<HR>
<A NAME="x5">procedure StubLib.EndCall is in:
</A><UL>
<LI><A HREF="StubLib.m3#EndCall">netobjrt/src/StubLib.m3</A>
<LI><A HREF="StubProt.m3#EndCall">netobjrt/src/StubProt.m3</A>
</UL>
<P>
<HR>
<A NAME="x6">procedure StubLib.StartResult is in:
</A><UL>
<LI><A HREF="StubLib.m3#StartResult">netobjrt/src/StubLib.m3</A>
<LI><A HREF="StubProt.m3#StartResult">netobjrt/src/StubProt.m3</A>
</UL>
<P>
<PRE>























</PRE>
</BODY>
</HTML>
