<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/Transport.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/Transport.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Transport.i3 </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>Transport</CODE> interface separates the main part of the network
   object runtime system from the parts that deal with low-level
   communication.  It is the interface that must be implemented
   to extend the system to use new communication protocols.  The
   interface is reasonably narrow: 

<P><PRE>INTERFACE <interface>Transport</interface>;

IMPORT <A HREF="NetObj.i3">NetObj</A>, <A HREF="NetObjNotifier.i3">NetObjNotifier</A>, <A HREF="StubLib.i3">StubLib</A>, <A HREF="StubConn.i3">StubConn</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

TYPE
  T &lt;: Public;
  Public = OBJECT METHODS
    fromEndpoint(e: Endpoint): Location;
    toEndpoint(): Endpoint;
    serviceCall(t: StubLib.Conn): (*reUse*) BOOLEAN
      RAISES {Thread.Alerted};
  END;

  <A HREF="NetObjRT.m3#Location">Location</A> &lt;: LocationP;
  LocationP = OBJECT METHODS
    new(): StubLib.Conn
      RAISES {NetObj.Error, Thread.Alerted};
    free(c: StubLib.Conn; reUse: BOOLEAN);
    dead(st: NetObjNotifier.OwnerState);
  END;

TYPE Endpoint = TEXT;

REVEAL
  NetObj.<A NAME="Address">Address</A> = BRANDED REF ARRAY OF Endpoint;
  StubLib.Conn &lt;: Conn;

TYPE
  Conn = StubConn.Public BRANDED OBJECT
    loc: Location
  END;

END Transport.
</PRE> The main ideas in the interface were described in
   Section 1.5, page 15. To summarize these briefly:
   <P>
\begin{itemize}
   \item A <CODE>Transport.T</CODE> is an object that manages connections of some 
   particular class ({\it e.g.}, TCP).
<P>
   \item A <CODE>Transport.Location</CODE> is an object that creates connections of some
   particular class to some particular address space.
      <P>
   \item A <CODE>Transport.Endpoint</CODE> is a transport-specific name for an
   address space ({\it e.g.}, an IP address plus a port number plus
   a non-reusable process ID).
<P>
   \item The <CODE>fromEndpoint</CODE> method of a transport converts an endpoint into a 
   location, or into <CODE>NIL</CODE> if the endpoint and transport are of different
   classes.
\end{itemize}
<P>
\noindent
See Section 1.5 for an overall discussion of these concepts.  Here
are specifications for the methods of a <CODE>Transport.T</CODE>:
<P>
\begin{itemize}
   \item The <CODE>toEndpoint</CODE> method returns an endpoint for 
   the address space itself.  The resulting endpoint should be
   recognized by the <CODE>fromEndpoint</CODE> method of transports of the same
   class anywhere in the network.  That is, if a program instance <CODE>P</CODE> calls 
   <CODE>tr1.toEndpoint()</CODE>, producing an endpoint <CODE>ep</CODE>, then the call
   <CODE>tr.fromEndpoint(ep)</CODE> executed in any program instance either returns
   <CODE>NIL</CODE> (if <CODE>tr</CODE> and <CODE>tr1</CODE> are of different classes) or returns a location
   that generates connections to <CODE>P</CODE>.
   <P>
   \item Transports are required to provide the threads
   that listen to the server
   sides of connections.  When a message arrives on the connection indicating
   the beginning of a remote call, the threads are required to call the 
   <CODE>serviceCall</CODE> method of their transport.  The default value of this
   method locates and calls the dispatcher procedure, as explained in
   Section 1.5, page 18.  Ordinarily a transport implementation will not need
   to override this method.  At the entry to <CODE>tr.serviceCall(conn)</CODE>, <CODE>conn.rd</CODE>
   is positioned at the start of the incoming message.  The <CODE>serviceCall</CODE>
   method processes the incoming remote invocation and sends the result
   on <CODE>conn.wr</CODE>.  If it returns <CODE>TRUE</CODE>, then the remote invocation was
   processed without error and the transport can cache the connection.  If
   it returns <CODE>FALSE</CODE>, a protocol error occurred during the call, and the
   transport should destroy the connection.
   \ttmindex{Transport.T}{serviceCall {\rm method}}
   <P>
\end{itemize}
<P>
\noindent
And here are the specifications for the methods of a <CODE>Transport.Location</CODE>:
<P>
\begin{itemize}
   \item The <CODE>new</CODE> method of a location returns a connection to the address 
   space for which it is a location.  The call <CODE>loc.new()</CODE> returns a
   connection whose server side is that address space and whose client
   side is the program instance making the call.  By calling <CODE>loc.new</CODE>,
   the program acquires the obligation to pass the resulting connection to
   <CODE>loc.free</CODE> when it is finished with it.
   \ttmindex{Transport.Location}{new {\rm method}}
<P>
   \item The call <CODE>loc.free(c, reUse)</CODE> frees the connection <CODE>c</CODE>, which must
   have been generated by <CODE>loc.new()</CODE>.  If <CODE>reUse</CODE> is <CODE>TRUE</CODE>, the client
   asserts that the connection is in a suitable state for executing another 
   remote method call.  In particular, <CODE>c.wr</CODE> must be positioned at the
   beginning of a message.  
   \ttmindex{Transport.Location}{free {\rm method}}
<P>
   \item A transport is responsible for monitoring the liveness of program
   instances for which it has locations or connections.  The method of
   monitoring depends on the transport.  For example, the transport might
   periodically ping the other program instance. A program is considered dead
   if it exits, crashes, or if the underlying communication network cannot
   reach it for an appreciable amount of time.  Suppose that <CODE>loc</CODE> is a
   location that generates connections to some program instance <CODE>P</CODE>.
   If <CODE>P</CODE> dies, the transport that provided <CODE>loc</CODE> is responsible 
   for calling the method <CODE>loc.dead(st)</CODE>.  (The network object runtime
   implements this method; the transport should not override it.)  
   The argument <CODE>st</CODE> indicates whether the transport has detected 
   a permanent failure, or one that is potentially transient.  In addition
   to calling <CODE>loc.dead</CODE>, the transport is responsible for alerting all
   threads it has spawned to handle method invocations on behalf of <CODE>P</CODE>.
   \ttmindex{Transport.Location}{dead {\rm method}}
   \index{liveness}
\end{itemize}
<P>
\noindent
   A transport is expected to manage the connections 
   it creates. If creating connections is expensive, then the 
   transport's locations should cache them. If maintaining idle 
   connections is expensive, then the transport's locations should 
   free them.  Often connections are time-consuming to create, 
   but then tie up scarce kernel resources when idle.  Therefore 
   transports typically cache idle connections for a limited amount 
   of time. 
<P>
   The <CODE>Transport</CODE> interface reveals the representation of <CODE>NetObj.Address</CODE>: an
   address is simply an array of endpoints for the program 
   instance designated by the address. The endpoints are generally of 
   different transport classes; they provide alternative ways of communicating
   with the program instance.  The modules of the network object 
   runtime that require this revelation are exactly the modules that 
   import the transport interface, so this is a convenient place to put it.  
   \ttindex{NetObj.Address}
<P>
   The <CODE>Transport</CODE> interface also reveals more information about the type
   <CODE>StubLib.Conn</CODE>. If <CODE>t</CODE> is a <CODE>StubLib.Conn</CODE>, then <CODE>t.loc</CODE> is a <CODE>Location</CODE>
   that generates connections to the program instance at the other end of <CODE>t</CODE>.
   The connections generated by <CODE>t.loc</CODE> connect the same pair of program
   instances that <CODE>t</CODE> connects, but if <CODE>t</CODE> is a handle on the server side
   of the connection, then the connections generated by <CODE>t.loc</CODE> will reverse
   the direction of <CODE>t</CODE>: their client side will be <CODE>t</CODE>'s server side, and
   vice versa (so-called back connections).  On the other hand, if <CODE>t</CODE> is
   a handle on the client side of the connection, then the connections
   generated by <CODE>t.loc</CODE> will be in the same direction as <CODE>t</CODE>.
   \ttindex{StubLib.Conn} A transport must ensure that the <CODE>loc</CODE>
   field is defined in all connections returned by any of its locations.
   \index{back connections} 

<P>
<P>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
