<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/TransportRegistry.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/TransportRegistry.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> TransportRegistry.i3 </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>TransportRegistry</CODE> interface provides the network objects runtime
   with access to the registry of transport  classes known within the
   current runtime environment. 
   
<P><PRE>INTERFACE <interface><A HREF="../../netobj/src/NetObj.m3">TransportRegistry</A></interface>;

IMPORT <A HREF="NetObj.i3">NetObj</A>, <A HREF="Transport.i3">Transport</A>;

PROCEDURE <A HREF="../../netobj/src/NetObj.m3#LocationFromAdr">LocationFromAdr</A>(
  where: NetObj.Address) : Transport.Location;
</PRE> <CODE>LocationFromAdr</CODE> calls <CODE>tr.fromEndpoint</CODE> for each member 
   of <CODE>where</CODE> for each transport <CODE>tr</CODE> known to the runtime.  If any 
   such call returns a non-<CODE>NIL</CODE> result, it is returned.  Otherwise, 
   <CODE>LocationFromAdr</CODE> returns <CODE>NIL</CODE>. 
  
<P><PRE>PROCEDURE <A HREF="../../netobj/src/NetObj.m3#LocalAdr">LocalAdr</A>() : NetObj.Address;
</PRE> <CODE>LocalAdr</CODE> calls <CODE>tr.toEndpoint</CODE> for each transport <CODE>tr</CODE> known
    to the runtime, and returns the list as a <CODE>NetObj.Address</CODE>s. 
     
<P><PRE>PROCEDURE <A HREF="../../netobj/src/NetObj.m3#Iterate">Iterate</A>() : Iterator;
</PRE> <CODE>Iterate</CODE> returns an <CODE>Iterator</CODE> over the known transports. 

<P><PRE>TYPE
  <A HREF="../../netobj/src/NetObj.m3#Iterator">Iterator</A> &lt;: IteratorPublic;
  IteratorPublic = OBJECT METHODS
    next (VAR (*OUT*) tr: Transport.T): BOOLEAN;
  END;
</PRE> If <CODE>it</CODE> is the result of the call <CODE>Iterate()</CODE>, then the call
   <CODE>it.next(tr)</CODE> selects a <CODE>Transport.T</CODE> that has not already
   been returned by <CODE>it</CODE>, sets <CODE>tr</CODE> to that <CODE>Transport.T</CODE>, and
   returns <CODE>TRUE</CODE>.  If no transports remain, the call returns <CODE>FALSE</CODE>
   without setting <CODE>tr</CODE>.  It is a checked runtime error to call
   <CODE>next</CODE> after it has returned <CODE>FALSE</CODE>. 

<P><PRE>END TransportRegistry.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
