<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/TransportUtils.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/TransportUtils.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> TransportUtils.i3 </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>TransportUtils</CODE> interface reveals methods of <CODE>Transport.T</CODE>s
   and <CODE>Transport.Location</CODE>s which are useful for management and
   debugging tools. 

<P><PRE>INTERFACE <interface>TransportUtils</interface>;

IMPORT <A HREF="Transport.i3">Transport</A>;

REVEAL
  Transport.T &lt;: Public;
  Transport.Location &lt;: LocationP;

TYPE
  Public = Transport.Public OBJECT METHODS
    enumerateLocs (p: EnumProc; cl: REFANY := NIL);
  END;

  EnumProc = PROCEDURE (loc: Transport.Location; cl: REFANY): BOOLEAN;

  LocationP = Transport.LocationP OBJECT METHODS
    getInfo (): TEXT;
    getEp (): Transport.Endpoint;
  END;

END TransportUtils.
</PRE> The call <CODE>tr.enumerateLocs (p, cl)</CODE> should invoke <CODE>p (loc, cl)</CODE> for
each live <CODE>loc: Location</CODE> owned by <CODE>tr</CODE>.  The enumeration should
terminate after the first invocation of <CODE>p</CODE> which returns <CODE>TRUE</CODE>.
<P>
The method <CODE>loc.getInfo</CODE> should return a <CODE>TEXT</CODE> suitable for
presentation to a human which identifies the location amongst those
managed by the transport.
<P>
The method <CODE>loc.getEp</CODE> should return a <CODE>Transport.Endpoint</CODE> <CODE>e</CODE>
such that <CODE>loc = tr.fromEndpoint (e)</CODE>.


</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
