<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/Voucher.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/Voucher.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Voucher.i3 </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>Voucher</CODE> interface defines a single type <CODE>Voucher.T</CODE> which 
   is a network object which refers to a concrete reader or writer. 
   This object is marshalled as the network representation of a <CODE>Rd.T</CODE> 
   or <CODE>Wr.T</CODE> during normal argument or result transmission.  The 
   destination can initiate the network transfer of the reader's 
   source or the writer's target by invoking the appropriate {\it claim}
   method. 

<P><PRE>INTERFACE <interface>Voucher</interface>;

IMPORT <A HREF="NetObj.i3">NetObj</A>, <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../thread/src/Common/Thread.i3">Thread</A>;

TYPE
  T = NetObj.T OBJECT METHODS
    claimRd() : Rd.T
      RAISES {NetObj.Error, Thread.Alerted};
    claimWr() : Wr.T
      RAISES {NetObj.Error, Thread.Alerted};
  END;
</PRE> The <CODE>claimRd</CODE> method returns a reader whose source is equal to 
that of the original concrete reader.  The <CODE>claimWr</CODE> method returns 
a writer whose target is that of the remote concrete writer.
<P>
The surrogate stream position equals the initial position of the
original reader or writer at the time it was marshalled.  The surrogate
is not seekable.
<P>
Marshaling of readers is implemented as follows: <CODE>StubLib.OutRef</CODE> marshals
a concrete reader as a network object (a <CODE>Voucher.T</CODE>) containing a
<CODE>claimRd</CODE> method that reads any unread data from <CODE>rd</CODE> and writes
it to the network in such a way that it appears as the source of
the invoker's message reader.  <CODE>StubLib.OutRef</CODE> marshals this like
any other network object. <CODE>StubLib.InRef</CODE> unmarshals the voucher object.
If it is non-<CODE>NIL</CODE>, <CODE>StubLib.InRef</CODE> invokes its <CODE>claimRd</CODE> method.  The
resulting network message reader is returned to the client.  The
implementation for network writers is similar.  

<P><PRE>END Voucher.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
