<HTML>
<HEAD>
<TITLE>SRC Modula-3: netobjrt/src/WireRep.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>netobjrt/src/WireRep.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> WireRep.i3 </EM></BLOCKQUOTE><PRE>
</PRE> The <CODE>WireRep</CODE> defines the network representation of network objects 
   and provides procedures to generate and manipulate values of this 
   type. 
   
<P><PRE>INTERFACE <interface><A HREF="WireRep.m3">WireRep</A></interface>;

IMPORT <A HREF="SpaceID.i3">SpaceID</A>, <A HREF="../../word/src/Word.i3">Word</A>;

CONST Brand = &quot;WireRep&quot;;

TYPE T = RECORD byte: ARRAY [0..15] OF BITS 8 FOR [0..255]; END;

CONST NullT = T {byte := ARRAY [0..15] OF BITS 8 FOR [0..255] {0, ..}};
CONST SpecialT = T {byte := ARRAY [0..15] OF BITS 8 FOR [0..255]
                         {255, 255, 255, 255, 255, 255, 255, 255, 0, ..}};
</PRE> A <CODE>WireRep.T</CODE> is a value which identifies a concrete network object. 
   In general, each <CODE>T</CODE> corresponds to one and only one real object 
   in a network.  Furthermore, each <CODE>T</CODE> is identifiable as having 
   been generated relative to a specific <CODE>SpaceID.T</CODE>.   However, there 
   are two well-known values which are exceptions to this rule.  The 
   value <CODE>NullT</CODE> corresponds to the <CODE>NIL</CODE> network object, and the 
   value <CODE>SpecialT</CODE> corresponds a {\it special object} which is a 
   distinguished concrete object in every address space.  This special 
   object is private to the implementation of the network object 
   runtime. 

<P><PRE>PROCEDURE <A HREF="WireRep.m3#New">New</A>() : T;
</PRE> Generates a new, unique <CODE>WireRep.T</CODE> value.  <CODE>GetSpaceID(New()</CODE> is
   equal to <CODE>SpaceID.Mine()</CODE>. 

<P><PRE>PROCEDURE <A HREF="WireRep.m3#GetSpaceID">GetSpaceID</A>(t: T) : SpaceID.T;
</PRE> Returns the <CODE>SpaceID.T</CODE> associated with the argument <CODE>WireRep.T</CODE>. 

<P>
<P> the following are for generic tables involving WireRep.T's 

<P><PRE>PROCEDURE <A HREF="WireRep.m3#Equal">Equal</A>(t1, t2: T) : BOOLEAN;
PROCEDURE <A HREF="WireRep.m3#Hash">Hash</A>(t: T) : Word.T;

END WireRep.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
