<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliq/derived/ObliqBdl2.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliq/derived/ObliqBdl2.m3</H2></A><HR>
<inModule>
<PRE>MODULE <module><implements><A HREF="ObliqBdl2.i3">ObliqBdl2</A></implements></module>;
</PRE><BLOCKQUOTE><EM> Generated by m3bundle; see its manpage. </EM></BLOCKQUOTE><PRE>

IMPORT <A HREF="../../bundleintf/src/Bundle.i3">Bundle</A>, <A HREF="../../bundleintf/src/BundleRep.i3">BundleRep</A>, <A HREF="../../text/src/Text.i3">Text</A>;
IMPORT <A HREF="../../thread/src/Common/Thread.i3">Thread</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>, <A HREF="../../rw/src/Common/TextWr.i3">TextWr</A>;

TYPE T = Bundle.T OBJECT OVERRIDES get := LookUp END;

VAR bundle: T := NIL;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A>(): Bundle.T =
  BEGIN
    IF (bundle = NIL) THEN bundle := NEW (T) END;
    RETURN bundle;
  END Get;

PROCEDURE <A NAME="LookUp"><procedure>LookUp</procedure></A> (&lt;*UNUSED*&gt; self: T;  element: TEXT): TEXT =
  BEGIN
    FOR i := 0 TO LAST (Names)-1 DO
      IF Text.Equal (Names[i], element) THEN
        IF Elements[i] = NIL THEN Elements[i] := GetElt (i) END;
        RETURN Elements[i];
      END;
    END;
    RETURN NIL;
  END LookUp;

CONST Names = ARRAY [0..24] OF TEXT {
  &quot;ObliqHelpArray&quot;,
  &quot;ObliqHelpFmt&quot;,
  &quot;ObliqHelpNet&quot;,
  &quot;ObliqHelpWr&quot;,
  &quot;ObliqHelpOnline&quot;,
  &quot;ObliqHelpInt&quot;,
  &quot;ObliqHelpBool&quot;,
  &quot;ObliqHelpZeus&quot;,
  &quot;ObliqHelpRd&quot;,
  &quot;ObliqHelpGraph&quot;,
  &quot;ObliqLexicon&quot;,
  &quot;ObliqHelpPickle&quot;,
  &quot;ObliqSyntax&quot;,
  &quot;ObliqHelpRects&quot;,
  &quot;ObliqHelpProcess&quot;,
  &quot;ObliqHelpText&quot;,
  &quot;ObliqHelpMath&quot;,
  &quot;ObliqHelpColor&quot;,
  &quot;ObliqHelpReal&quot;,
  &quot;ObliqHelpLex&quot;,
  &quot;ObliqHelpForm&quot;,
  &quot;ObliqHelpChar&quot;,
  &quot;ObliqHelpSys&quot;,
  &quot;ObliqHelpThread&quot;,
  NIL
};

VAR Elements := ARRAY [0..24] OF TEXT {
  E0,
  E1,
  E2,
  E3,
  E4,
  E5,
  E6,
  E7,
  E8,
  NIL (* E9 .. E9_1 *),
  E10,
  E11,
  NIL (* E12 .. E12_0 *),
  E13,
  E14,
  NIL (* E15 .. E15_0 *),
  E16,
  E17,
  NIL (* E18 .. E18_0 *),
  E19,
  NIL (* E20 .. E20_1 *),
  E21,
  E22,
  E23,
  NIL
};

PROCEDURE <A NAME="GetElt"><procedure>GetElt</procedure></A> (n: INTEGER): TEXT =
  &lt;*FATAL Thread.Alerted, Wr.Failure *&gt;
  VAR wr := TextWr.New ();
  BEGIN
    CASE n OF
    | 9 =&gt;
        Wr.PutText (wr, E9);
        Wr.PutText (wr, E9_0);
        Wr.PutText (wr, E9_1);
    | 12 =&gt;
        Wr.PutText (wr, E12);
        Wr.PutText (wr, E12_0);
    | 15 =&gt;
        Wr.PutText (wr, E15);
        Wr.PutText (wr, E15_0);
    | 18 =&gt;
        Wr.PutText (wr, E18);
        Wr.PutText (wr, E18_0);
    | 20 =&gt;
        Wr.PutText (wr, E20);
        Wr.PutText (wr, E20_0);
        Wr.PutText (wr, E20_1);
    ELSE (*skip*)
    END;
    RETURN TextWr.ToText (wr);
  END GetElt;

CONST E0 =
   &quot;  [e1, ..., en]: [T]\n    (for e1...en: T)\n  All(T) array_new(size: In&quot;
 &amp; &quot;t, init: T): [T]\n    An array of size \'size\', all filled with \'init&quot;
 &amp; &quot;\'.\n  All(T) array_gen(size: Int, proc: (Int)-&gt;T): [T]\n    An array o&quot;
 &amp; &quot;f size \'size\', filled with \'proc(i)\' for \'i\' between \'0\' and \n&quot;
 &amp; &quot;    \'size-1\'.\n  All(T) array_#(a: [T]): Int ! net_failure\n    (also&quot;
 &amp; &quot; \'#(a)\') Size of an array.\n  All(T) array_get(a: [T], i: Int): T ! n&quot;
 &amp; &quot;et_failure\n    (also \'a[i]\') The i-th element (if it exists), zero-b&quot;
 &amp; &quot;ased.\n  All(T) array_set(a: [T], i: Int, b: T): Ok ! net_failure\n    &quot;
 &amp; &quot;(also \'a[i]:=b\') Update the i-th element (if it exists).\n  All(T) ar&quot;
 &amp; &quot;ray_sub(a: [T], i: Int, n: Int): [T] ! net_failure\n    (also \'a[i for&quot;
 &amp; &quot; n]\') A new array, filled with the elements of \'a\' beginning \n    a&quot;
 &amp; &quot;t \'i\', and of size \'n\' (if it exists).\n  All(T) array_upd(a: [T], &quot;
 &amp; &quot;i: Int, n: Int, b: [T]): Ok ! net_failure\011\n    (also \'a[i for n]:=&quot;
 &amp; &quot;b\') Same as \'a[n+i]:=b[n]; ... ; a[i]:=b[0]\'. \n    I.e. \'a[i for n&quot;
 &amp; &quot;]\' gets \'b[0 for n]\'.\n  All(T) array_@(a1: [T], a2: [T]): [T] ! net&quot;
 &amp; &quot;_failure\n    (also infix \'@\') A new array, filled with the concatena&quot;
 &amp; &quot;tion of the elements \n    of \'a1\' and \'a2\'.\n&quot;;

CONST E1 =
   &quot;  fmt_padLft(t: Text, length: Int): Text\n    If t is shorted then leng&quot;
 &amp; &quot;th, pad t with blanks on the left so that it has \n    the given length&quot;
 &amp; &quot;.\n  fmt_padRht(t: Text, length: Int): Text\n    If t is shorted then l&quot;
 &amp; &quot;ength, pad t with blanks on the right so that it has \n    the given le&quot;
 &amp; &quot;ngth.\n  fmt_bool(b: Bool): Text\n    Convert a boolean to its printabl&quot;
 &amp; &quot;e form.\n  fmt_int(n: Int): Text\n    Convert an integer to its printab&quot;
 &amp; &quot;le form.\n  fmt_real(r: Real): Text\n    Convert a real to its printabl&quot;
 &amp; &quot;e form.\n&quot;;

CONST E2 =
   &quot;  net_failure: Exception\n  All(T)  net_who(o: T): Text ! net_failure t&quot;
 &amp; &quot;hread_alerted\n    Return a text indicating where a network object or e&quot;
 &amp; &quot;ngine is registered, or \n    the empty text if the argument is an obje&quot;
 &amp; &quot;ct that has not been registered \n    with a name server.\n  All(T&lt;:{})&quot;
 &amp; &quot; net_export(name: Text, server: Text, o: T): T \n    ! net_failure thre&quot;
 &amp; &quot;ad_alerted\n    Export an object under name \'name\', to the name serve&quot;
 &amp; &quot;r at IP address \n    \'server\'. The empty text denotes the local IP a&quot;
 &amp; &quot;ddress.\n  Some(T&lt;:{}) net_import(name: Text, server: Text): T \n    ! &quot;
 &amp; &quot;net_failure thread_alerted\n    Import the object of name \'name\', fro&quot;
 &amp; &quot;m the name server at IP address \n    \'server\'. The empty text denote&quot;
 &amp; &quot;s the local IP address.\n  All(T) net_exportEngine(name: Text, server: &quot;
 &amp; &quot;Text, arg: T): Ok \n    ! net_failure thread_alerted\n    Export an eng&quot;
 &amp; &quot;ine under name \'name\', to the name server at IP address \n    \'serve&quot;
 &amp; &quot;r\'. The empty text denotes the local IP address. The \'arg\' is given &quot;
 &amp; &quot;\n    as an argument to all procedures received by the engine to execut&quot;
 &amp; &quot;e.\n  Some(T)All(U) net_importEngine(name: Text, server: Text): ((T)-&gt;U&quot;
 &amp; &quot;)-&gt;U \n    ! net_failure thread_alerted\n    Import the object of name &quot;
 &amp; &quot;\'name\', from the name server at IP \n    address \'server\'. The empt&quot;
 &amp; &quot;y text denotes the local IP address.\n&quot;;

CONST E3 =
   &quot;  wr_failure: Exception\n  wr_new(): Wr\n    A writer to a text (a Modu&quot;
 &amp; &quot;la-3 TextWr).\n  wr_toText(w: Wr): Text\n    Emptying a writer to a tex&quot;
 &amp; &quot;t..\n  wr_stdout: Wr\n    The standard output (the Modula-3 Stdio.Stdou&quot;
 &amp; &quot;t).\n  wr_stderr: Wr\n    The standard error (the Modula-3 Stdio.Stderr&quot;
 &amp; &quot;).\n  wr_open(fs: FileSystem, t: Text): Wr ! wr_failure\n    Given a fi&quot;
 &amp; &quot;le system and a file name, returns a writer to the beginning of \n    a&quot;
 &amp; &quot; file (a Modula-3 FileWr, open for write). The local file system is \n &quot;
 &amp; &quot;   available through the predefined lexically scoped identifier \&quot;fileS&quot;
 &amp; &quot;ys\&quot;.\n  wr_openAppend(fs: FileSystem, t: Text): Wr ! wr_failure\n    G&quot;
 &amp; &quot;iven a file system and a file name, returns a writer to the end of file&quot;
 &amp; &quot; \n    (a Modula-3 FileWr, open for append). The local file system is a&quot;
 &amp; &quot;vailable\n    through the predefined lexically scoped identifier \&quot;file&quot;
 &amp; &quot;Sys\&quot;.\n  wr_putChar(w: Wr, c: Char): Ok ! wr_failure thread_alerted\n &quot;
 &amp; &quot;   Put a character to a writer .\n  wr_putText(w: Wr, t: Text): Ok ! wr&quot;
 &amp; &quot;_failure thread_alerted\n    Put a text to a writer .\n  wr_flush(w: Wr&quot;
 &amp; &quot;): Ok ! wr_failure thread_alerted\n    Flush a writer: all buffered wri&quot;
 &amp; &quot;tes to their final destination.\n  wr_index(w: Wr): Int\n    The curren&quot;
 &amp; &quot;t writer position\n  wr_length(w: Wr): Int ! wr_failure thread_alerted\n&quot;
 &amp; &quot;    Length of a writer.\n  wr_seek(w: Wr, n: Int): Ok ! wr_failure thre&quot;
 &amp; &quot;ad_alerted\n    Reposition a writer.\n  wr_close(w: Wr): Ok ! wr_failur&quot;
 &amp; &quot;e thread_alerted\n    Close a writer.\n  wr_buffered(w: Wr): Bool\n    &quot;
 &amp; &quot;Whether the writer is buffered.\n  wr_seekable(w: Wr): Bool\n    Whethe&quot;
 &amp; &quot;r the writer can be repositioned.\n  wr_closed(w: Wr): Bool\n    Whethe&quot;
 &amp; &quot;r the writer is closed.\n&quot;;

CONST E4 =
   &quot;  All(T) sys_print(x: T, depth: Int): Ok\n    Print an arbitrary value &quot;
 &amp; &quot;to stdout, up to some print depth. (Only available \n    on-line.)\n  s&quot;
 &amp; &quot;ys_printText(t: Text): Ok\n    Print a text to stdout. (Only available &quot;
 &amp; &quot;on-line.)\n  sys_printFlush(): Ok\n    Flush stdout. (Only available on&quot;
 &amp; &quot;-line.)\n  sys_pushSilence(): Ok\n    Push the silence stack; when non-&quot;
 &amp; &quot;empty nothing is printed. (Only available \n    on-line.)\n  sys_popSil&quot;
 &amp; &quot;ence(): Ok\n    Pop the silence stack (no-op on empty stack). (Only ava&quot;
 &amp; &quot;ilable on-line.)\n  sys_setPrompt(first: Text, next: Text): Ok\n    Set&quot;
 &amp; &quot; the interactive prompts (defaults: first=\&quot;- \&quot;, next=\&quot;  \&quot;). (Only \n&quot;
 &amp; &quot;    available on-line.)\n  sys_getSearchPath(): Text\n    Get the curre&quot;
 &amp; &quot;nt search path for \'load\' and such. (Only available on-line.)\n  sys_&quot;
 &amp; &quot;setSearchPath(t: Text): Ok\n    Set the current search path for \'load\'&quot;
 &amp; &quot; and such. (Only available on-line.)\n&quot;;

CONST E5 =
   &quot;  n: Int\n    Positive integer constants.\n  ~n: Int\n    Negative inte&quot;
 &amp; &quot;ger constants.\n  int_minus(n: Int): Int\n      Integer negation.\n  in&quot;
 &amp; &quot;t_+(n1: Int, n2: Int): Int\n    Integer addition.\n  int_-(n1: Int, n2:&quot;
 &amp; &quot; Int): Int\n    Integer difference.\n  int_*(n1: Int, n2: Int): Int\n  &quot;
 &amp; &quot;  Integer multiplication.\n  int_/(n1: Int, n2: Int): Int\n    Integer &quot;
 &amp; &quot;division.\n  int_%(n1: Int, n2: Int): Int\n    (also infix \'%\') Integ&quot;
 &amp; &quot;er modulo.\n  int_&lt;(n1: Int, n2: Int): Bool\n    Integer less-than pred&quot;
 &amp; &quot;icate.\n  int_&gt;(n1: Int, n2: Int): Bool\n    Integer greater-than predi&quot;
 &amp; &quot;cate.\n  int_&lt;=(n1: Int, n2: Int): Bool\n    Integer no-greater-than pr&quot;
 &amp; &quot;edicate.\n  int_&gt;=(n1: Int, n2: Int): Bool\n    Integer no-less-than pr&quot;
 &amp; &quot;edicate.\n&quot;;

CONST E6 =
   &quot;  true: Bool\n    The constant true.\n  false: Bool\n    The constant f&quot;
 &amp; &quot;alse.\n  All(T)All(U) bool_is(x: T, y: U): Bool\n    (also infix \'is\'&quot;
 &amp; &quot;) Identity predicate: value equality for \n    Ok, Bool, Int, Real, Cha&quot;
 &amp; &quot;r, Text, Exception; pointer equality otherwise.\n  All(T)All(U) bool_is&quot;
 &amp; &quot;not(x: T, y: U): Bool\n    (also infix \'isnot\') Negation of \'is\'.\n&quot;
 &amp; &quot;  bool_not(b: Bool): Bool\n    (also \'not(b)\')\n  bool_and(b1: Bool, &quot;
 &amp; &quot;b2: Bool): Bool\n    (also infix \'and\')\n  bool_or(b1: Bool, b2: Bool&quot;
 &amp; &quot;): Bool\n    (also infix \'or\')\n&quot;;

CONST E7 =
   &quot;  zeus_failure: Exception\n  zeus_animate(g: Graph, t0: Real, t1: Real)&quot;
 &amp; &quot;: Ok\n&quot;;

CONST E8 =
   &quot;  rd_failure: Exception\n  rd_eofFailure: Exception\n  rd_new(t: Text):&quot;
 &amp; &quot; Rd\n    A reader on a text (a Modula-3 TextRd).\n  rd_stdin: Rd\n    T&quot;
 &amp; &quot;he standard input (the Modula-3 Stdio.Stdin).\n  rd_open(fs: FileSystem&quot;
 &amp; &quot;, t: Text): Rd ! rd_failure\n    Given a file system and a file name, r&quot;
 &amp; &quot;eturns a reader on a file \n    (a Modula-3 FileRd, open for read). The&quot;
 &amp; &quot; local file system is available\n    through the predefined lexically s&quot;
 &amp; &quot;coped identifier \&quot;fileSys\&quot;.\n    Moreover, \&quot;fileSysReader\&quot; is a rea&quot;
 &amp; &quot;d-only local file system.\n  rd_getChar(r: Rd): Char ! rd_failure rd_eo&quot;
 &amp; &quot;fFailure thread_alerted\n    Get the next character from a reader.\n  r&quot;
 &amp; &quot;d_eof(r: Rd): Bool ! rd_failure thread_alerted\n    Test for the end-of&quot;
 &amp; &quot;-stream on a reader.\n  rd_unGetChar(r: Rd): Ok\n    Put the last chara&quot;
 &amp; &quot;cter obtained by getChar back into the reader \n    (unfortunately, it &quot;
 &amp; &quot;may crash if misused!).\n  rd_charsReady(r: Rd): Int ! rd_failure\n    &quot;
 &amp; &quot;The number of characters that can be read without blocking. \n  rd_getT&quot;
 &amp; &quot;ext(r: Rd, n: Int): Text ! rd_failure thread_alerted\n    Read the next&quot;
 &amp; &quot; n characters, or at most n on end-of-file.\n  rd_getLine(r: Rd): Text &quot;
 &amp; &quot;! rd_failure rd_eofFailure thread_alerted\n    Read the next line and r&quot;
 &amp; &quot;eturn it without including the end-of-line \n    character.\n  rd_index&quot;
 &amp; &quot;(r: Rd): Int\n    The current reader position.\n  rd_length(r: Rd): Int&quot;
 &amp; &quot; ! rd_failure thread_alerted\n    Length of a reader (including read pa&quot;
 &amp; &quot;rt).\n  rd_seek(r: Rd, n: Int): Ok ! rd_failure thread_alerted\n    Rep&quot;
 &amp; &quot;osition a reader.\n  rd_close(r: Rd): Ok ! rd_failure thread_alerted\n &quot;
 &amp; &quot;   Close a reader.\n  rd_intermittent(r: Rd): Bool\n    Whether the rea&quot;
 &amp; &quot;der is stream-like (not file-like).\n  rd_seekable(r: Rd): Bool\n    Wh&quot;
 &amp; &quot;ether the reader can be repositioned.\n  rd_closed(r: Rd): Bool\n    Wh&quot;
 &amp; &quot;ether the reader is closed.\n&quot;;

CONST E9 =
   &quot;  graph_failure: Exception \n  graph_new(): Graph \n  graph_redisplay(g&quot;
 &amp; &quot;: Graph): Ok \n  graph_animate(g: Graph, t0:Real, t1: Real): Ok \n  gra&quot;
 &amp; &quot;ph_clear(g: Graph): Ok \n  graph_setWorld(g: Graph, w: Real, e: Real, n&quot;
 &amp; &quot;: Real, s: Real): Ok \n  graph_setMargin(g: Graph, margin: Real): Ok \n&quot;
 &amp; &quot;  graph_setAspect(g: Graph, aspect: Real): Ok \n  graph_setPreferredSiz&quot;
 &amp; &quot;e(g: Graph, h: Real, v: Real): Ok \n  graph_setPixelSizeDivisor(g: Grap&quot;
 &amp; &quot;h, h: Real, v: Int): Ok \n  graph_verticesAt(g: Graph, w: Real, e: Real&quot;
 &amp; &quot;, n: Real, s: Real): [Vertex] \n  graph_vertexHiLisAt(g: Graph, w: Real&quot;
 &amp; &quot;, e: Real, n: Real, s: Real): [VertexHiLi]\n  graph_edgesAt(g: Graph, w&quot;
 &amp; &quot;: Real, e: Real, n: Real, s: Real): [Edge] \n  graph_polygonsAt(g: Grap&quot;
 &amp; &quot;h, w: Real, e: Real, n: Real, s: Real): [Polygon] \n  graph_setClickAct&quot;
 &amp; &quot;ion(g: Graph, p: (Graph,Real,Real)-&gt;Ok): Ok \n    set the procedure to &quot;
 &amp; &quot;be invoked on single AND double down mouse transitions\n  graph_setClic&quot;
 &amp; &quot;kReleaseAction(g: Graph, p: (Graph,Real,Real)-&gt;Ok): Ok \n    set the pr&quot;
 &amp; &quot;ocedure to be invoked on up mouse transitions\n  graph_setDoubleClickAc&quot;
 &amp; &quot;tion(g: Graph, p: (Graph,Real,Real)-&gt;Ok): Ok \n    set the procedure to&quot;
 &amp; &quot; be invoked on double down mouse transitions\n  \n  graph_newVertex(g: &quot;
 &amp; &quot;Graph): Vertex \n  graph_moveVertex(v: Vertex, x: Real, y: Real, animat&quot;
 &amp; &quot;e: Bool): Ok \n  graph_moveVertexOnPath(v: Vertex, path: (Real)-&gt;[2*Rea&quot;
 &amp; &quot;l]): Ok \n  graph_removeVertex(v: Vertex): Ok \n  graph_vertexToFront(v&quot;
 &amp; &quot;: Vertex): Ok \n  graph_vertexToBack(v: Vertex): Ok \n  graph_setVertex&quot;
 &amp; &quot;Size(v: Vertex, h: Real, v: Real): Ok \n  graph_setVertexShape(v: Verte&quot;
 &amp; &quot;x, shape: Text): Ok \n     (shape is \&quot;rectangle\&quot; or \&quot;ellipse\&quot;) \n  &quot;
 &amp; &quot;graph_setVertexColor(v: Vertex, c: Color): Ok \n  graph_setVertexFont(v&quot;
 &amp; &quot;: Vertex, f: Font): Ok \n  graph_setVertexLabel(v: Vertex, label: Text)&quot;
 &amp; &quot;: Ok \n  graph_setVertexLabelColor(v: Vertex, c: Color}): Ok \n  graph_&quot;
 &amp; &quot;setVertexBorder(v: Vertex, border: Real): Ok \n  graph_setVertexBorderC&quot;
 &amp; &quot;olor(v: Vertex, c: Color): Ok \n  graph_getVertexPosition(v: Vertex): [&quot;
 &amp; &quot;2*Real] \n  \n  graph_newVertexHiLi(v: Vertex): Vertex&quot;;

CONST E9_0 =
   &quot;HiLi \n  graph_moveVertexHiLi(vh: VertexHiLi, v: Vertex, animate: Bool)&quot;
 &amp; &quot;: Ok \n  graph_removeVertexHiLi(vh: VertexHiLi): Ok \n  graph_vertexHiL&quot;
 &amp; &quot;iToFront(vh: VertexHiLi): Ok \n  graph_vertexHiLiToBack(vh: VertexHiLi)&quot;
 &amp; &quot;: Ok \n  graph_setVertexHiLiColor(vh: VertexHiLi, c: Color): Ok \n  gra&quot;
 &amp; &quot;ph_setVertexHiLiBorder(vh: VertexHiLi, h v: Real): Ok \n  graph_getVert&quot;
 &amp; &quot;exHiLiVertex(vh: VertexHiLi): Vertex \n  \n  graph_newEdge(v1:Vertex, v&quot;
 &amp; &quot;2: Vertex): Edge \n  graph_moveEdge(e: Edge, v1: Vertex, v2: Vertex, an&quot;
 &amp; &quot;imate: Bool): Ok \n  graph_moveEdgeBezier(e: Edge, v1: Vertex, v2: Vert&quot;
 &amp; &quot;ex, c1: Vertex, c2: Vertex,\n    animate: Bool): Ok \n  graph_removeEdg&quot;
 &amp; &quot;e(e: Edge): Ok \n  graph_edgeToFront(e: Edge): Ok \n  graph_edgeToBack(&quot;
 &amp; &quot;e: Edge): Ok \n  graph_setEdgeWidth(e: Edge, width: Real): Ok \n  graph&quot;
 &amp; &quot;_setEdgeColor(e: Edge, c: Color): Ok \n  graph_setEdgeArrows(e: Edge, a&quot;
 &amp; &quot;rrowAtV1: Bool, arrowAtV2: Bool): Ok \n  graph_getEdgeVertices(e: Edge)&quot;
 &amp; &quot;: [2*Vertex] \n  graph_getEdgeControls(e: Edge): [Vertex]\n    (returns&quot;
 &amp; &quot; 0 or 2 vertices) \n  \n  graph_newPolygon(vs: [Vertex]): Polygon \n  g&quot;
 &amp; &quot;raph_movePolygon(p: Polygon, vs: [Vertex], animate: Bool): Ok \n  graph&quot;
 &amp; &quot;_removePolygon(p: Polygon): Ok \n  graph_polygonToFront(p: Polygon): Ok&quot;
 &amp; &quot; \n  graph_polygonToBack(p: Polygon): Ok \n  graph_setPolygonColor(p: P&quot;
 &amp; &quot;olygon, c: Color): Ok \n  \n  graph_newFont(g: Graph, family: Text, siz&quot;
 &amp; &quot;e: Real, \n                slant: Text, weight: Text, foundry: Text): F&quot;
 &amp; &quot;ont \n    (family is \&quot;Helvetica\&quot;...; normal size is 0.0353; slant is &quot;
 &amp; &quot;\&quot;Roman\&quot;,\n    \&quot;Italic\&quot;, \&quot;Oblique\&quot;, \&quot;ReverseItalic\&quot;, \&quot;ReverseOb&quot;
 &amp; &quot;lique\&quot;, \&quot;Other\&quot;, \&quot;Any\&quot;; \n     weight is \&quot;bold\&quot;...; foundry is \&quot;&quot;
 &amp; &quot;*\&quot;... \n  graph_defaultFont: Font \n  \n  graph_newSpectrum(g: Graph):&quot;
 &amp; &quot; Spectrum \n    a spectrum is an animatable color; it is a legal color &quot;
 &amp; &quot;\n  graph_setSpectrumColor(s: Spectrum, c: Color): Ok \n    set the vis&quot;
 &amp; &quot;ible-right-now color of the spectrum \n  graph_setSpectrumRange(s: Spec&quot;
 &amp; &quot;trum, range: (Real)-&gt;Color): Ok \n    set the color range for future an&quot;
 &amp; &quot;imations; domain in 0.0..1.0 \n  \n  graph_show(g: Graph): Ok \n  graph&quot;
 &amp; &quot;_hide&quot;;

CONST E9_1 =
   &quot;(g: Graph): Ok \n  \n  Some(T&lt;:{}) graph_setObjectLayer(o: T, layer: In&quot;
 &amp; &quot;t): Ok \n    Don\'t use this call! layer= 0(fore), 1(normal), 2(back) \n&quot;
;

CONST E10 =
   &quot;The ASCII characters are divided into the following classes:\n\n  Blank&quot;
 &amp; &quot;         HT LF FF CR SP\n  Reserved      \&quot; \' ~\n  Delimiter     ( ) ,&quot;
 &amp; &quot; . ; [ ] _ { } ? !\n  Special       # $ % &amp; * + - / : &lt; = &gt; @ \\ ^ |\n &quot;
 &amp; &quot; Digit         0 ... 9\n  Letter        A ... Z ` a ... z\n  Illegal   &quot;
 &amp; &quot;    all the others\n\nMoreover:\n\n  a StringChar is either\n  - any si&quot;
 &amp; &quot;ngle character that is not an Illegal character or one of \', \&quot;, \\.\n&quot;
 &amp; &quot;  - any of the pairs of characters \\\', \\\&quot;, \\\\.\n\n  a Comment is,&quot;
 &amp; &quot; recursively, a sequence of non-Illegal characters and comments, \n  en&quot;
 &amp; &quot;closed between \&quot;(*\&quot; and \&quot;*)\&quot;.\n\nFrom these, the following lexemes &quot;
 &amp; &quot;are formed:\n\n  Space     a sequence of Blanks and Comments.\n  AlphaN&quot;
 &amp; &quot;um  a sequence of Letters and Digits starting with a Letter.\n  Symbol &quot;
 &amp; &quot;   a sequence of Specials.\n  Char      a single StringChar enclosed be&quot;
 &amp; &quot;tween two \'.\n  String    a sequence of StringChars enclosed between t&quot;
 &amp; &quot;wo \&quot;.\n  Int       a sequence of Digits, possibly preceded by a single&quot;
 &amp; &quot; minus sign ~.\n  Real      two Ints separated by ., possibly preceded &quot;
 &amp; &quot;by ~.\n  Delimiter a single Delimiter character.\n\nA stream of charact&quot;
 &amp; &quot;ers is split into lexemes by always extracting the longest \nprefix tha&quot;
 &amp; &quot;t is a lexeme. Note that Delimiters do not stick to each other or to\no&quot;
 &amp; &quot;ther tokens even when they are not separated by Space, but some care mu&quot;
 &amp; &quot;st be \ntaken so that Symbols are not inadvertently merged.\n\nA token &quot;
 &amp; &quot;is either a Char, String, Int, Real, Delimiter, Identifier, or Keyword.&quot;
 &amp; &quot;\nOnce a stream of characters has been split into lexemes, tokens are e&quot;
 &amp; &quot;xtracted\nas follows. \n\n  Space lexemes do not produce tokens.\n  Cha&quot;
 &amp; &quot;r, String, Int, Real, and Delimiter lexemes are also tokens.\n  AlphaNu&quot;
 &amp; &quot;m and Symbol lexemes are Identifier tokens, except when they have been\n&quot;
 &amp; &quot;    explicitly declared to be keywords, in which case they are Keyword &quot;
 &amp; &quot;tokens.\n&quot;;

CONST E11 =
   &quot;  pickle_failure: Exception\n  All(T) pickle_write(w: Wr, v: T): Ok \n &quot;
 &amp; &quot;   ! pickle_failure wr_failure thread_alerted\n    Copy a value to a wr&quot;
 &amp; &quot;iter, similarly to sys_copy.\n  Some(T) pickle_read(r: Rd): T \n    ! p&quot;
 &amp; &quot;ickle_failure rd_failure rd_eofFailure thread_alerted\n    Copy a value&quot;
 &amp; &quot; from a reader, similarly to sys_copy.\n&quot;;

CONST E12 =
   &quot;TOP-LEVEL PHRASES                    \011any term or definition ended b&quot;
 &amp; &quot;y \&quot;;\&quot;\n  a;                                 \011\n\nDEFINITIONS (iden&quot;
 &amp; &quot;tifiers are denoted by \&quot;x\&quot;, terms are denoted by \&quot;a\&quot;)\n  let x1=a1,&quot;
 &amp; &quot;...,xn=an                \011definition of constant identifiers\n  let &quot;
 &amp; &quot;rec x1=a1,...,xn=an            \011definition of recursive procedures\n&quot;
 &amp; &quot;  var x1=a1,...,xn=an                \011definition of updatable identi&quot;
 &amp; &quot;fiers\n\nSEQUENCES (denoted by \&quot;s\&quot;)           \011each \&quot;ai\&quot; (a term&quot;
 &amp; &quot; or a definition) is\n  a1;...;an                          \011executed&quot;
 &amp; &quot;; yields \&quot;an\&quot; (or \&quot;ok\&quot; if n=0)\n\nTERMS (denoted by \&quot;a\&quot;,\&quot;b\&quot;,\&quot;c&quot;
 &amp; &quot;\&quot;; identifiers are denoted by \&quot;x\&quot;,\&quot;l\&quot;; modules are denoted by \&quot;m\&quot;&quot;
 &amp; &quot;)\n  x\011m_x                      \011identifiers\n  x:=a             &quot;
 &amp; &quot;                  \011assignment\n\n  ok  true  false  \'a\'  \&quot;abc\&quot;  &quot;
 &amp; &quot;3  1.5\011constants\n\n  [a1,...,an]                     \011arrays\n  &quot;
 &amp; &quot;a[b]\011a[b]:=c               \011        array selection, array update&quot;
 &amp; &quot;\n  a[b for b\']\011a[b for b\']:=c        \011subarray selection, suba&quot;
 &amp; &quot;rray update\n\n  option l =&gt; s end              \011term \&quot;s\&quot; tagged b&quot;
 &amp; &quot;y \&quot;l\&quot;\n\n  proc(x1,...,xn) s end              \011procedures\n  a(b1,&quot;
 &amp; &quot;...,bn)                       \011procedure invocation\n  m_x(a1,...,an&quot;
 &amp; &quot;)                     \011invocation of \&quot;x\&quot; from module \&quot;m\&quot;\n  a b &quot;
 &amp; &quot;c                              \011infix (right-ass.) version of \&quot;b(a,&quot;
 &amp; &quot;c)\&quot;\n\n  meth(x,x1,...,xn) s end            \011method with self \&quot;x\&quot;&quot;
 &amp; &quot;\n  {l1=&gt;a1,...,ln=&gt;an}                \011object with fields named \&quot;l&quot;
 &amp; &quot;1\&quot;...\&quot;ln\&quot;\n  {protected, serialized, ...}           \011protected an&quot;
 &amp; &quot;d serialized object\n  {l1=&gt;alias l2 of a2 end,...}        \011object w&quot;
 &amp; &quot;ith delegated fields\n  a.l    a.l(a1, ..., an)            \011field se&quot;
 &amp; &quot;lection / method invocation\n  a.l:=b                             \011f&quot;
 &amp; &quot;ield update / method override\n  clone(a1,...,an)                      &quot;
 &amp; &quot;object cloning\n  a1.l1:=alias l2 of a2 end             field delegatio&quot;
 &amp; &quot;n\n  delegate a1 to a2 end \011        object delegation\n\n  d        &quot;
 &amp; &quot;                          \011definition\n  if s1 then s2              &quot;
 &amp; &quot;        \011conditional\n    elsif s3 then s4..&quot;;

CONST E12_0 =
   &quot;. else sn end  \011  (\&quot;elsif\&quot;, \&quot;else\&quot; optional)\n  a andif b\011a o&quot;
 &amp; &quot;rif b             \011conditional conjunction/disjunction\n  case s of &quot;
 &amp; &quot;l1(x1)=&gt;s1,...,               case over the tag \&quot;li\&quot; of an option\n  &quot;
 &amp; &quot;  ln(xn)=&gt;sn else s0 end     \011          binding \&quot;xi\&quot; in \&quot;si\&quot; (\&quot;&quot;
 &amp; &quot;else\&quot; optional)\n  loop s end                         \011loop\n  for &quot;
 &amp; &quot;i=a to b do s end              \011iteration through successive integer&quot;
 &amp; &quot;s\n  foreach i in a do s end            \011iteration through an array\n&quot;
 &amp; &quot;  foreach i in a map s end           \011yielding an array of the resul&quot;
 &amp; &quot;ts\n  exit                               \011exit the innermost loop, f&quot;
 &amp; &quot;or, foreach\n\n  exception(\&quot;exc\&quot;)                   \011new exception&quot;
 &amp; &quot; value named \&quot;exc\&quot;\n  raise(a)                           \011raise an&quot;
 &amp; &quot; exception\n  try s except                       \011exception capture\n&quot;
 &amp; &quot;    a1=&gt;s1,...,an=&gt;sn else s0 end     \011  (\&quot;else\&quot; optional)\n  try &quot;
 &amp; &quot;s1 finally s2 end                \011finalization\n\n  condition()  sig&quot;
 &amp; &quot;nal(a)  broadcast(a)\011creating and signaling a condition\n  watch s1 &quot;
 &amp; &quot;until s2 end                \011waiting for a signal and a boolean guar&quot;
 &amp; &quot;d\n  fork(a1,a2)    join(a)\011        forking and joining a thread\n  &quot;
 &amp; &quot;pause(a)\011                        pausing the current thread \n\n  mu&quot;
 &amp; &quot;tex()\011                        creating a mutex\n  lock s1 do s2 end &quot;
 &amp; &quot;               \011locking a mutex in a scope\n  wait(a1,a2)           &quot;
 &amp; &quot;     \011        waiting on a mutex for a condition\n\n  (s)           &quot;
 &amp; &quot;                     \011block structure / precedence group\n&quot;;

CONST E13 =
   &quot;  rects_failure: Exception \n  rects_new(): Rects \n    An empty displa&quot;
 &amp; &quot;y list of rectangles.\n  rects_setWorld(r: Rects, w: Real, e: Real, n: &quot;
 &amp; &quot;Real, s: Real): Ok\n    Set the world coordinates.\n  rects_setMargin(r&quot;
 &amp; &quot;: Rects, w: Real, e: Real, n: Real, s: Real): Ok\n    Set the window ma&quot;
 &amp; &quot;rgin in points.\n  rects_setMins(r: Rects, wd: Real, ht: Real): Ok\n   &quot;
 &amp; &quot; Set the minimum size for displaying an item, in points.\n  rects_setBg&quot;
 &amp; &quot;(r: Rects, c: Color): Ok\n    Set the window background color.\n  rects&quot;
 &amp; &quot;_setN(r: Rects, n: Int, redisplay: Bool): Ok\n    Set the number of rec&quot;
 &amp; &quot;tangles in the display list; they do not exist yet.\n  rects_setPositio&quot;
 &amp; &quot;n(r: Rects, n: Int, w: Real, e: Real, n: Real, s: Real,\n      redispla&quot;
 &amp; &quot;y: Bool): Ok\n    Set the position of the nth rectangle, then it exists&quot;
 &amp; &quot;.\n  rects_getPosition(r: Rects, n: Int): [4*Real]\n    Get the positio&quot;
 &amp; &quot;n of the nth rectangle; w,e,n,s.\n  rects_setColor(r: Rects, n: Int, c:&quot;
 &amp; &quot; Color, redisplay: Bool): Ok\n    Set the color of the nth rectangle, t&quot;
 &amp; &quot;hen it exists.\n  rects_delete(r: Rects, n: Int, redisplay: Bool): Ok\n&quot;
 &amp; &quot;    Delete the nth rectangle; then it does not exist.\n  rects_exists(r&quot;
 &amp; &quot;: Rects, n: Int): Ok\n    Does the nth rectangle exist.\n  rects_draw(r&quot;
 &amp; &quot;: Rects, n: Int): Ok\n    Draw the nth rectangle.\n  rects_erase(r: Rec&quot;
 &amp; &quot;ts, n: Int): Ok\n    Erase the nth rectangle.\n  rects_show(r: Rects): &quot;
 &amp; &quot;Ok \n    Show the window.\n  rects_hide(r: Rects): Ok \n    Hide the wi&quot;
 &amp; &quot;ndow.\n&quot;;

CONST E14 =
   &quot;  process_new(pr: Processor, nameAndArgs: [Text], mergeOut: Bool): Proc&quot;
 &amp; &quot;ess\n    Create a process from a processor and the given process name a&quot;
 &amp; &quot;nd arguments.\n    The local processor is available as the lexically sc&quot;
 &amp; &quot;oped identifier \n    \&quot;processor\&quot;. If mergeOut is true, use a single &quot;
 &amp; &quot;pipe for stdout and stderr.\n  process_in(p: Process): Wr\n    The stdi&quot;
 &amp; &quot;n pipe of a process.\n  process_out(p: Process): Rd\n    The stdout pip&quot;
 &amp; &quot;e of a process.\n  process_err(p: Process): Rd\n    The stderr pipe of &quot;
 &amp; &quot;a process.\n  process_complete(p: Process): Int\n    Wait for the proce&quot;
 &amp; &quot;ss to exit, close all its pipes, and return the exit code.\n  process_f&quot;
 &amp; &quot;ilter(pr: Processor, nameAndArgs: [Text], input: Text): Text \n    ! ne&quot;
 &amp; &quot;t_failure\n    Create a process from a processor and the given process &quot;
 &amp; &quot;name and arguments.\n    The local processor is available as the lexica&quot;
 &amp; &quot;lly scoped identifier \n    \&quot;processor\&quot;. The stderr output is merged &quot;
 &amp; &quot;to stdout.\n    Usage: feed the input to its stdin pipe and close it; r&quot;
 &amp; &quot;ead all the output\n    from its stdout pipe and close it; return the o&quot;
 &amp; &quot;utput.\n&quot;;

CONST E15 =
   &quot;  t: Text\n    A string in double quotes.\n  text_new(size: Int, init: &quot;
 &amp; &quot;Char): Text\n    A text of size \'size\', all filled with \'init\'.\n  &quot;
 &amp; &quot;text_empty(t: Text): Bool\n    Test for empty text.\n  text_length(t: T&quot;
 &amp; &quot;ext): Int\n    Length of a text.\n  text_equal(t1: Text, t2: Text): Boo&quot;
 &amp; &quot;l\n    Text equality (case sensitive).\n  text_char(t: Text, i: Int): C&quot;
 &amp; &quot;har\n    The i-th character of a text (if it exists); zero-indexed.\n  &quot;
 &amp; &quot;text_sub(t: Text, start: Int, size: Int): Text\n    The subtext beginni&quot;
 &amp; &quot;ng at \'start\', and of size \'size\' (if it exists).\n  text_&amp;(t1: Tex&quot;
 &amp; &quot;t, t2: Text): Text\n    (also infix \'&amp;\') The concatenation of two tex&quot;
 &amp; &quot;ts.\n  text_precedes(t1: Text, t2: Text): Bool\n    Whether \'t1\' prec&quot;
 &amp; &quot;edes \'t2\' in lexicographic (ascii) order.\n  text_decode(t: Text): Te&quot;
 &amp; &quot;xt\n    Every occurrence of an escape sequence is replaced by the corre&quot;
 &amp; &quot;sponding \n    non-printing formatting character:  \\\\ = \\;  \\\' = \'&quot;
 &amp; &quot;;  \\\&quot; = \&quot;;  \\n = LF; \n    \\r = CR;  \\t = HT;  \\f = FF;  \\t = H&quot;
 &amp; &quot;T;  \\xxx = xxx (octals 000..177);  \n    \\c = c (otherwise).\n  text_&quot;
 &amp; &quot;encode(t: Text): Text\n    Every occurrence of a non-printing formattin&quot;
 &amp; &quot;g character is replaced by an \n    escape sequence.\n  text_explode(se&quot;
 &amp; &quot;ps: Text, t: Text): [Text]\n    Splits an input text into a similarly o&quot;
 &amp; &quot;rdered array of texts, each a maximal \n    subsequence of the input te&quot;
 &amp; &quot;xt not containing sep chars. The empty text is \n    exploded as a sing&quot;
 &amp; &quot;leton array of the empty text. Each sep char in the input \n    produce&quot;
 &amp; &quot;s a break, so the size of the result is 1 + the number of sep chars \n &quot;
 &amp; &quot;   in the text. implode(explode( \&quot;c\&quot;,text),\'c\') is the identity.\n &quot;
 &amp; &quot; text_implode(sep: Char, a: [Text]): Text ! net_failure\n    Concatenat&quot;
 &amp; &quot;e an array of texts into a single text, separating the pieces by a \n  &quot;
 &amp; &quot;  single sep char. A zero-length array is imploded as the empty text. \n&quot;
 &amp; &quot;    explode(\&quot;c\&quot;,implode( \'c\',text)) is the identity provided that t&quot;
 &amp; &quot;he array has \n    positive size and sep does not occur in the array el&quot;
 &amp; &quot;ements.\n  text_hash(t: Text): Int\n    A hash function.\n  text_toInt(&quot;
 &amp; &quot;t: Text): Int\n  &quot;;

CONST E15_0 =
   &quot;  Convert a text to an integer (see also fmt_).\n  text_fromInt(n: Int)&quot;
 &amp; &quot;: Text\n    Convert an integer to a text (see also lex_).\n  text_findF&quot;
 &amp; &quot;irstChar(c: Char, t: Text, n: Int): Int\011\n    The index of the first&quot;
 &amp; &quot; occurrence of \'c\' in \'t\', past \'n\'. -1 if not found.\n  text_fin&quot;
 &amp; &quot;dLastChar(c: Char, t: Text, n: Int): Int\n    The index of the last occ&quot;
 &amp; &quot;urrence of \'c\' in \'t\', before \'n\'. -1 if not found.\n  text_findF&quot;
 &amp; &quot;irst(p: Text, t: Text, n: Int): Int\n    The index of the first char of&quot;
 &amp; &quot; the first occurrence of \'p\' in \'t\', past \'n\'. \n    -1 if not fo&quot;
 &amp; &quot;und.\n  text_findLast(p: Text, t: Text, n: Int): Int\n    The index of &quot;
 &amp; &quot;the first char of the last occurrence of \'p\' in \'t\', before \n    \'&quot;
 &amp; &quot;n\'. -1 if not found.\n  text_replaceAll(old: Text, new: Text, t: Text)&quot;
 &amp; &quot;: Text\n    Replace all occurrences of \'old\' by \'new\' in \'t\', as &quot;
 &amp; &quot;found by iterating \n    \'findFirst\'.\n&quot;;

CONST E16 =
   &quot;  math_pi: Real\n    3.1415926535897932384626433833.\n  math_e: Real\n &quot;
 &amp; &quot;   2.7182818284590452353602874714.\n  math_degree: Real\n    0.01745329&quot;
 &amp; &quot;2519943295769236907684; 1 degree in radiants.\n  math_exp(n: Real): Rea&quot;
 &amp; &quot;l\n    e to the n-th power.\n  math_log(n: Real): Real\n    log base e.&quot;
 &amp; &quot;\n  math_sqrt(n: Real): Real\n    Square root.\n  math_hypot(n: Real, m&quot;
 &amp; &quot;: Real): Real\n    sqrt((n*n)+(m*m)).\n  math_pow(n: Real, m: Real): Re&quot;
 &amp; &quot;al\n    n to the m-th power.\n  math_cos(n: Real): Real\n    Cosine in &quot;
 &amp; &quot;radians.\n  math_sin(n: Real): Real\n    Sine in radians.\n  math_tan(n&quot;
 &amp; &quot;: Real): Real\n    Tangent in radians.\n  math_acos(n: Real): Real\n   &quot;
 &amp; &quot; Arc cosine in radians.\n  math_asin(n: Real): Real\n    Arc sine in ra&quot;
 &amp; &quot;dians.\n  math_atan(n: Real): Real\n    Arc tangent in radians.\n  math&quot;
 &amp; &quot;_atan2(n: Real, m: Real): Real\n    Arc tangent of n/m in radians.\n&quot;;

CONST E17 =
   &quot;  color_named(name: Text): Color\n    Get a color from its name (see th&quot;
 &amp; &quot;e ColorName M3 interface).\n  color_rgb(r: Real, g: Real, b: Real): Col&quot;
 &amp; &quot;or\n    Get a color from rgb (each 0.0 .. 1.0).\n  color_hsv(hr: Real, &quot;
 &amp; &quot;sr: Real, v: Real): Color\n    Get a color from hsv (each 0.0 .. 1.0).\n&quot;
 &amp; &quot;  color_r(c: Color): Real\n    The red color component.\n  color_g(c: C&quot;
 &amp; &quot;olor): Real\n    The green color component.\n  color_b(c: Color): Real\n&quot;
 &amp; &quot;    The blue color component.\n  color_h(c: Color): Real\n    The hue c&quot;
 &amp; &quot;olor component.\n  color_s(c: Color): Real\n    The saturation color co&quot;
 &amp; &quot;mponent.\n  color_v(c: Color): Real\n    The value color component.\n  &quot;
 &amp; &quot;color_brightness(c: Color): Real\n    The total brightness (0.0 .. 1.0)&quot;
 &amp; &quot;.\n&quot;;

CONST E18 =
   &quot;  n.m: Int\n    Positive real constants; m is optional.\n  ~n.m: Int\n &quot;
 &amp; &quot;   Negative real constants; m is optional.\n  real_minus(n: Real): Real&quot;
 &amp; &quot;\n    (also \'-n\') Real negation.\n  real_minus(n: Int): Int\n    (als&quot;
 &amp; &quot;o \'-n\') Overloaded integer negation.\n  real_+(n1: Real, n2: Real): R&quot;
 &amp; &quot;eal\n    (also infix \'+\') Real addition.\n  real_+(n1: Int, n2: Int):&quot;
 &amp; &quot; Int\n    (also infix \'+\') Overloaded integer addition.\n  real_-(n1:&quot;
 &amp; &quot; Real, n2: Real): Real\n    (also infix \'-\') Real difference.\n  real&quot;
 &amp; &quot;_-(n1: Int, n2: Int): Int\n    (also infix \'-\') Overloaded integer di&quot;
 &amp; &quot;fference.\n  real_*(n1: Real, n2: Real): Real\n    (also infix \'*\') R&quot;
 &amp; &quot;eal multiplication.\n  real_*(n1: Int, n2: Int): Int\n    (also infix \'&quot;
 &amp; &quot;*\') Overloaded integer multiplication.\n  real_/(n1: Real, n2: Real): &quot;
 &amp; &quot;Real\n    (also infix \'/\') Real division.\n  real_/(n1: Int, n2: Int)&quot;
 &amp; &quot;: Int\n    (also infix \'/\') Overloaded integer division.\n  real_&lt;(n1&quot;
 &amp; &quot;: Real, n2: Real): Bool\n    (also infix \'&lt;\') Real less-than predicat&quot;
 &amp; &quot;e\n  real_&lt;(n1: Int, n2: Int): Bool\n    (also infix \'&lt;\') Overloaded &quot;
 &amp; &quot;integer less-than predicate\n  real_&gt;(n1: Real, n2: Real): Bool\n    (a&quot;
 &amp; &quot;lso infix \'&gt;\') Real greater-than predicate\n  real_&gt;(n1: Int, n2: Int&quot;
 &amp; &quot;): Bool\n    (also infix \'&gt;\') Overloaded integer greater-than predica&quot;
 &amp; &quot;te\n  real_&lt;=(n1: Real, n2: Real): Bool\n    (also infix \'&lt;=\') Real n&quot;
 &amp; &quot;o-greater-than predicate\n  real_&lt;=(n1: Int, n2: Int): Bool\n    (also &quot;
 &amp; &quot;infix \'&lt;=\') Overloaded integer no-greater-than pred.\n  real_&gt;=(n1: R&quot;
 &amp; &quot;eal, n2: Real): Bool\n    (also infix \'&gt;=\') Real no-less-than predica&quot;
 &amp; &quot;te.\n  real_&gt;=(n1: Int, n2: Int): Bool\n    (also infix \'&gt;=\') Overloa&quot;
 &amp; &quot;ded integer no-less-than pred.\n  real_float(n: Int): Real\n    (also \'&quot;
 &amp; &quot;float(n)\') Integer-to-real conversion.\n  real_float(n: Real): Real\n &quot;
 &amp; &quot;   (also \'float(n)\') Overloaded; identity on reals.\n  real_round(n: &quot;
 &amp; &quot;Real): Int\n    (also \'round(n)\') Real-to-integer rounding.\n  real_r&quot;
 &amp; &quot;ound(n: Int): Int\n    (also \'round(n)\') Overloaded; identity on inte&quot;
 &amp; &quot;gers.\n  real_floor(n: Real): Int\n    Greatest integers no greater tha&quot;
 &amp; &quot;n n.\n  real_floor(n: Int): Int\n &quot;;

CONST E18_0 =
   &quot;   Overloaded; identity on integers.\n  real_ceiling(n: Real): Int\n   &quot;
 &amp; &quot; Least integers no less than n.\n  real_ceiling(n: Int): Int\n    Overl&quot;
 &amp; &quot;oaded; identity on integers.\n&quot;;

CONST E19 =
   &quot;  lex_failure: Exception\n  lex_scan(r: Rd, t: Text): Text ! rd_failure&quot;
 &amp; &quot; thread_alerted\n    Read from r the longest prefix formed of character&quot;
 &amp; &quot;s listed in t, and return \n    it.\n  lex_skip(r: Rd, t: Text): Ok ! r&quot;
 &amp; &quot;d_failure thread_alerted\n    Read from r the longest prefix formed of &quot;
 &amp; &quot;characters listed in t, and discard \n    it.\n  lex_match(r: Rd, t: Te&quot;
 &amp; &quot;xt): Ok ! lex_failure rd_failure thread_alerted\n    Read from r the st&quot;
 &amp; &quot;ring t and discard it; raise failure if not found.\n  lex_bool(r: Rd): &quot;
 &amp; &quot;Bool ! lex_failure rd_failure thread_alerted\n    Skip blanks, and atte&quot;
 &amp; &quot;mpt to read a boolean from r.\n  lex_int(r: Rd): Int ! lex_failure rd_f&quot;
 &amp; &quot;ailure thread_alerted\n    Skip blanks, and attempt to read an integer &quot;
 &amp; &quot;from r.\n  lex_real(r: Rd): Real ! lex_failure rd_failure thread_alerte&quot;
 &amp; &quot;d\n    Skip blanks, and attempt to read a real from r.\n&quot;;

CONST E20 =
   &quot;  form_failure: Exception\n  form_new(t: Text): Form ! form_failure\n  &quot;
 &amp; &quot;  Read a form description from a text.\n  form_fromFile(file: Text): Fo&quot;
 &amp; &quot;rm ! form_failure thread_alerted\n    Read a form description from a fi&quot;
 &amp; &quot;le.\n  form_attach(fv: Form, name: Text, f: (Form)-&gt;Ok): Ok ! form_fail&quot;
 &amp; &quot;ure\n    Attach a procedure to an event, under a form. The procedure is&quot;
 &amp; &quot; passed \n    back the form when the event happens.\n  form_getBool(fv:&quot;
 &amp; &quot; Form, name: Text, property: Text): Bool ! form_failure\n    Get the bo&quot;
 &amp; &quot;olean value of the property of the named interactor.\n    (Do not confu&quot;
 &amp; &quot;se with form_getBoolean.)\n  form_putBool(fv: Form, name: Text, propert&quot;
 &amp; &quot;y: Text, b: Bool): Ok \n    ! form_failure\n    Set the boolean value o&quot;
 &amp; &quot;f the named property of the named interactor.\n    (Do not confuse with&quot;
 &amp; &quot; form_putBoolean.)\n  form_getInt(fv: Form, name: Text, property: Text)&quot;
 &amp; &quot;: Int ! form_failure\n    Get the integer value of the named property o&quot;
 &amp; &quot;f the named interactor. If \n    property is the empty text, get the \322&quot;
 &amp; &quot;value\323 property.\n  form_putInt(fv: Form, name: Text, property: Text&quot;
 &amp; &quot;, n: Int): Ok \n    ! form_failure\n    Set the integer value of the na&quot;
 &amp; &quot;med property of the named interactor. If \n    property is the empty te&quot;
 &amp; &quot;xt, set the \322value\323 property.\n  form_getText(fv: Form, name: Tex&quot;
 &amp; &quot;t, property: Text): Text ! form_failure\n    Get the text value of the &quot;
 &amp; &quot;named property of the named interactor. If \n    property is the empty &quot;
 &amp; &quot;text, get the \322value\323 property.\n  form_putText(fv: Form, name: T&quot;
 &amp; &quot;ext, property: Text, t: Text, append: Bool)\n   : Ok ! form_failure\n  &quot;
 &amp; &quot;  Set the text value of the named property of the named interactor. If &quot;
 &amp; &quot;\n    property is the empty text, set the \322value\323 property.\n  fo&quot;
 &amp; &quot;rm_getBoolean(fv: Form, name: Text): Bool ! form_failure\n    Get the b&quot;
 &amp; &quot;oolean value of the named boolean-choice interactor.\n  form_putBoolean&quot;
 &amp; &quot;(fv: Form, name: Text, b: Bool): Ok ! form_failure\n    Set the boolean&quot;
 &amp; &quot; value of the named boolean-choice interactor.\n  form_getChoice(fv: Fo&quot;
 &amp; &quot;rm, radioName: Text): Text ! form_failure\n    Get the choice value &quot;;

CONST E20_0 =
   &quot;of the named radio interactor.\n  form_putChoice(fv: Form, radioName: T&quot;
 &amp; &quot;ext, choiceName: Text): Ok \n    ! form_failure\n    Set the choice val&quot;
 &amp; &quot;ue of the named radio interactor.\n  form_getReactivity(fv: Form, name:&quot;
 &amp; &quot; Text): Text ! form_failure\n    Get the reactivity of the named intera&quot;
 &amp; &quot;ctor. It can be \&quot;active\&quot;, \n    \&quot;passive\&quot;, \&quot;dormant\&quot;, or \&quot;vanish&quot;
 &amp; &quot;ed\&quot;.\n  form_putReactivity(fv: Form, name: Text, r: Text): Ok ! form_f&quot;
 &amp; &quot;ailure\n    Set the reactivity of the named interactor. It can be \&quot;act&quot;
 &amp; &quot;ive\&quot;, \n    \&quot;passive\&quot;, \&quot;dormant\&quot;, or \&quot;vanished\&quot;.\n  form_popUp(f&quot;
 &amp; &quot;v: Form, name: Text): Ok ! form_failure\n    Pop up the named interacto&quot;
 &amp; &quot;r.\n  form_popDown(fv: Form, name: Text): Ok ! form_failure\n    Pop do&quot;
 &amp; &quot;wn the named interactor.\n  form_numOfChildren(fv: Form, parent: Text):&quot;
 &amp; &quot; Int ! form_failure\n    Return the number of children of parent.\n  fo&quot;
 &amp; &quot;rm_child(fv: Form, parent: Text, n: Int): Text ! form_failure\n    Retu&quot;
 &amp; &quot;rn the n-th child of parent.\n  form_childIndex(fv: Form, parent: Text,&quot;
 &amp; &quot; child: Text): Int ! form_failure\n    Return the index of the given ch&quot;
 &amp; &quot;ild of parent.\n  form_insert(fv: Form, parent: Text, t: Text, n: Int):&quot;
 &amp; &quot; Ok ! form_failure\n    Insert the form described by t as child n of pa&quot;
 &amp; &quot;rent.\n  form_move(fv: Form, parent: Text, child: Text, toChild: Text, &quot;
 &amp; &quot;before: Bool)\n    : Ok ! form_failure\n    Move child before or after &quot;
 &amp; &quot;toChild of parent; after \&quot;\&quot; means first,\n    before \&quot;\&quot; means last.&quot;
 &amp; &quot;\n  form_delete(fv: Form, parent: Text, child: Text): Ok ! form_failure&quot;
 &amp; &quot;\n    Delete the named child of parent.\n  form_deleteRange(fv: Form, p&quot;
 &amp; &quot;arent: Text, n: Int, count: Int): Ok \n    ! form_failure\n    Delete c&quot;
 &amp; &quot;ount children of parent, from child n.\n  form_takeFocus(fv: Form, name&quot;
 &amp; &quot;: Text, select: Bool): Ok ! form_failure\n    Make the named interactor&quot;
 &amp; &quot; acquire the keyboard focus, and optionally \n    select its entire tex&quot;
 &amp; &quot;t contents.\n  form_show(fv: Form): Ok ! form_failure\n    Show a windo&quot;
 &amp; &quot;w containing the form on the default display.\n  form_showAt(fv: Form, &quot;
 &amp; &quot;at: Text, title: Text): Ok ! form_failure\n    Show a window containi&quot;;

CONST E20_1 =
   &quot;ng the form on a display. For an X display,\n    at=&lt;machine name&gt;(\':\'&quot;
 &amp; &quot;|\'::\')&lt;num&gt;(\'\'|\'.\'&lt;num&gt;); at=\&quot;\&quot; is the default \n    display. T&quot;
 &amp; &quot;he title is shown in the window header.\n  form_hide(fv: Form): Ok ! fo&quot;
 &amp; &quot;rm_failure\n    Hide the window containing the form.\n&quot;;

CONST E21 =
   &quot;  c: Char\n    A character in single quotes.\n  ascii_char(n: Int): Cha&quot;
 &amp; &quot;r\n    The ascii character of integer code \'n\'.\n  ascii_val(c: Char)&quot;
 &amp; &quot;: Int\011\n    The integer code of the ascii character \'c\'.\n&quot;;

CONST E22 =
   &quot;  All(T) sys_copy(x: T): T ! net_failure\n    (also \'copy(x)\') Make a&quot;
 &amp; &quot; local copy of a value, including most distributed \n    values.\n  sys&quot;
 &amp; &quot;_getEnvVar(t: Text): Text\n    Return the value of the env variable who&quot;
 &amp; &quot;se name is t, or \&quot;\&quot; if there is no \n    such variable.\n  sys_paramC&quot;
 &amp; &quot;ount: Int\n    The number of program parameters.\n  sys_getParam(n: Int&quot;
 &amp; &quot;): Text\n    Return the n-th program parameter (indexed from 0).\n  sys&quot;
 &amp; &quot;_callFailure: Exception\n    Can be raised by Modula-3 code during a sy&quot;
 &amp; &quot;s_call.\n  Some(T)Some(U) sys_call(name: Text, args: [T]): U ! sys_call&quot;
 &amp; &quot;Failure\n    Call a pre-registered Modula-3 procedure.\n&quot;;

CONST E23 =
   &quot;  thread_mutex(): Mutex\n    (also \'mutex()\') A new mutex.\n  thread_&quot;
 &amp; &quot;condition(): Condition\n    (also \'condition()\') A new condition.\n  &quot;
 &amp; &quot;Some(T) thread_self(): Thread(T)\n    The current thread.\n  All(T) thr&quot;
 &amp; &quot;ead_fork(f: ()-&gt;T, stackSize: Int): Thread(T)\n    (also \'fork(f,n)\')&quot;
 &amp; &quot; Fork a new thread executing f. If stackSize is zero, a \n    small def&quot;
 &amp; &quot;ault size is used.\n  All(T) thread_join(th: Thread(T)): T\n    (also \'&quot;
 &amp; &quot;join(th)\') Wait for a thread to complete, and return the result of \n &quot;
 &amp; &quot;   its procedure.\n  thread_wait(mx: Mutex, cd: Condition): Ok\n    (al&quot;
 &amp; &quot;so \'wait(mx,cd)\') Wait on a mutex and a condition.\n  thread_acquire(&quot;
 &amp; &quot;mx: Mutex): Ok\n    Acquire a mutex (use lock ... end instead).\n  thre&quot;
 &amp; &quot;ad_release(mx: Mutex): Ok\n    Release a mutex (use lock ... end instea&quot;
 &amp; &quot;d)\n  thread_broadcast(cd: Condition): Ok\n    (also \'broadcast(cd)\')&quot;
 &amp; &quot; Wake-up to all threads waiting on a condition. \n  thread_signal(cd: C&quot;
 &amp; &quot;ondition): Ok\n    (also \'signal(cd)\') Wake-up at least one thread wa&quot;
 &amp; &quot;iting on a condition.\n  thread_pause(r: Real): Ok\n    (also \'pause(r&quot;
 &amp; &quot;)\') Pause the current thread for r seconds.\n  All(T) thread_lock(m: M&quot;
 &amp; &quot;utex, body: ()-&gt;T): T\n    Execute under a locked mutex (use lock ... e&quot;
 &amp; &quot;nd instead).\n  thread_alerted: Exception\n    (See the threads spec.)\n&quot;
 &amp; &quot;  All(T) thread_alert(t: Thread(T)): Ok\n    (See the threads spec.)\n &quot;
 &amp; &quot; thread_testAlert(): Bool\n    (See the threads spec.)\n  thread_alertW&quot;
 &amp; &quot;ait(mx: Mutex, cd: Condition): Ok ! thread_alerted\n    (See the thread&quot;
 &amp; &quot;s spec.)\n  All(T) thread_alertJoin(th: Thread(T)): Ok ! thread_alerted&quot;
 &amp; &quot;\n    (See the threads spec.)\n  thread_alertPause(r: Real): Ok ! threa&quot;
 &amp; &quot;d_alerted\n    (See the threads spec.)\n&quot;;

BEGIN
END ObliqBdl2.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
