<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliq/src/ObLibOnline.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliq/src/ObLibOnline.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObLibOnline.i3">ObLibOnline</A></implements></module>;
IMPORT <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>, <A HREF="../../synex/src/SynScan.i3">SynScan</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqprint/src/ObPrintValue.i3">ObPrintValue</A>, <A HREF="../../obliqparse/src/ObFrame.i3">ObFrame</A>;

TYPE

  OnlineCode =
    {GetSearchPath, SetSearchPath, PushSilence, PopSilence,
     Print, PrintText, PrintFlush, SetPrompt};

  OnlineOpCode =
    ObLib.OpCode OBJECT
        code: OnlineCode;
      END;

  PackageOnline =
    ObLib.T OBJECT
      scanner: SynScan.T;
      OVERRIDES
        Eval:=EvalOnline;
      END;

  VAR packageOnline: PackageOnline;

  PROCEDURE <A NAME="NewOnlineOC"><procedure>NewOnlineOC</procedure></A>(name: TEXT; arity: INTEGER; code: OnlineCode)
    : OnlineOpCode =
  BEGIN
    RETURN NEW(OnlineOpCode, name:=name, arity:=arity, code:=code);
  END NewOnlineOC;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
  TYPE OpCodes = ARRAY OF ObLib.OpCode;
  VAR opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW(REF OpCodes, NUMBER(OnlineCode));
    opCodes^ :=
      OpCodes{
      NewOnlineOC(&quot;getSearchPath&quot;, 0, OnlineCode.GetSearchPath),
      NewOnlineOC(&quot;setSearchPath&quot;, 1, OnlineCode.SetSearchPath),
      NewOnlineOC(&quot;pushSilence&quot;, 0, OnlineCode.PushSilence),
      NewOnlineOC(&quot;popSilence&quot;, 0, OnlineCode.PopSilence),
      NewOnlineOC(&quot;print&quot;, 2, OnlineCode.Print),
      NewOnlineOC(&quot;printText&quot;, 1, OnlineCode.PrintText),
      NewOnlineOC(&quot;printFlush&quot;, 0, OnlineCode.PrintFlush),
      NewOnlineOC(&quot;setPrompt&quot;, 2, OnlineCode.SetPrompt)
      };
    packageOnline :=
      NEW(PackageOnline, name:=&quot;sys&quot;, opCodes:=opCodes, scanner:=NIL);
    ObLib.Register(packageOnline);
  END Setup;

  PROCEDURE <A NAME="RegisterScanner"><procedure>RegisterScanner</procedure></A>(scanner: SynScan.T) =
    BEGIN
      packageOnline.scanner := scanner;
    END RegisterScanner;

  PROCEDURE <A NAME="EvalOnline"><procedure>EvalOnline</procedure></A>(self: PackageOnline; opCode: ObLib.OpCode;
      arity: ObLib.OpArity; READONLY args: ObValue.ArgArray;
      temp: BOOLEAN; loc: SynLocation.T)
      : ObValue.Val RAISES {ObValue.Error, ObValue.Exception} =
    VAR int1: INTEGER; text1, text2: TEXT;
    BEGIN
      CASE NARROW(opCode, OnlineOpCode).code OF
      | OnlineCode.GetSearchPath =&gt;
          RETURN ObValue.NewText(ObFrame.FmtSearchPath(ObFrame.searchPath));
      | OnlineCode.SetSearchPath =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          ObFrame.searchPath := ObFrame.LexSearchPath(TextRd.New(text1));
          RETURN ObValue.valOk;
      | OnlineCode.Print =&gt;
          TYPECASE args[2] OF | ObValue.ValInt(node) =&gt; int1:=node.int;
          ELSE ObValue.BadArgType(2, &quot;int&quot;, self.name, opCode.name, loc); END;
          ObPrintValue.PrintVal(SynWr.out, args[1], ObLib.libraries, NIL, int1);
          RETURN ObValue.valOk;
      | OnlineCode.PrintText =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          SynWr.Text(SynWr.out, text1);
          RETURN ObValue.valOk;
      | OnlineCode.PrintFlush =&gt;
          SynWr.Flush(SynWr.out);
          RETURN ObValue.valOk;
      | OnlineCode.PushSilence =&gt;
          SynWr.PushSilence(SynWr.out);
          RETURN ObValue.valOk;
      | OnlineCode.PopSilence =&gt;
          SynWr.PopSilence(SynWr.out);
          RETURN ObValue.valOk;
      | OnlineCode.SetPrompt =&gt;
          TYPECASE args[1] OF | ObValue.ValText(node) =&gt; text1:=node.text;
          ELSE ObValue.BadArgType(1, &quot;text&quot;, self.name, opCode.name, loc); END;
          TYPECASE args[2] OF | ObValue.ValText(node) =&gt; text2:=node.text;
          ELSE ObValue.BadArgType(2, &quot;text&quot;, self.name, opCode.name, loc); END;
          IF self.scanner # NIL THEN
            SynScan.SetPrompt(self.scanner, text1, text2);
          END;
          RETURN ObValue.valOk;
      ELSE
        ObValue.BadOp(self.name, opCode.name, loc);
      END;
    END EvalOnline;

BEGIN
END ObLibOnline.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
