<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliq/src/ObLibOnlineHelp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliq/src/ObLibOnlineHelp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObLibOnlineHelp.i3">ObLibOnlineHelp</A></implements></module>;
IMPORT <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../bundleintf/src/Bundle.i3">Bundle</A>, <A HREF="../../obliqparse/derived/ObliqBdl.i3">ObliqBdl</A>, <A HREF="../derived/ObliqBdl2.i3">ObliqBdl2</A>,
 <A HREF="../../obliqparse/src/ObFrame.i3">ObFrame</A>, <A HREF="../../obliqprint/src/ObPrintValue.i3">ObPrintValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>;

  PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
  BEGIN
    ObLib.RegisterHelp(&quot;sysOnline&quot;, HelpOnline);
    ObLib.RegisterHelp(&quot;sys&quot;, HelpSys);
    ObLib.RegisterHelp(&quot;bool&quot;, HelpBool);
    ObLib.RegisterHelp(&quot;int&quot;, HelpInt);
    ObLib.RegisterHelp(&quot;real&quot;, HelpReal);
    ObLib.RegisterHelp(&quot;math&quot;, HelpMath);
    ObLib.RegisterHelp(&quot;ascii&quot;, HelpAscii);
    ObLib.RegisterHelp(&quot;text&quot;, HelpText);
    ObLib.RegisterHelp(&quot;array&quot;, HelpArray);
    ObLib.RegisterHelp(&quot;net&quot;, HelpNet);

    ObCommand.Register(ObLib.helpCommandSet,
      NEW(ObCommand.T, name:=&quot;syntax&quot;, sortingName:=&quot;syntax&quot;,
        Exec:=PrintHelpSyntax));

    ObCommand.Register(ObLib.helpCommandSet,
      NEW(ObCommand.T, name:=&quot;flags&quot;, sortingName:=&quot;flags&quot;,
        Exec:=PrintHelpFlags));

    ObCommand.Register(ObLib.helpCommandSet,
      NEW(ObCommand.T, name:=&quot;help&quot;, sortingName:=&quot; help&quot;,
        Exec:=PrintHelpHelp));

    ObCommand.Register(ObLib.helpCommandSet,
      NEW(ObCommand.T, name:=&quot;lib&quot;, sortingName:=&quot;lib      &quot;,
        Exec:=PrintHelpLibrary));

    ObCommand.Register(ObLib.helpCommandSet,
      NEW(ObCommand.T, name:=&quot;env&quot;, sortingName:=&quot;env&quot;,
        Exec:=PrintHelpEnv));
  END Setup;

PROCEDURE <A NAME="PrintHelpSyntax"><procedure>PrintHelpSyntax</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL) =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) THEN
        SynWr.Text(SynWr.out,
          &quot;  syntax            (overview)\n&quot; &amp;
          &quot;  syntax lexicon    (lexical matters)\n&quot; &amp;
          &quot;  syntax real       (the one used by the parser)\n&quot;);
      ELSIF Text.Equal(arg, &quot;?&quot;) THEN
        SynWr.Text(SynWr.out, Bundle.Get(ObliqBdl2.Get(),&quot;ObliqSyntax&quot;));
	SynWr.NewLine(SynWr.out);
      ELSIF Text.Equal(arg, &quot;lexicon&quot;) THEN
        SynWr.Text(SynWr.out, Bundle.Get(ObliqBdl2.Get(),&quot;ObliqLexicon&quot;));
	SynWr.NewLine(SynWr.out);
      ELSIF Text.Equal(arg, &quot;real&quot;) THEN
        SynWr.Text(SynWr.out, Bundle.Get(ObliqBdl.Get(),&quot;ObliqGram&quot;));
	SynWr.NewLine(SynWr.out);
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END PrintHelpSyntax;

PROCEDURE <A NAME="PrintHelpFlags"><procedure>PrintHelpFlags</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL) =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) THEN
        SynWr.Text(SynWr.out,
          &quot;  flags             (inspecting and setting system flags)\n&quot;);
      ELSIF Text.Equal(arg, &quot;?&quot;) THEN
        SynWr.Text(SynWr.out,
          &quot;  Say 'flag;' to list system flags and their values\n&quot; &amp;
          &quot;  Say 'flag &lt;name&gt;;' to inspect a flag\n&quot; &amp;
          &quot;  Say 'flag &lt;name&gt; &lt;value&gt;;' to set a flag\n&quot; &amp;
          &quot;      (enclose &lt;value&gt; in double quotes if needed)\n&quot;);
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END PrintHelpFlags;

PROCEDURE <A NAME="PrintHelpHelp"><procedure>PrintHelpHelp</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL) =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) OR Text.Equal(arg, &quot;?&quot;) THEN
        SynWr.Text(SynWr.out, &quot;Say 'help &lt;topic&gt;;' or 'help &lt;topic&gt; &lt;subtopic&gt;;'\n&quot;);
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END PrintHelpHelp;

PROCEDURE <A NAME="PrintPkgList"><procedure>PrintPkgList</procedure></A>(pkg: ObLib.Env; name: TEXT; env: Obliq.Env) =
  VAR opCodes: REF ObLib.OpCodes; library: ObLib.T;
  BEGIN
    pkg := ObLib.Lookup(name, pkg);
    IF pkg = NIL THEN RETURN END;
    PrintPkgList(pkg.rest, name, env);
    library := pkg.library;
    opCodes := library.opCodes;
    FOR i:=NUMBER(opCodes^)-1 TO 0 BY -1 DO
      TYPECASE opCodes^[i] OF
      | NULL =&gt;
      | ObFrame.FrameOpCode(opCode) =&gt;
        SynWr.Text(SynWr.out, &quot;  &quot; &amp; name &amp; &quot;_&quot; &amp; opCode.name &amp; &quot; = &quot;);
        ObPrintValue.PrintValSummary(SynWr.out, opCode.val, env.libEnv, NIL);
	SynWr.NewLine(SynWr.out);
      ELSE
      END;
    END;
    FOR i:=0 TO NUMBER(opCodes^)-1 DO
      TYPECASE opCodes^[i] OF
      | NULL =&gt;
      | ObFrame.FrameOpCode =&gt;
      ELSE SynWr.Text(SynWr.out, &quot;  &quot; &amp; name &amp; &quot;_&quot; &amp; opCodes^[i].name &amp; &quot;\n&quot;);
      END;
    END;
  END PrintPkgList;

PROCEDURE <A NAME="PrintHelpLibrary"><procedure>PrintHelpLibrary</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL) =
    VAR libEnv: ObLib.Env; sep: TEXT;
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) THEN
        SynWr.Text(SynWr.out,
          &quot;  lib               (show a list of loaded libraries)\n&quot; &amp;
          &quot;  lib &lt;lib&gt;         (show info about loaded library &lt;lib&gt;)\n&quot;);
      ELSIF Text.Equal(arg, &quot;?&quot;) THEN
        TYPECASE data OF
        | NULL =&gt;
        | Obliq.Env(env) =&gt;
           SynWr.Text(SynWr.out, &quot;  &quot;);
           libEnv := env.libEnv;
           sep := &quot;&quot;;
           LOOP
             IF libEnv=NIL THEN EXIT; END;
             SynWr.Text(SynWr.out, sep &amp; libEnv.library.name);
             sep := &quot;, &quot;;
             libEnv := libEnv.rest;
           END;
           SynWr.Text(SynWr.out, &quot;\n&quot;);
        ELSE
        END;
      ELSE
        TYPECASE data OF
        | NULL =&gt;
        | Obliq.Env(env) =&gt;
          IF ObLib.Lookup(arg, env.libEnv)=NIL THEN
            SynWr.Text(SynWr.out, &quot;  library not found\n&quot;)
          ELSE
            PrintPkgList(env.libEnv, arg, env);
          END;
        ELSE
        END;
	SynWr.NewLine(SynWr.out);
      END;
    END PrintHelpLibrary;

PROCEDURE <A NAME="PrintHelpEnv"><procedure>PrintHelpEnv</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL) =
    VAR valueEnv: ObValue.Env;
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) THEN
        SynWr.Text(SynWr.out,
          &quot;  env               (show all the environment)\n&quot;);
      ELSIF Text.Equal(arg, &quot;?&quot;) THEN
        TYPECASE data OF
        | NULL =&gt;
        | Obliq.Env(env) =&gt;
           valueEnv := env.valueEnv;
           LOOP
             IF valueEnv=NIL THEN EXIT END;
             SynWr.Text(SynWr.out, &quot;  let &quot; &amp; valueEnv.name.text &amp; &quot; = &quot;);
             ObPrintValue.PrintValSummary(SynWr.out,
                 NARROW(valueEnv, ObValue.LocalEnv).val, env.libEnv, NIL);
	     SynWr.NewLine(SynWr.out);
             valueEnv := valueEnv.rest;
           END;
        ELSE
        END;
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END PrintHelpEnv;
</PRE> ================== 

<P>  <PRE>PROCEDURE <A NAME="HelpOnline"><procedure>HelpOnline</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL) =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) THEN
        SynWr.Text(SynWr.out, &quot;  sysOnline         (the built-in system library, online extension)\n&quot;);
      ELSIF Text.Equal(arg, &quot;?&quot;) THEN
        SynWr.Text(SynWr.out, Bundle.Get(ObliqBdl2.Get(),&quot;ObliqHelpOnline&quot;));
	SynWr.NewLine(SynWr.out);
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END HelpOnline;

  PROCEDURE <A NAME="HelpSys"><procedure>HelpSys</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL)  =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) THEN
        SynWr.Text(SynWr.out, &quot;  sys               (the built-in system library)\n&quot;);
      ELSIF Text.Equal(arg, &quot;?&quot;) THEN
        SynWr.Text(SynWr.out, Bundle.Get(ObliqBdl2.Get(),&quot;ObliqHelpSys&quot;));
        SynWr.NewLine(SynWr.out);
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END HelpSys;

  PROCEDURE <A NAME="HelpBool"><procedure>HelpBool</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL)  =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) THEN
        SynWr.Text(SynWr.out, &quot;  bool              (the built-in boolean library)\n&quot;);
      ELSIF Text.Equal(arg, &quot;?&quot;) THEN
        SynWr.Text(SynWr.out, Bundle.Get(ObliqBdl2.Get(),&quot;ObliqHelpBool&quot;));
        SynWr.NewLine(SynWr.out);
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END HelpBool;

  PROCEDURE <A NAME="HelpInt"><procedure>HelpInt</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL)  =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) THEN
        SynWr.Text(SynWr.out, &quot;  int               (the built-in integer library)\n&quot;);
      ELSIF Text.Equal(arg, &quot;?&quot;) THEN
        SynWr.Text(SynWr.out, Bundle.Get(ObliqBdl2.Get(),&quot;ObliqHelpInt&quot;));
        SynWr.NewLine(SynWr.out);
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END HelpInt;

  PROCEDURE <A NAME="HelpReal"><procedure>HelpReal</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL)  =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) THEN
        SynWr.Text(SynWr.out, &quot;  real              (the built-in real library, with int overloading)\n&quot;);
      ELSIF Text.Equal(arg, &quot;?&quot;) THEN
        SynWr.Text(SynWr.out, Bundle.Get(ObliqBdl2.Get(),&quot;ObliqHelpReal&quot;));
        SynWr.NewLine(SynWr.out);
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END HelpReal;

  PROCEDURE <A NAME="HelpMath"><procedure>HelpMath</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL)  =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) THEN
        SynWr.Text(SynWr.out, &quot;  math              (the built-in math library)\n&quot;);
      ELSIF Text.Equal(arg, &quot;?&quot;) THEN
        SynWr.Text(SynWr.out, Bundle.Get(ObliqBdl2.Get(),&quot;ObliqHelpMath&quot;));
        SynWr.NewLine(SynWr.out);
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END HelpMath;

  PROCEDURE <A NAME="HelpAscii"><procedure>HelpAscii</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL)  =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) THEN
        SynWr.Text(SynWr.out, &quot;  ascii             (the built-in ascii library)\n&quot;);
      ELSIF Text.Equal(arg, &quot;?&quot;) THEN
        SynWr.Text(SynWr.out, Bundle.Get(ObliqBdl2.Get(),&quot;ObliqHelpChar&quot;));
        SynWr.NewLine(SynWr.out);
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END HelpAscii;

  PROCEDURE <A NAME="HelpText"><procedure>HelpText</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL)  =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) THEN
        SynWr.Text(SynWr.out, &quot;  text              (the built-in text library)\n&quot;);
      ELSIF Text.Equal(arg, &quot;?&quot;) THEN
        SynWr.Text(SynWr.out, Bundle.Get(ObliqBdl2.Get(),&quot;ObliqHelpText&quot;));
        SynWr.NewLine(SynWr.out);
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END HelpText;

  PROCEDURE <A NAME="HelpArray"><procedure>HelpArray</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL)  =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) THEN
        SynWr.Text(SynWr.out, &quot;  array             (the built-in array library)\n&quot;);
      ELSIF Text.Equal(arg, &quot;?&quot;) THEN
        SynWr.Text(SynWr.out, Bundle.Get(ObliqBdl2.Get(),&quot;ObliqHelpArray&quot;));
        SynWr.NewLine(SynWr.out);
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END HelpArray;

  PROCEDURE <A NAME="HelpNet"><procedure>HelpNet</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL)  =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) THEN
        SynWr.Text(SynWr.out, &quot;  net               (the built-in network library)\n&quot;);
      ELSIF Text.Equal(arg, &quot;?&quot;) THEN
        SynWr.Text(SynWr.out, Bundle.Get(ObliqBdl2.Get(),&quot;ObliqHelpNet&quot;));
        SynWr.NewLine(SynWr.out);
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END HelpNet;

BEGIN
END ObLibOnlineHelp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
