<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliq/src/ObliqOnline.i3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliq/src/ObliqOnline.i3</H2></A><HR>
<inInterface>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

INTERFACE <interface><A HREF="ObliqOnline.m3">ObliqOnline</A></interface>;
IMPORT <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>;

TYPE
  <A HREF="ObliqOnline.m3#T">T</A> &lt;: TPublic;
  TPublic =
    OBJECT
      env: Obliq.Env;
      swr: SynWr.T;
    END;
</PRE><BLOCKQUOTE><EM> An Obliq interpreter. The env field is the current interpreter environment:  
   it can be used to investigate the state of the interpreter. The swr field is 
   the writer the interpreter is using. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ObliqOnline.m3#Setup">Setup</A>();
</PRE><BLOCKQUOTE><EM> To be called once before any other use of is interface. </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ObliqOnline.m3#New">New</A>(greetings: TEXT:=&quot;&quot;; swr: SynWr.T:=NIL; loadDotObliq:
    BOOLEAN:=TRUE; env: Obliq.Env := NIL): T;
</PRE><BLOCKQUOTE><EM> An interactive interpreter (a read-eval-print loop), producing 
   output to swr (NIL = standard output). If loadDotObliq is true, 
   the file ~/.obliq is loaded. Returns an interpreter that can 
   be given input repeatedly via Interact. Env is the initial environment 
   for the interpreter; if env is NIL, Obliq.emptyEnv is used. Note 
   that the collection of registered built-in libraries, ObLib.libraries, 
   is global and shared by all interpreters. The env field of the 
   result can be used to extract partial or final results, by Obliq.Lookup. 
   </EM></BLOCKQUOTE><PRE>

PROCEDURE <A HREF="ObliqOnline.m3#Interact">Interact</A>(interpreter: T; rdName: TEXT:=&quot;&quot;; rd: Rd.T:=NIL;
  closeRd: BOOLEAN:=FALSE; generateEOF: BOOLEAN := TRUE);
</PRE><BLOCKQUOTE><EM> Push a new reader rd (NIL = standard input) as a source of characters 
   for the interpreter. Returns when rd is exhausted. 
   This procedure can be called repeatedly on the same
   interpreter, each time reusing the previous interpreter state.
   The rdName should be used to identify the reader (e.g. its file name, if any)
   for error reporting purposes. If closeRd is true, Rd.Close(rd) is 
   executed when rd is exhausted. If genereteEOF is true, an Eof lexical 
   token is generated when rd is exhausted (This means that, according to
   the Obliq syntax, the reader cannot end with an incomplete Obliq phrase.
   Moreover, if Eof is generated, unbalanced comments and quotes do not 
   propagate from one reader to the next). </EM></BLOCKQUOTE><PRE>

END ObliqOnline.
</PRE>
</inInterface>
<PRE>























</PRE>
</BODY>
</HTML>
