<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliq/src/ObliqOnline.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliq/src/ObliqOnline.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>

MODULE <module><implements><A HREF="ObliqOnline.i3">ObliqOnline</A></implements></module>;
IMPORT <A HREF="../../rw/src/Common/Rd.i3">Rd</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../rw/src/Common/Stdio.i3">Stdio</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../synex/src/SynScan.i3">SynScan</A>, <A HREF="../../metasyn/src/MetaParser.i3">MetaParser</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../synex/src/SynParse.i3">SynParse</A>, <A HREF="../../obliqrt/src/ObTree.i3">ObTree</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqprint/src/ObPrintValue.i3">ObPrintValue</A>, <A HREF="../../obliqrt/src/ObEval.i3">ObEval</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../params/src/Env.i3">Env</A>, <A HREF="../../os/src/Common/Pathname.i3">Pathname</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../obliqparse/src/ObliqParser.i3">ObliqParser</A>, <A HREF="../../obliqprint/src/ObliqPrinter.i3">ObliqPrinter</A>, <A HREF="ObLibOnline.i3">ObLibOnline</A>, <A HREF="ObLibOnlineHelp.i3">ObLibOnlineHelp</A>, <A HREF="../../os/src/Common/OSError.i3">OSError</A>, <A HREF="../../rw/src/Common/FileRd.i3">FileRd</A>, <A HREF="../../runtime/src/common/RTProcess.i3">RTProcess</A>;
</PRE> ============ Online flags ============ 

<P><PRE>CONST
  Version = 1; Enhancement = 1; BugFix = 0;
  DefaultPrintDepth = 4;

PROCEDURE <A NAME="ShowVersion"><procedure>ShowVersion</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL) =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) OR Text.Equal(arg, &quot;?&quot;) THEN
	SynWr.Text(SynWr.out, self.name &amp; &quot; &quot;
	  &amp; Fmt.Int(Version) &amp; &quot;.&quot;
	  &amp; Fmt.Int(Enhancement) &amp; &quot;.&quot;
	  &amp; Fmt.Int(BugFix));
	SynWr.NewLine(SynWr.out);
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END ShowVersion;

VAR showAfterParsing: BOOLEAN := FALSE;

PROCEDURE <A NAME="ShowAfterParsing"><procedure>ShowAfterParsing</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL) =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) OR Text.Equal(arg, &quot;?&quot;) THEN
	SynWr.Text(SynWr.out, self.name &amp; &quot; {On Off} is &quot;);
	IF showAfterParsing THEN SynWr.Text(SynWr.out, &quot;On&quot;);
	ELSE SynWr.Text(SynWr.out, &quot;Off&quot;); END;
	SynWr.NewLine(SynWr.out);
      ELSIF Text.Equal(arg, &quot;On&quot;) THEN showAfterParsing:=TRUE;
      ELSIF Text.Equal(arg, &quot;Off&quot;) THEN showAfterParsing:=FALSE;
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END ShowAfterParsing;

PROCEDURE <A NAME="ShowNetObjMsgs"><procedure>ShowNetObjMsgs</procedure></A>(self: ObCommand.T; arg: TEXT; data: REFANY:=NIL) =
    BEGIN
      IF Text.Equal(arg, &quot;!&quot;) OR Text.Equal(arg, &quot;?&quot;) THEN
	SynWr.Text(SynWr.out, self.name &amp; &quot; {On Off} is &quot;);
	IF ObValue.showNetObjMsgs THEN SynWr.Text(SynWr.out, &quot;On&quot;);
	ELSE SynWr.Text(SynWr.out, &quot;Off&quot;); END;
	SynWr.NewLine(SynWr.out);
      ELSIF Text.Equal(arg, &quot;On&quot;) THEN ObValue.showNetObjMsgs:=TRUE;
      ELSIF Text.Equal(arg, &quot;Off&quot;) THEN ObValue.showNetObjMsgs:=FALSE;
      ELSE
	SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name
	  &amp; &quot;: bad argument: &quot; &amp; arg);
	SynWr.NewLine(SynWr.out);
      END;
    END ShowNetObjMsgs;
</PRE> <P>
PROCEDURE PrintAfterParsing(term: ObTree.Term; env: Obliq.Env) =
  BEGIN
    IF showAfterParsing THEN
      SynWr.Beg(SynWr.out, 2);
      SynWr.Text(SynWr.out, <CODE>Parsed term: </CODE>);
      SynWr.Break(SynWr.out);
      ObPrintTree.PrintTerm(SynWr.out, term, env.checkEnv, 100);
      SynWr.End(SynWr.out);
      SynWr.NewLine(SynWr.out); 
      SynWr.Flush(SynWr.out);
    END;
  END PrintAfterParsing;


<P> ============ Do it  ============ 

<P><PRE>REVEAL <A NAME="T">T</A> =
  TPublic BRANDED OBJECT
    parser: SynParse.T;
  END;

PROCEDURE <A NAME="New"><procedure>New</procedure></A>(greetings: TEXT:=&quot;&quot;; swr: SynWr.T:=NIL;
    loadDotObliq: BOOLEAN:=TRUE; env: Obliq.Env := NIL):T =
    VAR interpreter: T; filename: Pathname.T; rd: Rd.T;
  BEGIN
    IF swr=NIL THEN swr:=SynWr.out END;
    IF env=NIL THEN env:=Obliq.EmptyEnv() END;

    interpreter := NEW(T, env:=env,
      swr:=swr, parser:=ObliqParser.New(swr));
    ObLibOnline.RegisterScanner(interpreter.parser.Scanner());

    IF NOT Text.Empty(greetings) THEN
      SynWr.Text(interpreter.swr, &quot;\n&quot; &amp; greetings &amp; &quot;\n\n&quot;);
      SynWr.Flush(interpreter.swr);
    END;

    IF loadDotObliq THEN
      TRY
        filename := Pathname.Join(Env.Get(&quot;HOME&quot;), &quot;.obliq&quot;, NIL);
        rd := FileRd.Open(filename);
        SynWr.Text(SynWr.out, &quot;Loading '&quot; &amp; filename &amp; &quot;'\n&quot;);
        Interact(interpreter, filename, rd, TRUE, TRUE);
        SynWr.Flush(interpreter.swr);
      EXCEPT OSError.E =&gt;
      END;
    END;

    RETURN interpreter;
  END New;

PROCEDURE <A NAME="Interact"><procedure>Interact</procedure></A>(interpreter: T; rdName: TEXT:=&quot;&quot;; rd: Rd.T:=NIL;
    closeRd: BOOLEAN:=FALSE; generateEOF: BOOLEAN := TRUE) =
  VAR
    oldEnv: Obliq.Env;
    phrase: ObTree.Phrase;
    value: ObValue.Val;
    printDepth: INTEGER;
  BEGIN
    IF rd=NIL THEN rd:=Stdio.stdin END;
    ObliqParser.ReadFrom(interpreter.parser, rdName, rd,
      closeRd, generateEOF);
    LOOP
      TRY
        SynScan.FirstPrompt(interpreter.parser.Scanner());
        phrase := ObliqParser.ParsePhrase(interpreter.parser);
        oldEnv := interpreter.env;
        value :=
          ObliqParser.EvalPhrase(interpreter.parser, phrase,
            (*in-out*) interpreter.env);
        TYPECASE phrase OF
        | NULL =&gt;
        | ObTree.PhraseTerm(node) =&gt;
            IF node.printDepth &gt;=0 THEN
              printDepth := node.printDepth;
            ELSIF SynScan.TopLevel(interpreter.parser.Scanner()) THEN
              printDepth:=DefaultPrintDepth;
            ELSE
              printDepth:=0;
            END;
	    TYPECASE node.term OF
	    | ObTree.TermLet(node) =&gt;
	      ObPrintValue.PrintPhraseLet(interpreter.swr,
	        interpreter.env.checkEnv, oldEnv.checkEnv,
	        interpreter.env.valueEnv, oldEnv.valueEnv, node.var,
                interpreter.env.libEnv, printDepth+1);
	    ELSE
	      ObPrintValue.PrintVal(interpreter.swr,
	        value, interpreter.env.libEnv,
	        interpreter.env.checkEnv, printDepth);
                SynWr.NewLine(interpreter.swr);
	    END;
	ELSE
        END;
	SynWr.Flush(interpreter.swr);
      EXCEPT
      | ObliqParser.Eof =&gt;
          EXIT;
      | ObValue.Error(packet) =&gt;
          IF NOT Text.Equal(packet.msg, &quot;Static Error&quot;) THEN
            ObValue.ErrorMsg(interpreter.swr, packet);
            ErrorDetectedMsg(interpreter.parser, packet.location);
          END;
      | ObValue.Exception(packet) =&gt;
          ObValue.ExceptionMsg(interpreter.swr, packet);
          ErrorDetectedMsg(interpreter.parser, packet.location);
      END;
    END;
  END Interact;

PROCEDURE <A NAME="ErrorDetectedMsg"><procedure>ErrorDetectedMsg</procedure></A>(parser: SynParse.T; loc: SynLocation.T) =
  VAR currInfo: SynLocation.Info; sc: SynScan.T; swr: SynWr.T;
  BEGIN
    sc := parser.Scanner();
    swr := SynScan.GetWriter(sc);
    SynScan.CurrentLocationInfo(sc, (*out*)currInfo);
    IF Text.Empty(currInfo.fileName) THEN
      SynWr.Text(swr, &quot;Error detected &quot;, loud:=TRUE);
      SynLocation.PrintLineDifference(swr, loc, currInfo.line);
      SynWr.NewLine(swr, loud:=TRUE);
    END;
    SynWr.Flush(swr, loud:=TRUE);
  END ErrorDetectedMsg;
</PRE> ============ Setup  ============ 

<P> VAR mainThread: Thread.T; 

<P><PRE>PROCEDURE <A NAME="OnInterrupt"><procedure>OnInterrupt</procedure></A>() =
  BEGIN
    (* Thread.Alert(mainThread); *)
    ObEval.interrupt := TRUE;
  END OnInterrupt;

PROCEDURE <A NAME="SignalSetup"><procedure>SignalSetup</procedure></A>() =
  VAR old: RTProcess.InterruptHandler;
  BEGIN
    old := RTProcess.OnInterrupt(OnInterrupt);
  END SignalSetup;

PROCEDURE <A NAME="Setup"><procedure>Setup</procedure></A>() =
BEGIN
  (* Thread.IncDefaultStackSize(64*1024); *)
  (* mainThread := Thread.Self(); *)

  SynLocation.PackageSetup();
  SynParse.PackageSetup();
  MetaParser.PackageSetup(); &lt;* NOWARN *&gt;
  Obliq.PackageSetup();
  ObliqParser.PackageSetup();
  ObliqPrinter.PackageSetup();
  SignalSetup();

  ObCommand.Register(ObTree.doCommandSet,
    NEW(ObCommand.T, name:=&quot;Version&quot;, sortingName:=&quot; Version&quot;,
        Exec:=ShowVersion));

  showAfterParsing := FALSE;
  ObCommand.Register(ObTree.doCommandSet,
    NEW(ObCommand.T, name:=&quot;ShowParsing&quot;, sortingName:=&quot;ShowParsing&quot;,
        Exec:=ShowAfterParsing));

  ObCommand.Register(ObTree.doCommandSet,
    NEW(ObCommand.T, name:=&quot;ShowNetObjMsgs&quot;, sortingName:=&quot;ShowNetObjMsgs&quot;,
        Exec:=ShowNetObjMsgs));

    ObLibOnline.Setup();
  ObLibOnlineHelp.Setup();
END Setup;

BEGIN
END ObliqOnline.
</PRE> Old SIGINT handling.
*** Non-portable: this is the MIPS version
PROCEDURE OnSIGINT(sig, code: Ctypes.int; 
  scp: UNTRACED REF Usignal.struct_sigcontext) =
  BEGIN
    (* Thread.Alert(mainThread); 
    <PRE>ObEval.interrupt := TRUE;
  END OnSIGINT;

*** Non-portable: this is the SPARC version
PROCEDURE OnSIGINT(sig, code: Ctypes.int;
  scp: UNTRACED REF Usignal.struct_sigcontext;
  (* SPARC *) addr: ADDRESS) =
  BEGIN
    (* Thread.Alert(mainThread); *)
    ObEval.interrupt := TRUE;
  END OnSIGINT;

PROCEDURE SignalSetup() =
  VAR vec, ovec: Usignal.struct_sigvec;
  BEGIN
    vec.sv_handler := OnSIGINT;
    vec.sv_mask := Usignal.empty_sv_mask;
    vec.sv_flags := 0;
    EVAL Usignal.sigvec(Usignal.SIGINT, (*var*)vec, (*var*)ovec);
  END SignalSetup;
*)
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
