<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObAmbientLightGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObAmbientLightGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sat Mar  5 19:09:02 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObAmbientLightGO.i3">ObAmbientLightGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/AmbientLightGO.i3">AmbientLightGO</A>, <A HREF="../../anim3D/src/AmbientLightGOProxy.i3">AmbientLightGOProxy</A>, <A HREF="../../anim3D/src/LightGO.i3">LightGO</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="ObColorProp.i3">ObColorProp</A>,
       <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObLightGO.i3">ObLightGO</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>,
       <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;AmbientLightGO&quot;;
</PRE>***************************************************************************
 Wrapper for AmbientLightGO.T                                              
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObLightGO.T BRANDED &quot;ObAmbientLightGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (light : AmbientLightGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;an AmbientLightGO.T&gt;&quot;, po := light) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      light.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name : TEXT; arity : INTEGER; code : Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;, 1, Code.New)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;AmbientLightGO.obl&quot;);
    TProto := loader.get (&quot;AmbientLightGO_TProto&quot;);

    (*** Register the proxy maker ***)
    AmbientLightGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH color = ObColorProp.GetOverloadedVal (args, 1, self, opCode, loc),
           light = NEW (AmbientLightGO.T).init () DO
        light.setProp (LightGO.Colour.bind (color));
        RETURN light.proxy.obj;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObAmbientLightGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
