<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObAnim3D.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObAnim3D.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Fri Jul 29 14:25:38 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObAnim3D.i3">ObAnim3D</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/Anim3D.i3">Anim3D</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObBuiltIn.i3">ObBuiltIn</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

TYPE
  Code = {lock};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

CONST
  pkgname = &quot;Anim3D&quot;;

PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;lock&quot;, -1, Code.lock)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (&lt;* UNUSED *&gt; self         : Package;
                               opCode       : ObLib.OpCode;
                  &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  &lt;* UNUSED *&gt; READONLY args: ObValue.ArgArray;
                  &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  &lt;* UNUSED *&gt; loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.lock =&gt;
      RETURN NEW (ObBuiltIn.ValMutex,
                  what  := &quot;&lt;a Thread.Mutex&gt;&quot;,
                  mutex := Anim3D.lock);
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObAnim3D.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
