<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObAnimHandle.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObAnimHandle.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sat May 28 20:08:51 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObAnimHandle.i3">ObAnimHandle</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/AnimHandle.i3">AnimHandle</A>, <A HREF="../../anim3D/src/AnimHandleProxy.i3">AnimHandleProxy</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>,
       <A HREF="ObProxiedObj.i3">ObProxiedObj</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;AnimHandle&quot;;
</PRE>***************************************************************************
 Wrapper for AnimHandle.T                                                  
***************************************************************************

<P><PRE>TYPE
  T = ObProxiedObj.T BRANDED OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (ah : AnimHandle.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;an AnimHandle.T&gt;&quot;, po := ah) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      ah.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;

PROCEDURE <A NAME="GetT"><procedure>GetT</procedure></A> (args    : ObValue.ArgArray;
                idx     : INTEGER;
                package : ObLib.T;
                opCode  : ObLib.OpCode;
                loc     : SynLocation.T) : AnimHandle.T
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | T (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetT;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes := NEW (REF OpCodes, NUMBER (Code));
  BEGIN
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,      0, Code.New),
            NewOpCode (&quot;Animate&quot;,  1, Code.Animate)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** retrieve the prototype ***)
    loader.load (&quot;AnimHandle.obl&quot;);
    TProto := loader.get (&quot;AnimHandle_TProto&quot;);

    (*** Register the proxy makers ***)
    AnimHandleProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New, Animate};

  OpCode = ObLib.OpCode BRANDED OBJECT
    code: Code;
  END;

  Package = ObLib.T BRANDED OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH val = AnimHandle.New () DO
        RETURN val.proxy.obj;
      END;
    | Code.Animate =&gt;
      WITH ah = GetT (args, 1, self, opCode, loc) DO
        ah.animate ();
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObAnimHandle.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
