<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObAux.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObAux.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Tue Jul 26 18:38:38 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObAux.i3">ObAux</A></implements></module>;

IMPORT <A HREF="../../bundleintf/src/Bundle.i3">Bundle</A>, <A HREF="../../fmtlex/src/Fmt.i3">Fmt</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../derived/ObLib3DBundle.i3">ObLib3DBundle</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>,
       <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../rw/src/Common/TextWr.i3">TextWr</A>, <A HREF="../../rw/src/Common/Wr.i3">Wr</A>;

VAR
  mu  : MUTEX;
  wr  : Wr.T;
  swr : SynWr.T;

PROCEDURE <A NAME="ErrorToText"><procedure>ErrorToText</procedure></A> (packet : ObValue.ErrorPacket) : TEXT =
  BEGIN
    LOCK mu DO
      Obliq.ReportError (swr, packet);
      RETURN TextWr.ToText (wr);
    END;
  END ErrorToText;

PROCEDURE <A NAME="ExceptionToText"><procedure>ExceptionToText</procedure></A> (packet: ObValue.ExceptionPacket) : TEXT =
  BEGIN
    LOCK mu DO
      Obliq.ReportException (swr, packet);
      RETURN TextWr.ToText (wr);
    END;
  END ExceptionToText;

PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg, pkgname, m3name : TEXT) =
  BEGIN
    IF m3name = NIL THEN
      m3name := pkgname;
    END;
    IF Text.Equal (arg, &quot;!&quot;) THEN
      SynWr.Text (SynWr.out,
                  &quot;  &quot; &amp; Fmt.Pad (pkgname, 18, ' ', Fmt.Align.Left) &amp;
                  &quot;(built-in interface to Anim3D's &quot; &amp; m3name &amp; &quot; module)\n&quot;);
    ELSIF Text.Equal (arg, &quot;?&quot;) THEN
      SynWr.Text (SynWr.out, Bundle.Get(ObLib3DBundle.Get(), m3name &amp; &quot;.hlp&quot;));
      SynWr.NewLine (SynWr.out);
    ELSE
      SynWr.Text(SynWr.out, &quot;Command &quot; &amp; self.name &amp; &quot;: bad argument: &quot; &amp; arg);
      SynWr.NewLine (SynWr.out);
    END;
  END Help;

BEGIN
  mu := NEW (MUTEX);
  wr := TextWr.New ();
  swr := SynWr.New (wr);
END ObAux.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
