<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObBoxGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObBoxGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 19 14:00:00 PST 1994 by najork                   

<P><PRE>MODULE <module><implements><A HREF="ObBoxGO.i3">ObBoxGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/BoxGO.i3">BoxGO</A>, <A HREF="../../anim3D/src/BoxGOProxy.i3">BoxGOProxy</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObPointProp.i3">ObPointProp</A>, <A HREF="ObProp.i3">ObProp</A>,
       <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObSurfaceGO.i3">ObSurfaceGO</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;BoxGO&quot;;
</PRE>***************************************************************************
 Wrapper for BoxGO.T                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObSurfaceGO.T BRANDED &quot;ObBoxGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (box : BoxGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a BoxGO.T&gt;&quot;, po := box) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      box.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,        2, Code.New),
            NewOpCode (&quot;Corner1&quot;,   -1, Code.Corner1),
            NewOpCode (&quot;Corner2&quot;,   -1, Code.Corner2),
            NewOpCode (&quot;SetCorner1&quot;, 2, Code.SetCorner1),
            NewOpCode (&quot;SetCorner2&quot;, 2, Code.SetCorner2)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);

    (* DONT KNOW YET WHETHER TO INHIBIT TRANSMISSIONS ... *)

  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;BoxGO.obl&quot;);
    TProto := loader.get (&quot;BoxGO_TProto&quot;);

    (*** Register the proxy maker ***)
    BoxGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New, Corner1, Corner2, SetCorner1, SetCorner2};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH a   = ObPointProp.GetOverloadedVal (args, 1, self, opCode, loc),
           b   = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc),
           box = NEW (BoxGO.T).init () DO
        box.setProp (BoxGO.Corner1.bind (a));
        box.setProp (BoxGO.Corner2.bind (b));
        RETURN box.proxy.obj;
      END;
    | Code.Corner1 =&gt;
      RETURN ObProp.NameToObliq (BoxGO.Corner1);
    | Code.Corner2 =&gt;
      RETURN ObProp.NameToObliq (BoxGO.Corner2);
    | Code.SetCorner1 =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p  = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (BoxGO.Corner1.bind (p));
        RETURN ObValue.valOk;
      END;
    | Code.SetCorner2 =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p  = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (BoxGO.Corner2.bind (p));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObBoxGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
