<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObCameraGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObCameraGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sat Mar  5 20:17:15 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObCameraGO.i3">ObCameraGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/CameraGO.i3">CameraGO</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObPointProp.i3">ObPointProp</A>, <A HREF="ObProp.i3">ObProp</A>,
       <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObRealProp.i3">ObRealProp</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;CameraGO&quot;;
</PRE>***************************************************************************
 Wrapper for CameraGO.T                                                    
***************************************************************************

<P>
<P><PRE>REVEAL
  <A NAME="T">T</A> = ObGO.T BRANDED &quot;ObCameraGO.T&quot; OBJECT END;

PROCEDURE <A NAME="GetArg"><procedure>GetArg</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : CameraGO.T
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | T (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetArg;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;From&quot;,     -1, Code.From),
            NewOpCode (&quot;To&quot;,       -1, Code.To),
            NewOpCode (&quot;Up&quot;,       -1, Code.Up),
            NewOpCode (&quot;Aspect&quot;,   -1, Code.Aspect),
            NewOpCode (&quot;SetFrom&quot;,   2, Code.SetFrom),
            NewOpCode (&quot;SetTo&quot;,     2, Code.SetTo),
            NewOpCode (&quot;SetUp&quot;,     2, Code.SetUp),
            NewOpCode (&quot;SetAspect&quot;, 2, Code.SetAspect)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    loader.load (&quot;CameraGO.obl&quot;);
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {From, To, Up, Aspect, SetFrom, SetTo, SetUp, SetAspect};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (             self         : Package;
                               opCode       : ObLib.OpCode;
                  &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                               READONLY args: ObValue.ArgArray;
                  &lt;* UNUSED *&gt; tmp          : BOOLEAN;
                               loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.From   =&gt; RETURN ObProp.NameToObliq (CameraGO.From);
    | Code.To     =&gt; RETURN ObProp.NameToObliq (CameraGO.To);
    | Code.Up     =&gt; RETURN ObProp.NameToObliq (CameraGO.Up);
    | Code.Aspect =&gt; RETURN ObProp.NameToObliq (CameraGO.Aspect);
    | Code.SetFrom =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           p  = ObPointProp.GetOverloadedVal(args, 2, self, opCode, loc) DO
        go.setProp (CameraGO.From.bind (p));
        RETURN ObValue.valOk;
      END;
    | Code.SetTo =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           p  = ObPointProp.GetOverloadedVal(args, 2, self, opCode, loc) DO
        go.setProp (CameraGO.To.bind (p));
        RETURN ObValue.valOk;
      END;
    | Code.SetUp =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           p  = ObPointProp.GetOverloadedVal(args, 2, self, opCode, loc) DO
        go.setProp (CameraGO.Up.bind (p));
        RETURN ObValue.valOk;
      END;
    | Code.SetAspect =&gt;
      WITH go = ObGO.GetArg                (args, 1, self, opCode, loc),
           r  = ObRealProp.GetOverloadedVal(args, 2, self, opCode, loc) DO
        go.setProp (CameraGO.Aspect.bind (r));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObCameraGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
