<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObColor.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObColor.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 20 14:00:00 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObColor.i3">ObColor</A></implements></module>;

IMPORT <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="../../color/src/ColorName.i3">ColorName</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

PROCEDURE <A NAME="M3ToObliq"><procedure>M3ToObliq</procedure></A> (val : Color.T) : T =
  BEGIN
    RETURN NEW (T, what := &quot;&lt;a Color.T&gt;&quot;, color := val);
  END M3ToObliq;

PROCEDURE <A NAME="ObliqToM3"><procedure>ObliqToM3</procedure></A> (val : T) : Color.T =
  BEGIN
    RETURN val.color;
  END ObliqToM3;

PROCEDURE <A NAME="GetArg"><procedure>GetArg</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : Color.T RAISES {ObValue.Error} =
  BEGIN
    TYPECASE args[idx] OF
    | ObValue.ValText (node) =&gt;
      TRY
        RETURN ColorName.ToRGB(node.text);
      EXCEPT
        ColorName.NotFound =&gt; RETURN Color.Black;
      END;
    | T (node) =&gt;
      RETURN node.color;
    ELSE
      ObValue.BadArgType (idx, &quot;color&quot;, package.name, opCode.name, loc);
      RETURN Color.Black;   (* ... only to suppress compiler warning *)
    END;
  END GetArg;

BEGIN
END ObColor.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
