<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObConeGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObConeGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 19 14:00:00 PST 1994 by najork                   

<P><PRE>MODULE <module><implements><A HREF="ObConeGO.i3">ObConeGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/ConeGO.i3">ConeGO</A>, <A HREF="../../anim3D/src/ConeGOProxy.i3">ConeGOProxy</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="ObInt.i3">ObInt</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObPointProp.i3">ObPointProp</A>,
       <A HREF="ObProp.i3">ObProp</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObRealProp.i3">ObRealProp</A>, <A HREF="ObSurfaceGO.i3">ObSurfaceGO</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>,
       <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;ConeGO&quot;;
</PRE>***************************************************************************
 Wrapper for ConeGO.T                                                      
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObSurfaceGO.T BRANDED &quot;ObConeGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (cone : ConeGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a ConeGO.T&gt;&quot;, po := cone) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      cone.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,         3, Code.New),
            NewOpCode (&quot;NewWithPrec&quot;, 4, Code.NewWithPrec),
            NewOpCode (&quot;Base&quot;,       -1, Code.Base),
            NewOpCode (&quot;Tip&quot;,        -1, Code.Tip),
            NewOpCode (&quot;Radius&quot;,     -1, Code.Radius),
            NewOpCode (&quot;SetBase&quot;,     2, Code.SetBase),
            NewOpCode (&quot;SetTip&quot;,      2, Code.SetTip),
            NewOpCode (&quot;SetRadius&quot;,   2, Code.SetRadius)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);

    (* DONT KNOW YET WHETHER TO INHIBIT TRANSMISSIONS ... *)

  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;ConeGO.obl&quot;);
    TProto := loader.get (&quot;ConeGO_TProto&quot;);

    (*** Register the proxy maker ***)
    ConeGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New, NewWithPrec, Base, SetBase, Tip, SetTip, Radius,
          SetRadius};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH base = ObPointProp.GetOverloadedVal (args, 1, self, opCode, loc),
           tip  = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc),
           rad  = ObRealProp.GetOverloadedVal  (args, 3, self, opCode, loc),
           cone = NEW (ConeGO.T).init () DO
        cone.setProp (ConeGO.Base.bind (base));
        cone.setProp (ConeGO.Tip.bind (tip));
        cone.setProp (ConeGO.Radius.bind (rad));
        RETURN cone.proxy.obj;
      END;
    | Code.NewWithPrec =&gt;
      WITH base = ObPointProp.GetOverloadedVal (args, 1, self, opCode, loc),
           tip  = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc),
           rad  = ObRealProp.GetOverloadedVal  (args, 3, self, opCode, loc),
           prec = ObInt.GetArg                 (args, 4, self, opCode, loc),
           cone = NEW (ConeGO.T).init (prec) DO
        cone.setProp (ConeGO.Base.bind (base));
        cone.setProp (ConeGO.Tip.bind (tip));
        cone.setProp (ConeGO.Radius.bind (rad));
        RETURN cone.proxy.obj;
      END;
    | Code.Base =&gt;
      RETURN ObProp.NameToObliq (ConeGO.Base);
    | Code.Tip =&gt;
      RETURN ObProp.NameToObliq (ConeGO.Tip);
    | Code.Radius =&gt;
      RETURN ObProp.NameToObliq (ConeGO.Radius);
    | Code.SetBase =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p1 = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (ConeGO.Base.bind (p1));
        RETURN ObValue.valOk;
      END;
    | Code.SetTip =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p2 = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (ConeGO.Tip.bind (p2));
        RETURN ObValue.valOk;
      END;
    | Code.SetRadius =&gt;
      WITH go  = ObGO.GetArg                 (args, 1, self, opCode, loc),
           rad = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (ConeGO.Radius.bind (rad));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObConeGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
