<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObCylinderGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObCylinderGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 19 14:00:00 PST 1994 by najork                   

<P><PRE>MODULE <module><implements><A HREF="ObCylinderGO.i3">ObCylinderGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/CylinderGO.i3">CylinderGO</A>, <A HREF="../../anim3D/src/CylinderGOProxy.i3">CylinderGOProxy</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="ObInt.i3">ObInt</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>,
       <A HREF="ObPointProp.i3">ObPointProp</A>, <A HREF="ObProp.i3">ObProp</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObRealProp.i3">ObRealProp</A>, <A HREF="ObSurfaceGO.i3">ObSurfaceGO</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>,
       <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;CylinderGO&quot;;
</PRE>***************************************************************************
 Wrapper for CylinderGO.T                                                  
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObSurfaceGO.T BRANDED &quot;ObCylinderGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (cyl : CylinderGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a CylinderGO.T&gt;&quot;, po := cyl) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      cyl.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,         3, Code.New),
            NewOpCode (&quot;NewWithPrec&quot;, 4, Code.NewWithPrec),
            NewOpCode (&quot;Point1&quot;,     -1, Code.Point1),
            NewOpCode (&quot;Point2&quot;,     -1, Code.Point2),
            NewOpCode (&quot;Radius&quot;,     -1, Code.Radius),
            NewOpCode (&quot;SetPoint1&quot;,   2, Code.SetPoint1),
            NewOpCode (&quot;SetPoint2&quot;,   2, Code.SetPoint2),
            NewOpCode (&quot;SetRadius&quot;,   2, Code.SetRadius)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);

    (* DONT KNOW YET WHETHER TO INHIBIT TRANSMISSIONS ... *)

  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;CylinderGO.obl&quot;);
    TProto := loader.get (&quot;CylinderGO_TProto&quot;);

    (*** Register the proxy maker ***)
    CylinderGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New, NewWithPrec,
          Point1, SetPoint1, Point2, SetPoint2, Radius, SetRadius};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH p1   = ObPointProp.GetOverloadedVal (args, 1, self, opCode, loc),
           p2   = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc),
           rad  =  ObRealProp.GetOverloadedVal (args, 3, self, opCode, loc),
           cyl  = NEW (CylinderGO.T).init () DO
        cyl.setProp (CylinderGO.Point1.bind (p1));
        cyl.setProp (CylinderGO.Point2.bind (p2));
        cyl.setProp (CylinderGO.Radius.bind (rad));
        RETURN cyl.proxy.obj;
      END;
    | Code.NewWithPrec =&gt;
      WITH p1   = ObPointProp.GetOverloadedVal (args, 1, self, opCode, loc),
           p2   = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc),
           rad  = ObRealProp.GetOverloadedVal  (args, 3, self, opCode, loc),
           prec = ObInt.GetArg                 (args, 4, self, opCode, loc),
           cyl  = NEW (CylinderGO.T).init (prec) DO
        cyl.setProp (CylinderGO.Point1.bind (p1));
        cyl.setProp (CylinderGO.Point2.bind (p2));
        cyl.setProp (CylinderGO.Radius.bind (rad));
        RETURN cyl.proxy.obj;
      END;
    | Code.Point1 =&gt;
      RETURN ObProp.NameToObliq (CylinderGO.Point1);
    | Code.Point2 =&gt;
      RETURN ObProp.NameToObliq (CylinderGO.Point2);
    | Code.Radius =&gt;
      RETURN ObProp.NameToObliq (CylinderGO.Radius);
    | Code.SetPoint1 =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p1 = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (CylinderGO.Point1.bind (p1));
        RETURN ObValue.valOk;
      END;
    | Code.SetPoint2 =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p2 = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (CylinderGO.Point2.bind (p2));
        RETURN ObValue.valOk;
      END;
    | Code.SetRadius =&gt;
      WITH go  = ObGO.GetArg                 (args, 1, self, opCode, loc),
           rad = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (CylinderGO.Radius.bind (rad));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObCylinderGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
