<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObDiskGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObDiskGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 19 14:00:00 PST 1994 by najork                   

<P><PRE>MODULE <module><implements><A HREF="ObDiskGO.i3">ObDiskGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/DiskGO.i3">DiskGO</A>, <A HREF="../../anim3D/src/DiskGOProxy.i3">DiskGOProxy</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="ObInt.i3">ObInt</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObPointProp.i3">ObPointProp</A>,
       <A HREF="ObProp.i3">ObProp</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObRealProp.i3">ObRealProp</A>, <A HREF="ObSurfaceGO.i3">ObSurfaceGO</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>,
       <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST pkgname = &quot;DiskGO&quot;;
</PRE>***************************************************************************
 Wrapper for DiskGO.T                                                      
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObSurfaceGO.T BRANDED &quot;ObDiskGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (disk : DiskGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a DiskGO.T&gt;&quot;, po := disk) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      disk.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,         3, Code.New),
            NewOpCode (&quot;NewWithPrec&quot;, 4, Code.NewWithPrec),
            NewOpCode (&quot;Center&quot;,     -1, Code.Center),
            NewOpCode (&quot;Normal&quot;,     -1, Code.Normal),
            NewOpCode (&quot;Radius&quot;,     -1, Code.Radius),
            NewOpCode (&quot;SetCenter&quot;,   2, Code.SetCenter),
            NewOpCode (&quot;SetNormal&quot;,   2, Code.SetNormal),
            NewOpCode (&quot;SetRadius&quot;,   2, Code.SetRadius)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);

    (* DONT KNOW YET WHETHER TO INHIBIT TRANSMISSIONS ... *)

  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;DiskGO.obl&quot;);
    TProto := loader.get (&quot;DiskGO_TProto&quot;);

    (*** Register the proxy maker ***)
    DiskGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New, NewWithPrec,
          Center, SetCenter, Normal, SetNormal, Radius, SetRadius};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH c    = ObPointProp.GetOverloadedVal (args, 1, self, opCode, loc),
           n    = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc),
           r    = ObRealProp.GetOverloadedVal  (args, 3, self, opCode, loc),
           disk = NEW (DiskGO.T).init () DO
        disk.setProp (DiskGO.Center.bind (c));
        disk.setProp (DiskGO.Normal.bind (n));
        disk.setProp (DiskGO.Radius.bind (r));
        RETURN disk.proxy.obj;
      END;
    | Code.NewWithPrec =&gt;
      WITH c    = ObPointProp.GetOverloadedVal (args, 1, self, opCode, loc),
           n    = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc),
           r    = ObRealProp.GetOverloadedVal  (args, 3, self, opCode, loc),
           prec = ObInt.GetArg                 (args, 4, self, opCode, loc),
           disk = NEW (DiskGO.T).init (prec) DO
        disk.setProp (DiskGO.Center.bind (c));
        disk.setProp (DiskGO.Normal.bind (n));
        disk.setProp (DiskGO.Radius.bind (r));
        RETURN disk.proxy.obj;
      END;
    | Code.Center =&gt;
      RETURN ObProp.NameToObliq (DiskGO.Center);
    | Code.Normal =&gt;
      RETURN ObProp.NameToObliq (DiskGO.Normal);
    | Code.Radius =&gt;
      RETURN ObProp.NameToObliq (DiskGO.Radius);
    | Code.SetCenter =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p  = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (DiskGO.Center.bind (p));
        RETURN ObValue.valOk;
      END;
    | Code.SetNormal =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p  = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (DiskGO.Normal.bind (p));
        RETURN ObValue.valOk;
      END;
    | Code.SetRadius =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           r  = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (DiskGO.Radius.bind (r));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObDiskGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
