<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 19 14:00:00 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObGO.i3">ObGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/GO.i3">GO</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObKeyCB.i3">ObKeyCB</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObMouseCB.i3">ObMouseCB</A>, <A HREF="ObPositionCB.i3">ObPositionCB</A>, <A HREF="ObProp.i3">ObProp</A>,
       <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObProxiedObj.i3">ObProxiedObj</A>, <A HREF="ObText.i3">ObText</A>, <A HREF="ObTransformProp.i3">ObTransformProp</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>,
       <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;GO&quot;;
</PRE>***************************************************************************
 Wrapper for GO.T                                                          
***************************************************************************

<P><PRE>REVEAL
  <A NAME="T">T</A> = ObProxiedObj.T BRANDED &quot;ObGO.T&quot; OBJECT END;

PROCEDURE <A NAME="GetArg"><procedure>GetArg</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : GO.T
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | T (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetArg;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name : TEXT; arity : INTEGER; code : Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;PropUndefined&quot;,   -1, Code.PropUndefined),
            NewOpCode (&quot;StackError&quot;,      -1, Code.StackError),
            NewOpCode (&quot;SetProp&quot;,          2, Code.SetProp),
            NewOpCode (&quot;UnsetProp&quot;,        2, Code.UnsetProp),
            NewOpCode (&quot;GetProp&quot;,          2, Code.GetProp),
            NewOpCode (&quot;SetName&quot;,          2, Code.SetName),
            NewOpCode (&quot;GetName&quot;,          1, Code.GetName),
            NewOpCode (&quot;FindName&quot;,         2, Code.FindName),
            NewOpCode (&quot;Transform&quot;,       -1, Code.Transform),
            NewOpCode (&quot;SetTransform&quot;,     2, Code.SetTransform),
            NewOpCode (&quot;GetTransform&quot;,     1, Code.GetTransform),
            NewOpCode (&quot;PushMouseCB&quot;,      2, Code.PushMouseCB),
            NewOpCode (&quot;PopMouseCB&quot;,       1, Code.PopMouseCB),
            NewOpCode (&quot;RemoveMouseCB&quot;,    2, Code.RemoveMouseCB),
            NewOpCode (&quot;InvokeMouseCB&quot;,    2, Code.InvokeMouseCB),
            NewOpCode (&quot;PushPositionCB&quot;,   2, Code.PushPositionCB),
            NewOpCode (&quot;PopPositionCB&quot;,    1, Code.PopPositionCB),
            NewOpCode (&quot;RemovePositionCB&quot;, 2, Code.RemovePositionCB),
            NewOpCode (&quot;InvokePositionCB&quot;, 2, Code.InvokePositionCB),
            NewOpCode (&quot;PushKeyCB&quot;,        2, Code.PushKeyCB),
            NewOpCode (&quot;PopKeyCB&quot;,         1, Code.PopKeyCB),
            NewOpCode (&quot;RemoveKeyCB&quot;,      2, Code.RemoveKeyCB),
            NewOpCode (&quot;InvokeKeyCB&quot;,      2, Code.InvokeKeyCB)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);

    PropUndefined :=
        NEW (ObValue.ValException, name := pkgname &amp; &quot;_PropUndefined&quot;);
    StackError :=
        NEW (ObValue.ValException, name := pkgname &amp; &quot;_StackError&quot;);
  END SetupPackage;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    loader.load (&quot;GO.obl&quot;);
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {PropUndefined, StackError, SetProp, UnsetProp, GetProp,
          SetName, GetName, FindName,
          Transform, SetTransform, GetTransform,
          PushMouseCB, PopMouseCB, RemoveMouseCB, InvokeMouseCB,
          PushPositionCB, PopPositionCB, RemovePositionCB, InvokePositionCB,
          PushKeyCB, PopKeyCB, RemoveKeyCB, InvokeKeyCB};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.PropUndefined =&gt;
      RETURN PropUndefined;
    | Code.StackError =&gt;
      RETURN StackError;
    | Code.SetProp =&gt;
      WITH go   = GetArg      (args, 1, self, opCode, loc),
           prop = ObProp.GetT (args, 2, self, opCode, loc) DO
        go.setProp (prop);
        RETURN ObValue.valOk;
      END;
    | Code.UnsetProp =&gt;
      WITH go = GetArg         (args, 1, self, opCode, loc),
           pn = ObProp.GetName (args, 2, self, opCode, loc) DO
        TRY
          go.unsetProp (pn);
        EXCEPT
          GO.PropUndefined =&gt;
          ObValue.RaiseException (PropUndefined, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.GetProp =&gt;
      WITH go = GetArg         (args, 1, self, opCode, loc),
           pn = ObProp.GetName (args, 2, self, opCode, loc) DO
        TRY
          RETURN go.getProp (pn).proxy.obj;
        EXCEPT
          GO.PropUndefined =&gt;
          ObValue.RaiseException (PropUndefined, opCode.name, loc);
          RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
        END;
      END;
    | Code.SetName =&gt;
      WITH go   = GetArg        (args, 1, self, opCode, loc),
           name = ObText.GetArg (args, 2, self, opCode, loc) DO
        go.setName (name);
        RETURN ObValue.valOk;
      END;
    | Code.GetName =&gt;
      WITH go = GetArg (args, 1, self, opCode, loc),
           name = go.getName () DO
        IF name = NIL THEN
          RETURN ObValue.valOk;
        ELSE
          RETURN Obliq.NewText (name);
        END;
      END;
    | Code.FindName =&gt;
      WITH go   = GetArg        (args, 1, self, opCode, loc),
           name = ObText.GetArg (args, 2, self, opCode, loc),
           res  = go.findName (name) DO
        IF res = NIL THEN
          RETURN ObValue.valOk;
        ELSE
          RETURN res.proxy.obj;
        END;
      END;
    | Code.Transform =&gt;
      RETURN ObProp.NameToObliq (GO.Transform);
    | Code.SetTransform =&gt;
      WITH go = GetArg (args, 1, self, opCode, loc),
           pv = ObTransformProp.GetOverloadedVal
           (args, 2, self, opCode, loc) DO
        go.setProp (GO.Transform.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.GetTransform =&gt;
      WITH go = GetArg (args, 1, self, opCode, loc) DO
        TRY
          RETURN GO.GetTransform (go).proxy.obj;
        EXCEPT
        | GO.PropUndefined =&gt;
          ObValue.RaiseException (PropUndefined, opCode.name, loc);
          RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
        END;
      END;
    | Code.PushMouseCB =&gt;
      WITH go = GetArg         (args, 1, self, opCode, loc),
           cb = ObMouseCB.GetT (args, 2, self, opCode, loc) DO
        go.pushMouseCB (cb);
        RETURN ObValue.valOk;
      END;
    | Code.PopMouseCB =&gt;
      TRY
        WITH go = GetArg (args, 1, self, opCode, loc) DO
          go.popMouseCB ();
        END;
      EXCEPT
      | GO.StackError =&gt; Obliq.RaiseException (StackError, opCode.name, loc);
      END;
      RETURN ObValue.valOk;
    | Code.RemoveMouseCB =&gt;
      TRY
        WITH go = GetArg         (args, 1, self, opCode, loc),
             cb = ObMouseCB.GetT (args, 2, self, opCode, loc) DO
          go.removeMouseCB (cb);
        END;
      EXCEPT
      | GO.StackError =&gt; Obliq.RaiseException (StackError, opCode.name, loc);
      END;
      RETURN ObValue.valOk;
    | Code.InvokeMouseCB =&gt;
      WITH go = GetArg           (args, 1, self, opCode, loc),
           mr = ObMouseCB.GetRec (args, 2, self, opCode, loc) DO
        go.invokeMouseCB (mr);
        RETURN ObValue.valOk;
      END;
    | Code.PushPositionCB =&gt;
      WITH go = GetArg            (args, 1, self, opCode, loc),
           cb = ObPositionCB.GetT (args, 2, self, opCode, loc) DO
        go.pushPositionCB (cb);
        RETURN ObValue.valOk;
      END;
    | Code.PopPositionCB =&gt;
      TRY
        WITH go = GetArg (args, 1, self, opCode, loc) DO
          go.popPositionCB ();
        END;
      EXCEPT
      | GO.StackError =&gt; Obliq.RaiseException (StackError, opCode.name, loc);
      END;
      RETURN ObValue.valOk;
    | Code.RemovePositionCB =&gt;
      TRY
        WITH go = GetArg            (args, 1, self, opCode, loc),
             cb = ObPositionCB.GetT (args, 2, self, opCode, loc) DO
          go.removePositionCB (cb);
        END;
      EXCEPT
      | GO.StackError =&gt; Obliq.RaiseException (StackError, opCode.name, loc);
      END;
      RETURN ObValue.valOk;
    | Code.InvokePositionCB =&gt;
      WITH go = GetArg              (args, 1, self, opCode, loc),
           pr = ObPositionCB.GetRec (args, 2, self, opCode, loc) DO
        go.invokePositionCB (pr);
        RETURN ObValue.valOk;
      END;
    | Code.PushKeyCB =&gt;
      WITH go = GetArg       (args, 1, self, opCode, loc),
           cb = ObKeyCB.GetT (args, 2, self, opCode, loc) DO
        go.pushKeyCB (cb);
        RETURN ObValue.valOk;
      END;
    | Code.PopKeyCB =&gt;
      TRY
        WITH go = GetArg (args, 1, self, opCode, loc) DO
          go.popKeyCB ();
        END;
      EXCEPT
      | GO.StackError =&gt; Obliq.RaiseException (StackError, opCode.name, loc);
      END;
      RETURN ObValue.valOk;
    | Code.RemoveKeyCB =&gt;
      TRY
        WITH go = GetArg       (args, 1, self, opCode, loc),
             cb = ObKeyCB.GetT (args, 2, self, opCode, loc) DO
          go.removeKeyCB (cb);
        END;
      EXCEPT
      | GO.StackError =&gt; Obliq.RaiseException (StackError, opCode.name, loc);
      END;
      RETURN ObValue.valOk;
    | Code.InvokeKeyCB =&gt;
      WITH go = GetArg         (args, 1, self, opCode, loc),
           kr = ObKeyCB.GetRec (args, 2, self, opCode, loc) DO
        go.invokeKeyCB (kr);
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
