<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObGroupGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObGroupGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 19 14:00:00 PST 1994 by najork                   

<P><PRE>MODULE <module><implements><A HREF="ObGroupGO.i3">ObGroupGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/GroupGO.i3">GroupGO</A>, <A HREF="../../anim3D/src/GroupGOProxy.i3">GroupGOProxy</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="ObInt.i3">ObInt</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>,
       <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;GroupGO&quot;;
</PRE>***************************************************************************
 Wrapper for GroupGO.T                                                     
***************************************************************************

<P>
<P><PRE>REVEAL
  <A NAME="T">T</A> = ObGO.T BRANDED &quot;ObGroupGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (group : GroupGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a GroupGO.T&gt;&quot;, po := group) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      group.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;

PROCEDURE <A NAME="GetArg"><procedure>GetArg</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : GroupGO.T
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | T (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetArg;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name : TEXT; arity : INTEGER; code : Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;BadElement&quot;,     -1, Code.BadElement),
            NewOpCode (&quot;New&quot;,             0, Code.New),
            NewOpCode (&quot;NewWithSizeHint&quot;, 1, Code.NewWithSizeHint),
            NewOpCode (&quot;Add&quot;,             2, Code.Add),
            NewOpCode (&quot;Remove&quot;,          2, Code.Remove),
            NewOpCode (&quot;Flush&quot;,           1, Code.Flush),
            NewOpCode (&quot;Content&quot;,         1, Code.Content)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);

    BadElement := NEW (ObValue.ValException, name := pkgname &amp; &quot;_BadElement&quot;);
  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;GroupGO.obl&quot;);
    TProto := loader.get (&quot;GroupGO_TProto&quot;);

    (*** Register the proxy maker ***)
    GroupGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {BadElement, New, NewWithSizeHint, Add, Remove, Flush, Content};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

VAR
  BadElement : ObValue.ValException;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.BadElement =&gt;
      RETURN BadElement;
    | Code.New =&gt;
      WITH group = NEW (GroupGO.T).init () DO
        RETURN group.proxy.obj;
      END;
    | Code.NewWithSizeHint =&gt;
      WITH size  = ObInt.GetArg (args, 1, self, opCode, loc),
           group = NEW (GroupGO.T).init (size) DO
        RETURN group.proxy.obj;
      END;
    | Code.Add =&gt;
      WITH group =      GetArg (args, 1, self, opCode, loc),
           go    = ObGO.GetArg (args, 2, self, opCode, loc) DO
        group.add (go);
        RETURN ObValue.valOk;
      END;
    | Code.Remove =&gt;
      WITH group = GetArg (args, 1, self, opCode, loc),
           go    = ObGO.GetArg (args, 2, self, opCode, loc) DO
        TRY
          group.remove (go);
        EXCEPT
        | GroupGO.BadElement =&gt;
          ObValue.RaiseException (BadElement, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.Flush =&gt;
      WITH group = GetArg (args, 1, self, opCode, loc) DO
        group.flush ();
        RETURN ObValue.valOk;
      END;
    | Code.Content =&gt;
      WITH group = GetArg (args, 1, self, opCode, loc) DO
        WITH cont = group.content()^,
             vals = NEW (REF ARRAY OF Obliq.Val, NUMBER (cont)) DO
          FOR i := FIRST (cont) TO LAST (cont) DO
            vals[i] := cont[i].proxy.obj;
          END;
          RETURN Obliq.NewArray (vals^);
        END;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObGroupGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
