<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObKeyCB.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObKeyCB.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Fri Jul 22 19:52:26 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObKeyCB.i3">ObKeyCB</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/CB.i3">CB</A>, <A HREF="../../anim3D/src/KeyCB.i3">KeyCB</A>, <A HREF="../../anim3D/src/KeyCBProxy.i3">KeyCBProxy</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="ObCB.i3">ObCB</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObKeySym.i3">ObKeySym</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>,
       <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObProxiedObj.i3">ObProxiedObj</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

CONST
  pkgname = &quot;KeyCB&quot;;
</PRE>***************************************************************************
 Wrapper for KeyCB.T                                                       
***************************************************************************

<P><PRE>TYPE
  T = ObProxiedObj.T BRANDED OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (cb : KeyCB.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a KeyCB.T&gt;&quot;, po := cb) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      cb.proxy := NEW (Proxy, obj := obj);
    END;
  END AddTObj;

PROCEDURE <A NAME="GetT"><procedure>GetT</procedure></A> (args    : ObValue.ArgArray;
                idx     : INTEGER;
                package : ObLib.T;
                opCode  : ObLib.OpCode;
                loc     : SynLocation.T) : KeyCB.T
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | T (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetT;

TYPE
  Proxy = KeyCBProxy.Proxy BRANDED OBJECT
  OVERRIDES
    invoke := Invoke;
  END;

PROCEDURE <A NAME="Invoke"><procedure>Invoke</procedure></A> (proxy : Proxy; mr : KeyCB.Rec) RAISES {CB.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {RecToObliq (mr)},
           obj  = NARROW (proxy.obj, Obliq.Val) DO
        EVAL Obliq.ObjectInvoke (obj, &quot;invoke&quot;, args);
      END;
    EXCEPT
    | ObValue.Error (packet) =&gt;
      RAISE CB.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE CB.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END Invoke;
</PRE>***************************************************************************
 Wrapper for KeyCB.Rec                                                     
***************************************************************************

<P>
<P><PRE>EXCEPTION FatalError;  &lt;* FATAL FatalError *&gt;

PROCEDURE <A NAME="GetRec"><procedure>GetRec</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : KeyCB.Rec
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    TRY
      WITH obj    = args[idx],
           change = ObliqToKeySym    (Obliq.ObjectSelect (obj, &quot;change&quot;)),
           down   = Obliq.ToBool     (Obliq.ObjectSelect (obj, &quot;wentDown&quot;)),
           mods   = ObliqToModifiers (Obliq.ObjectSelect (obj, &quot;modifiers&quot;)) DO
        RETURN KeyCB.Rec {change, down, mods}
      END;
    EXCEPT
    | ObValue.Error, ObValue.Exception =&gt;
      ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
      RETURN KeyCB.Rec {VBT.NoKey, FALSE, VBT.Modifiers {}};
          (* ... only to suppress compiler warning *)
    END;
  END GetRec;

PROCEDURE <A NAME="RecToObliq"><procedure>RecToObliq</procedure></A> (mr : KeyCB.Rec) : Obliq.Val =
  TYPE
    Field = RECORD label : TEXT; field : Obliq.Val END;
  BEGIN
    RETURN Obliq.NewObject (Obliq.Fields {
                    Field {&quot;change&quot;,    KeySymToObliq (mr.whatChanged)},
                    Field {&quot;wentDown&quot;,  Obliq.NewBool (mr.wentDown)},
                    Field {&quot;modifiers&quot;, ModifiersToObliq (mr.modifiers)}});
  END RecToObliq;

PROCEDURE <A NAME="KeySymToObliq"><procedure>KeySymToObliq</procedure></A> (k : VBT.KeySym) : Obliq.Val =
  BEGIN
    RETURN ObKeySym.M3ToObliq (k);
  END KeySymToObliq;

PROCEDURE <A NAME="ObliqToKeySym"><procedure>ObliqToKeySym</procedure></A> (val : Obliq.Val) : VBT.KeySym RAISES {ObValue.Error} =
  BEGIN
    RETURN ObKeySym.ObliqToM3 (val);
  END ObliqToKeySym;

PROCEDURE <A NAME="ModifierToObliq"><procedure>ModifierToObliq</procedure></A> (m : VBT.Modifier) : Obliq.Val =
  BEGIN
    CASE m OF
    | VBT.Modifier.Shift   =&gt; RETURN Obliq.NewText (&quot;Shift&quot;);
    | VBT.Modifier.Lock    =&gt; RETURN Obliq.NewText (&quot;Lock&quot;);
    | VBT.Modifier.Control =&gt; RETURN Obliq.NewText (&quot;Control&quot;);
    | VBT.Modifier.Option  =&gt; RETURN Obliq.NewText (&quot;Option&quot;);
    | VBT.Modifier.MouseL  =&gt; RETURN Obliq.NewText (&quot;Left&quot;);
    | VBT.Modifier.MouseM  =&gt; RETURN Obliq.NewText (&quot;Middle&quot;);
    | VBT.Modifier.MouseR  =&gt; RETURN Obliq.NewText (&quot;Right&quot;);
    ELSE
      RAISE FatalError;
    END;
  END ModifierToObliq;

PROCEDURE <A NAME="ObliqToModifier"><procedure>ObliqToModifier</procedure></A> (val : Obliq.Val) : VBT.Modifier
    RAISES {ObValue.Error} =
  BEGIN
    WITH t = Obliq.ToText (val) DO
      IF Text.Equal (t, &quot;Shift&quot;) THEN
        RETURN VBT.Modifier.Shift;
      ELSIF Text.Equal (t, &quot;Lock&quot;) THEN
        RETURN VBT.Modifier.Lock;
      ELSIF Text.Equal (t, &quot;Control&quot;) THEN
        RETURN VBT.Modifier.Control;
      ELSIF Text.Equal (t, &quot;Option&quot;) THEN
        RETURN VBT.Modifier.Option;
      ELSIF Text.Equal (t, &quot;Left&quot;) THEN
        RETURN VBT.Modifier.MouseL;
      ELSIF Text.Equal (t, &quot;Middle&quot;) THEN
        RETURN VBT.Modifier.MouseM;
      ELSIF Text.Equal (t, &quot;Right&quot;) THEN
        RETURN VBT.Modifier.MouseR;
      ELSE
        Obliq.RaiseError (&quot;Not a valid Modifier&quot;);
        RETURN VBT.Modifier.MouseL; (* ... only to suppress compiler warning *)
      END;
    END;
  END ObliqToModifier;

PROCEDURE <A NAME="ModifiersToObliq"><procedure>ModifiersToObliq</procedure></A> (modifiers : VBT.Modifiers) : Obliq.Val =
  VAR
    mods : ARRAY [0 .. ORD (LAST (VBT.Modifier))] OF Obliq.Val;
    size := 0;
  BEGIN
    FOR m := FIRST (VBT.Modifier) TO LAST (VBT.Modifier) DO
      IF m IN modifiers THEN
        mods[size] := ModifierToObliq (m);
        INC (size);
      END;
    END;
    RETURN Obliq.NewArray (SUBARRAY (mods, 0, size));
  END ModifiersToObliq;

PROCEDURE <A NAME="ObliqToModifiers"><procedure>ObliqToModifiers</procedure></A> (val : Obliq.Val) : VBT.Modifiers
    RAISES {ObValue.Error} =
  VAR
    mods := VBT.Modifiers {};
  BEGIN
    FOR i := 0 TO Obliq.ArraySize (val) - 1 DO
      mods := mods + VBT.Modifiers {ObliqToModifier (Obliq.ArrayGet (val, i))};
    END;
    RETURN mods;
  END ObliqToModifiers;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes := NEW (REF OpCodes, NUMBER (Code));
  BEGIN
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,      1, Code.New),
            NewOpCode (&quot;Invoke&quot;,   2, Code.Invoke)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  TProto  : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** retrieve the prototype ***)
    loader.load (&quot;KeyCB.obl&quot;);
    TProto   := loader.get (&quot;KeyCB_TProto&quot;);

    (*** Register the proxy makers ***)
    KeyCBProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New, Invoke};

  OpCode = ObLib.OpCode BRANDED OBJECT
    code: Code;
  END;

  Package = ObLib.T BRANDED OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH cb  = NEW (KeyCB.T).init (),
           obj = NARROW (cb.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;invoke&quot;, args[1]);
        RETURN obj;
      END;
    | Code.Invoke =&gt;
      TRY
        WITH cb = GetT   (args, 1, self, opCode, loc),
             kr = GetRec (args, 2, self, opCode, loc) DO
          cb.invoke (kr);
        END;
      EXCEPT
      | CB.BadMethod =&gt;
        Obliq.RaiseException (ObCB.BadMethod, opCode.name, loc);
      END;
      RETURN ObValue.valOk;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObKeyCB.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
