<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObKeySym.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObKeySym.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Mon Jul 25 13:25:14 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObKeySym.i3">ObKeySym</A></implements></module>;

IMPORT <A HREF="../../ui/src/vbt/Latin1Key.i3">Latin1Key</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../text/src/Text.i3">Text</A>, <A HREF="../../ui/src/vbt/VBT.i3">VBT</A>;

PROCEDURE <A NAME="M3ToObliq"><procedure>M3ToObliq</procedure></A> (k : VBT.KeySym) : ObValue.Val =
  VAR
    t : TEXT;
  BEGIN
    CASE k OF
    | Latin1Key.space        =&gt; t := &quot; &quot;;
    | Latin1Key.exclam       =&gt; t := &quot;!&quot;;
    | Latin1Key.quotedbl     =&gt; t := &quot;\&quot;&quot;;
    | Latin1Key.numbersign   =&gt; t := &quot;#&quot;;
    | Latin1Key.dollar       =&gt; t := &quot;$&quot;;
    | Latin1Key.percent      =&gt; t := &quot;%&quot;;
    | Latin1Key.ampersand    =&gt; t := &quot;&amp;&quot;;
    | Latin1Key.apostrophe   =&gt; t := &quot;'&quot;;
    | Latin1Key.parenleft    =&gt; t := &quot;(&quot;;
    | Latin1Key.parenright   =&gt; t := &quot;)&quot;;
    | Latin1Key.asterisk     =&gt; t := &quot;*&quot;;
    | Latin1Key.plus         =&gt; t := &quot;+&quot;;
    | Latin1Key.comma        =&gt; t := &quot;,&quot;;
    | Latin1Key.minus        =&gt; t := &quot;-&quot;;
    | Latin1Key.period       =&gt; t := &quot;.&quot;;
    | Latin1Key.slash        =&gt; t := &quot;/&quot;;
    | Latin1Key.zero         =&gt; t := &quot;0&quot;;
    | Latin1Key.one          =&gt; t := &quot;1&quot;;
    | Latin1Key.two          =&gt; t := &quot;2&quot;;
    | Latin1Key.three        =&gt; t := &quot;3&quot;;
    | Latin1Key.four         =&gt; t := &quot;4&quot;;
    | Latin1Key.five         =&gt; t := &quot;5&quot;;
    | Latin1Key.six          =&gt; t := &quot;6&quot;;
    | Latin1Key.seven        =&gt; t := &quot;7&quot;;
    | Latin1Key.eight        =&gt; t := &quot;8&quot;;
    | Latin1Key.nine         =&gt; t := &quot;9&quot;;
    | Latin1Key.colon        =&gt; t := &quot;:&quot;;
    | Latin1Key.semicolon    =&gt; t := &quot;;&quot;;
    | Latin1Key.less         =&gt; t := &quot;&lt;&quot;;
    | Latin1Key.equal        =&gt; t := &quot;=&quot;;
    | Latin1Key.greater      =&gt; t := &quot;&gt;&quot;;
    | Latin1Key.question     =&gt; t := &quot;?&quot;;
    | Latin1Key.at           =&gt; t := &quot;@&quot;;
    | Latin1Key.A            =&gt; t := &quot;A&quot;;
    | Latin1Key.B            =&gt; t := &quot;B&quot;;
    | Latin1Key.C            =&gt; t := &quot;C&quot;;
    | Latin1Key.D            =&gt; t := &quot;D&quot;;
    | Latin1Key.E            =&gt; t := &quot;E&quot;;
    | Latin1Key.F            =&gt; t := &quot;F&quot;;
    | Latin1Key.G            =&gt; t := &quot;G&quot;;
    | Latin1Key.H            =&gt; t := &quot;H&quot;;
    | Latin1Key.I            =&gt; t := &quot;I&quot;;
    | Latin1Key.J            =&gt; t := &quot;J&quot;;
    | Latin1Key.K            =&gt; t := &quot;K&quot;;
    | Latin1Key.L            =&gt; t := &quot;L&quot;;
    | Latin1Key.M            =&gt; t := &quot;M&quot;;
    | Latin1Key.N            =&gt; t := &quot;N&quot;;
    | Latin1Key.O            =&gt; t := &quot;O&quot;;
    | Latin1Key.P            =&gt; t := &quot;P&quot;;
    | Latin1Key.Q            =&gt; t := &quot;Q&quot;;
    | Latin1Key.R            =&gt; t := &quot;R&quot;;
    | Latin1Key.S            =&gt; t := &quot;S&quot;;
    | Latin1Key.T            =&gt; t := &quot;T&quot;;
    | Latin1Key.U            =&gt; t := &quot;U&quot;;
    | Latin1Key.V            =&gt; t := &quot;V&quot;;
    | Latin1Key.W            =&gt; t := &quot;W&quot;;
    | Latin1Key.X            =&gt; t := &quot;X&quot;;
    | Latin1Key.Y            =&gt; t := &quot;Y&quot;;
    | Latin1Key.Z            =&gt; t := &quot;Z&quot;;
    | Latin1Key.bracketleft  =&gt; t := &quot;[&quot;;
    | Latin1Key.backslash    =&gt; t := &quot;\\&quot;;
    | Latin1Key.bracketright =&gt; t := &quot;]&quot;;
    | Latin1Key.asciicircum  =&gt; t := &quot;&quot;;
    | Latin1Key.underscore   =&gt; t := &quot;_&quot;;
    | Latin1Key.grave        =&gt; t := &quot;`&quot;;
    | Latin1Key.a            =&gt; t := &quot;a&quot;;
    | Latin1Key.b            =&gt; t := &quot;b&quot;;
    | Latin1Key.c            =&gt; t := &quot;c&quot;;
    | Latin1Key.d            =&gt; t := &quot;d&quot;;
    | Latin1Key.e            =&gt; t := &quot;e&quot;;
    | Latin1Key.f            =&gt; t := &quot;f&quot;;
    | Latin1Key.g            =&gt; t := &quot;g&quot;;
    | Latin1Key.h            =&gt; t := &quot;h&quot;;
    | Latin1Key.i            =&gt; t := &quot;i&quot;;
    | Latin1Key.j            =&gt; t := &quot;j&quot;;
    | Latin1Key.k            =&gt; t := &quot;k&quot;;
    | Latin1Key.l            =&gt; t := &quot;l&quot;;
    | Latin1Key.m            =&gt; t := &quot;m&quot;;
    | Latin1Key.n            =&gt; t := &quot;n&quot;;
    | Latin1Key.o            =&gt; t := &quot;o&quot;;
    | Latin1Key.p            =&gt; t := &quot;p&quot;;
    | Latin1Key.q            =&gt; t := &quot;q&quot;;
    | Latin1Key.r            =&gt; t := &quot;r&quot;;
    | Latin1Key.s            =&gt; t := &quot;s&quot;;
    | Latin1Key.t            =&gt; t := &quot;t&quot;;
    | Latin1Key.u            =&gt; t := &quot;u&quot;;
    | Latin1Key.v            =&gt; t := &quot;v&quot;;
    | Latin1Key.w            =&gt; t := &quot;w&quot;;
    | Latin1Key.x            =&gt; t := &quot;x&quot;;
    | Latin1Key.y            =&gt; t := &quot;y&quot;;
    | Latin1Key.z            =&gt; t := &quot;z&quot;;
    | Latin1Key.braceleft    =&gt; t := &quot;{&quot;;
    | Latin1Key.bar          =&gt; t := &quot;|&quot;;
    | Latin1Key.braceright   =&gt; t := &quot;}&quot;;
    | Latin1Key.asciitilde   =&gt; t := &quot;~&quot;;
    ELSE
      t := &quot;Other&quot;;
    END;
    RETURN Obliq.NewText (t);
  END M3ToObliq;

PROCEDURE <A NAME="ObliqToM3"><procedure>ObliqToM3</procedure></A> (val : ObValue.Val) : VBT.KeySym RAISES {ObValue.Error} =
  BEGIN
    WITH t = Obliq.ToText (val) DO
      IF Text.Equal (t, &quot; &quot;) THEN
        RETURN Latin1Key.space;
      ELSIF Text.Equal (t, &quot;!&quot;) THEN
        RETURN Latin1Key.exclam;
      ELSIF Text.Equal (t, &quot;\&quot;&quot;) THEN
        RETURN Latin1Key.quotedbl;
      ELSIF Text.Equal (t, &quot;#&quot;) THEN
        RETURN Latin1Key.numbersign;
      ELSIF Text.Equal (t, &quot;$&quot;) THEN
        RETURN Latin1Key.dollar;
      ELSIF Text.Equal (t, &quot;%&quot;) THEN
        RETURN Latin1Key.percent;
      ELSIF Text.Equal (t, &quot;&amp;&quot;) THEN
        RETURN Latin1Key.ampersand;
      ELSIF Text.Equal (t, &quot;'&quot;) THEN
        RETURN Latin1Key.apostrophe;
      ELSIF Text.Equal (t, &quot;(&quot;) THEN
        RETURN Latin1Key.parenleft;
      ELSIF Text.Equal (t, &quot;)&quot;) THEN
        RETURN Latin1Key.parenright;
      ELSIF Text.Equal (t, &quot;*&quot;) THEN
        RETURN Latin1Key.asterisk;
      ELSIF Text.Equal (t, &quot;+&quot;) THEN
        RETURN Latin1Key.plus;
      ELSIF Text.Equal (t, &quot;,&quot;) THEN
        RETURN Latin1Key.comma;
      ELSIF Text.Equal (t, &quot;-&quot;) THEN
        RETURN Latin1Key.minus;
      ELSIF Text.Equal (t, &quot;.&quot;) THEN
        RETURN Latin1Key.period;
      ELSIF Text.Equal (t, &quot;/&quot;) THEN
        RETURN Latin1Key.slash;
      ELSIF Text.Equal (t, &quot;0&quot;) THEN
        RETURN Latin1Key.zero;
      ELSIF Text.Equal (t, &quot;1&quot;) THEN
        RETURN Latin1Key.one;
      ELSIF Text.Equal (t, &quot;2&quot;) THEN
        RETURN Latin1Key.two;
      ELSIF Text.Equal (t, &quot;3&quot;) THEN
        RETURN Latin1Key.three;
      ELSIF Text.Equal (t, &quot;4&quot;) THEN
        RETURN Latin1Key.four;
      ELSIF Text.Equal (t, &quot;5&quot;) THEN
        RETURN Latin1Key.five;
      ELSIF Text.Equal (t, &quot;6&quot;) THEN
        RETURN Latin1Key.six;
      ELSIF Text.Equal (t, &quot;7&quot;) THEN
        RETURN Latin1Key.seven;
      ELSIF Text.Equal (t, &quot;8&quot;) THEN
        RETURN Latin1Key.eight;
      ELSIF Text.Equal (t, &quot;9&quot;) THEN
        RETURN Latin1Key.nine;
      ELSIF Text.Equal (t, &quot;:&quot;) THEN
        RETURN Latin1Key.colon;
      ELSIF Text.Equal (t, &quot;;&quot;) THEN
        RETURN Latin1Key.semicolon;
      ELSIF Text.Equal (t, &quot;&lt;&quot;) THEN
        RETURN Latin1Key.less;
      ELSIF Text.Equal (t, &quot;=&quot;) THEN
        RETURN Latin1Key.equal;
      ELSIF Text.Equal (t, &quot;&gt;&quot;) THEN
        RETURN Latin1Key.greater;
      ELSIF Text.Equal (t, &quot;?&quot;) THEN
        RETURN Latin1Key.question;
      ELSIF Text.Equal (t, &quot;@&quot;) THEN
        RETURN Latin1Key.at;
      ELSIF Text.Equal (t, &quot;A&quot;) THEN
        RETURN Latin1Key.A;
      ELSIF Text.Equal (t, &quot;B&quot;) THEN
        RETURN Latin1Key.B;
      ELSIF Text.Equal (t, &quot;C&quot;) THEN
        RETURN Latin1Key.C;
      ELSIF Text.Equal (t, &quot;D&quot;) THEN
        RETURN Latin1Key.D;
      ELSIF Text.Equal (t, &quot;E&quot;) THEN
        RETURN Latin1Key.E;
      ELSIF Text.Equal (t, &quot;F&quot;) THEN
        RETURN Latin1Key.F;
      ELSIF Text.Equal (t, &quot;G&quot;) THEN
        RETURN Latin1Key.G;
      ELSIF Text.Equal (t, &quot;H&quot;) THEN
        RETURN Latin1Key.H;
      ELSIF Text.Equal (t, &quot;I&quot;) THEN
        RETURN Latin1Key.I;
      ELSIF Text.Equal (t, &quot;J&quot;) THEN
        RETURN Latin1Key.J;
      ELSIF Text.Equal (t, &quot;K&quot;) THEN
        RETURN Latin1Key.K;
      ELSIF Text.Equal (t, &quot;L&quot;) THEN
        RETURN Latin1Key.L;
      ELSIF Text.Equal (t, &quot;M&quot;) THEN
        RETURN Latin1Key.M;
      ELSIF Text.Equal (t, &quot;N&quot;) THEN
        RETURN Latin1Key.N;
      ELSIF Text.Equal (t, &quot;O&quot;) THEN
        RETURN Latin1Key.O;
      ELSIF Text.Equal (t, &quot;P&quot;) THEN
        RETURN Latin1Key.P;
      ELSIF Text.Equal (t, &quot;Q&quot;) THEN
        RETURN Latin1Key.Q;
      ELSIF Text.Equal (t, &quot;R&quot;) THEN
        RETURN Latin1Key.R;
      ELSIF Text.Equal (t, &quot;S&quot;) THEN
        RETURN Latin1Key.S;
      ELSIF Text.Equal (t, &quot;T&quot;) THEN
        RETURN Latin1Key.T;
      ELSIF Text.Equal (t, &quot;U&quot;) THEN
        RETURN Latin1Key.U;
      ELSIF Text.Equal (t, &quot;V&quot;) THEN
        RETURN Latin1Key.V;
      ELSIF Text.Equal (t, &quot;W&quot;) THEN
        RETURN Latin1Key.W;
      ELSIF Text.Equal (t, &quot;X&quot;) THEN
        RETURN Latin1Key.X;
      ELSIF Text.Equal (t, &quot;Y&quot;) THEN
        RETURN Latin1Key.Y;
      ELSIF Text.Equal (t, &quot;Z&quot;) THEN
        RETURN Latin1Key.Z;
      ELSIF Text.Equal (t, &quot;[&quot;) THEN
        RETURN Latin1Key.bracketleft;
      ELSIF Text.Equal (t, &quot;\\&quot;) THEN
        RETURN Latin1Key.backslash;
      ELSIF Text.Equal (t, &quot;]&quot;) THEN
        RETURN Latin1Key.bracketright;
      ELSIF Text.Equal (t, &quot;&quot;) THEN
        RETURN Latin1Key.asciicircum;
      ELSIF Text.Equal (t, &quot;_&quot;) THEN
        RETURN Latin1Key.underscore;
      ELSIF Text.Equal (t, &quot;`&quot;) THEN
        RETURN Latin1Key.grave;
      ELSIF Text.Equal (t, &quot;a&quot;) THEN
        RETURN Latin1Key.a;
      ELSIF Text.Equal (t, &quot;b&quot;) THEN
        RETURN Latin1Key.b;
      ELSIF Text.Equal (t, &quot;c&quot;) THEN
        RETURN Latin1Key.c;
      ELSIF Text.Equal (t, &quot;d&quot;) THEN
        RETURN Latin1Key.d;
      ELSIF Text.Equal (t, &quot;e&quot;) THEN
        RETURN Latin1Key.e;
      ELSIF Text.Equal (t, &quot;f&quot;) THEN
        RETURN Latin1Key.f;
      ELSIF Text.Equal (t, &quot;g&quot;) THEN
        RETURN Latin1Key.g;
      ELSIF Text.Equal (t, &quot;h&quot;) THEN
        RETURN Latin1Key.h;
      ELSIF Text.Equal (t, &quot;i&quot;) THEN
        RETURN Latin1Key.i;
      ELSIF Text.Equal (t, &quot;j&quot;) THEN
        RETURN Latin1Key.j;
      ELSIF Text.Equal (t, &quot;k&quot;) THEN
        RETURN Latin1Key.k;
      ELSIF Text.Equal (t, &quot;l&quot;) THEN
        RETURN Latin1Key.l;
      ELSIF Text.Equal (t, &quot;m&quot;) THEN
        RETURN Latin1Key.m;
      ELSIF Text.Equal (t, &quot;n&quot;) THEN
        RETURN Latin1Key.n;
      ELSIF Text.Equal (t, &quot;o&quot;) THEN
        RETURN Latin1Key.o;
      ELSIF Text.Equal (t, &quot;p&quot;) THEN
        RETURN Latin1Key.p;
      ELSIF Text.Equal (t, &quot;q&quot;) THEN
        RETURN Latin1Key.q;
      ELSIF Text.Equal (t, &quot;r&quot;) THEN
        RETURN Latin1Key.r;
      ELSIF Text.Equal (t, &quot;s&quot;) THEN
        RETURN Latin1Key.s;
      ELSIF Text.Equal (t, &quot;t&quot;) THEN
        RETURN Latin1Key.t;
      ELSIF Text.Equal (t, &quot;u&quot;) THEN
        RETURN Latin1Key.u;
      ELSIF Text.Equal (t, &quot;v&quot;) THEN
        RETURN Latin1Key.v;
      ELSIF Text.Equal (t, &quot;w&quot;) THEN
        RETURN Latin1Key.w;
      ELSIF Text.Equal (t, &quot;x&quot;) THEN
        RETURN Latin1Key.x;
      ELSIF Text.Equal (t, &quot;y&quot;) THEN
        RETURN Latin1Key.y;
      ELSIF Text.Equal (t, &quot;z&quot;) THEN
        RETURN Latin1Key.z;
      ELSIF Text.Equal (t, &quot;{&quot;) THEN
        RETURN Latin1Key.braceleft;
      ELSIF Text.Equal (t, &quot;|&quot;) THEN
        RETURN Latin1Key.bar;
      ELSIF Text.Equal (t, &quot;}&quot;) THEN
        RETURN Latin1Key.braceright;
      ELSIF Text.Equal (t, &quot;~&quot;) THEN
        RETURN Latin1Key.asciitilde;
      ELSE
        Obliq.RaiseError (&quot;Unknown KeySym&quot;);
        RETURN VBT.NoKey;
      END;
    END;
  END ObliqToM3;

BEGIN
END ObKeySym.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
