<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObLightGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObLightGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sat Mar  5 18:49:59 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObLightGO.i3">ObLightGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/LightGO.i3">LightGO</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="ObBooleanProp.i3">ObBooleanProp</A>, <A HREF="ObColorProp.i3">ObColorProp</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>,
       <A HREF="ObProp.i3">ObProp</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;LightGO&quot;;
</PRE>***************************************************************************
 Wrapper for LightGO.T                                                     
***************************************************************************

<P>
<P><PRE>REVEAL
  <A NAME="T">T</A> = ObGO.T BRANDED &quot;ObLightGO.T&quot; OBJECT END;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name : TEXT; arity : INTEGER; code : Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;Color&quot;,    -1, Code.Color),
            NewOpCode (&quot;Switch&quot;,   -1, Code.Switch),
            NewOpCode (&quot;SetSwitch&quot;, 2, Code.SetSwitch),
            NewOpCode (&quot;SetColor&quot;,  2, Code.SetColor)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    loader.load (&quot;LightGO.obl&quot;);
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {Color, Switch, SetColor, SetSwitch};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.Color =&gt;
      RETURN ObProp.NameToObliq (LightGO.Colour);
    | Code.Switch =&gt;
      RETURN ObProp.NameToObliq (LightGO.Switch);
    | Code.SetSwitch =&gt;
      WITH go = ObGO.GetArg                   (args, 1, self, opCode, loc),
           b  = ObBooleanProp.GetOverloadedVal(args, 2, self, opCode, loc) DO
        go.setProp (LightGO.Switch.bind (b));
        RETURN ObValue.valOk;
      END;
    | Code.SetColor =&gt;
      WITH go  = ObGO.GetArg                  (args, 1, self, opCode, loc),
           col = ObColorProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (LightGO.Colour.bind (col));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObLightGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
