<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObLineGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObLineGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 19 14:00:00 PST 1994 by najork                   

<P><PRE>MODULE <module><implements><A HREF="ObLineGO.i3">ObLineGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/LineGO.i3">LineGO</A>, <A HREF="../../anim3D/src/LineGOProxy.i3">LineGOProxy</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="ObColorProp.i3">ObColorProp</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>,
       <A HREF="ObLineTypeProp.i3">ObLineTypeProp</A>, <A HREF="ObPointProp.i3">ObPointProp</A>, <A HREF="ObProp.i3">ObProp</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObRealProp.i3">ObRealProp</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>,
       <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;LineGO&quot;;
</PRE>***************************************************************************
 Wrapper for LineGO.T                                                      
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObGO.T BRANDED &quot;ObLineGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (line : LineGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a LineGO.T&gt;&quot;, po := line) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      line.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,       2, Code.New),
            NewOpCode (&quot;Color&quot;,    -1, Code.Color),
            NewOpCode (&quot;Width&quot;,    -1, Code.Width),
            NewOpCode (&quot;Type&quot;,     -1, Code.Type),
            NewOpCode (&quot;Point1&quot;,   -1, Code.Point1),
            NewOpCode (&quot;Point2&quot;,   -1, Code.Point2),
            NewOpCode (&quot;SetColor&quot;,  2, Code.SetColor),
            NewOpCode (&quot;SetWidth&quot;,  2, Code.SetWidth),
            NewOpCode (&quot;SetType&quot;,   2, Code.SetType),
            NewOpCode (&quot;SetPoint1&quot;, 2, Code.SetPoint1),
            NewOpCode (&quot;SetPoint2&quot;, 2, Code.SetPoint2)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);

    (* DONT KNOW YET WHETHER TO INHIBIT TRANSMISSIONS ... *)

  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;LineGO.obl&quot;);
    TProto := loader.get (&quot;LineGO_TProto&quot;);

    (*** Register the proxy maker ***)
    LineGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New, Color, Width, Type, Point1, Point2,
          SetColor, SetWidth, SetType, SetPoint1, SetPoint2};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH p1 = ObPointProp.GetOverloadedVal (args, 1, self, opCode, loc),
           p2 = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc),
           line = NEW (LineGO.T).init () DO
        line.setProp (LineGO.Point1.bind (p1));
        line.setProp (LineGO.Point2.bind (p2));
        RETURN line.proxy.obj;
      END;
    | Code.Color =&gt;
      RETURN ObProp.NameToObliq (LineGO.Colour);
    | Code.Width =&gt;
      RETURN ObProp.NameToObliq (LineGO.Width);
    | Code.Type =&gt;
      RETURN ObProp.NameToObliq (LineGO.Type);
    | Code.Point1 =&gt;
      RETURN ObProp.NameToObliq (LineGO.Point1);
    | Code.Point2 =&gt;
      RETURN ObProp.NameToObliq (LineGO.Point2);
    | Code.SetColor =&gt;
      WITH go  = ObGO.GetArg (args, 1, self, opCode, loc),
           col = ObColorProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (LineGO.Colour.bind (col));
        RETURN ObValue.valOk;
      END;
    | Code.SetWidth =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           r  = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (LineGO.Width.bind (r));
        RETURN ObValue.valOk;
      END;
    | Code.SetType =&gt;
      WITH go= ObGO.GetArg                    (args, 1, self, opCode, loc),
           k = ObLineTypeProp.GetOverloadedVal(args, 2, self, opCode, loc) DO
        go.setProp (LineGO.Type.bind (k));
        RETURN ObValue.valOk;
      END;
    | Code.SetPoint1 =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p  = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (LineGO.Point1.bind (p));
        RETURN ObValue.valOk;
      END;
    | Code.SetPoint2 =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p  = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (LineGO.Point2.bind (p));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObLineGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
