<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObMarkerGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObMarkerGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 19 14:00:00 PST 1994 by najork                   

<P><PRE>MODULE <module><implements><A HREF="ObMarkerGO.i3">ObMarkerGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/MarkerGO.i3">MarkerGO</A>, <A HREF="../../anim3D/src/MarkerGOProxy.i3">MarkerGOProxy</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="ObColorProp.i3">ObColorProp</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>,
       <A HREF="ObMarkerTypeProp.i3">ObMarkerTypeProp</A>, <A HREF="ObPointProp.i3">ObPointProp</A>, <A HREF="ObProp.i3">ObProp</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObRealProp.i3">ObRealProp</A>,
       <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;MarkerGO&quot;;
</PRE>***************************************************************************
 Wrapper for OrthoCameraGO.T                                               
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObGO.T BRANDED &quot;ObMarkerGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (marker : MarkerGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a MarkerGO.T&gt;&quot;, po := marker) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      marker.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,       1, Code.New),
            NewOpCode (&quot;Center&quot;,   -1, Code.Center),
            NewOpCode (&quot;Color&quot;,    -1, Code.Color),
            NewOpCode (&quot;Scale&quot;,    -1, Code.Scale),
            NewOpCode (&quot;Type&quot;,     -1, Code.Type),
            NewOpCode (&quot;SetCenter&quot;, 2, Code.SetCenter),
            NewOpCode (&quot;SetColor&quot;,  2, Code.SetColor),
            NewOpCode (&quot;SetScale&quot;,  2, Code.SetScale),
            NewOpCode (&quot;SetType&quot;,   2, Code.SetType)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;MarkerGO.obl&quot;);
    TProto := loader.get (&quot;MarkerGO_TProto&quot;);

    (*** Register the proxy maker ***)
    MarkerGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New, Center, Color, Scale, Type, SetCenter, SetColor, SetScale,
          SetType};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH p = ObPointProp.GetOverloadedVal (args, 1, self, opCode, loc),
           marker = NEW (MarkerGO.T).init () DO
        marker.setProp (MarkerGO.Center.bind (p));
        RETURN marker.proxy.obj;
      END;
    | Code.Center =&gt;
      RETURN ObProp.NameToObliq (MarkerGO.Center);
    | Code.Color =&gt;
      RETURN ObProp.NameToObliq (MarkerGO.Colour);
    | Code.Scale =&gt;
      RETURN ObProp.NameToObliq (MarkerGO.Scale);
    | Code.Type =&gt;
      RETURN ObProp.NameToObliq (MarkerGO.Type);
    | Code.SetCenter =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           p  = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (MarkerGO.Center.bind (p));
        RETURN ObValue.valOk;
      END;
    | Code.SetColor =&gt;
      WITH go  = ObGO.GetArg                  (args, 1, self, opCode, loc),
           col = ObColorProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (MarkerGO.Colour.bind (col));
        RETURN ObValue.valOk;
      END;
    | Code.SetScale =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           r  = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (MarkerGO.Scale.bind (r));
        RETURN ObValue.valOk;
      END;
    | Code.SetType =&gt;
      WITH go = ObGO.GetArg (args, 1, self, opCode, loc),
           pv = ObMarkerTypeProp.GetOverloadedVal
           (args, 2, self, opCode, loc) DO
        go.setProp (MarkerGO.Type.bind (pv));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObMarkerGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
