<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObMatrix4.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObMatrix4.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 19 14:00:00 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObMatrix4.i3">ObMatrix4</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/Matrix4.i3">Matrix4</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObReal.i3">ObReal</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

REVEAL
  <A NAME="T">T</A> = ObValue.ValAnything BRANDED OBJECT
    matrix : Matrix4.T;
  OVERRIDES
    Is := DoIs;
  END;

TYPE
  Code = {Id, Multiply, Translate, Scale, RotateX, RotateY, RotateZ};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

CONST
  pkgname = &quot;Matrix4&quot;;

PROCEDURE <A NAME="DoIs"><procedure>DoIs</procedure></A> (self: T; other: ObValue.ValAnything): BOOLEAN =
  BEGIN
    TYPECASE other OF
      T (oth) =&gt; RETURN self.matrix = oth.matrix;
    ELSE
      RETURN FALSE
    END;
  END DoIs;

PROCEDURE <A NAME="M3ToObliq"><procedure>M3ToObliq</procedure></A> (READONLY val : Matrix4.T) : T =
  BEGIN
    RETURN NEW (T, what := &quot;&lt;a Matrix4.T&gt;&quot;, matrix := val);
  END M3ToObliq;

PROCEDURE <A NAME="ObliqToM3"><procedure>ObliqToM3</procedure></A> (val : T) : Matrix4.T =
  BEGIN
    RETURN val.matrix;
  END ObliqToM3;

PROCEDURE <A NAME="GetArg"><procedure>GetArg</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : Matrix4.T RAISES {ObValue.Error} =
  BEGIN
    TYPECASE args[idx] OF
    | T (node) =&gt;
      RETURN node.matrix;
    ELSE
      ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
      RETURN Matrix4.Id;     (* ... only to suppress compiler warning *)
    END;
  END GetArg;

PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;Id&quot;,       -1, Code.Id),
            NewOpCode (&quot;Multiply&quot;,  2, Code.Multiply),
            NewOpCode (&quot;Translate&quot;, 4, Code.Translate),
            NewOpCode (&quot;Scale&quot;,     4, Code.Scale),
            NewOpCode (&quot;RotateX&quot;,   2, Code.RotateX),
            NewOpCode (&quot;RotateY&quot;,   2, Code.RotateY),
            NewOpCode (&quot;RotateZ&quot;,   2, Code.RotateZ)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.Id =&gt;
      RETURN M3ToObliq (Matrix4.Id);
    | Code.Multiply =&gt;
      WITH m1 = GetArg (args, 1, self, opCode, loc),
           m2 = GetArg (args, 2, self, opCode, loc) DO
        RETURN M3ToObliq (Matrix4.Multiply (m1, m2));
      END;
    | Code.Translate =&gt;
      WITH m = GetArg        (args, 1, self, opCode, loc),
           x = ObReal.GetArg (args, 2, self, opCode, loc),
           y = ObReal.GetArg (args, 3, self, opCode, loc),
           z = ObReal.GetArg (args, 4, self, opCode, loc) DO
        RETURN M3ToObliq (Matrix4.Translate (m, x, y, z));
      END;
    | Code.Scale =&gt;
      WITH m = GetArg        (args, 1, self, opCode, loc),
           x = ObReal.GetArg (args, 2, self, opCode, loc),
           y = ObReal.GetArg (args, 3, self, opCode, loc),
           z = ObReal.GetArg (args, 4, self, opCode, loc) DO
        RETURN M3ToObliq (Matrix4.Scale (m, x, y, z));
      END;
    | Code.RotateX =&gt;
      WITH m = GetArg        (args, 1, self, opCode, loc),
           a = ObReal.GetArg (args, 2, self, opCode, loc) DO
        RETURN M3ToObliq (Matrix4.RotateX (m, a));
      END;
    | Code.RotateY =&gt;
      WITH m = GetArg        (args, 1, self, opCode, loc),
           a = ObReal.GetArg (args, 2, self, opCode, loc) DO
        RETURN M3ToObliq (Matrix4.RotateY (m, a));
      END;
    | Code.RotateZ =&gt;
      WITH m = GetArg        (args, 1, self, opCode, loc),
           a = ObReal.GetArg (args, 2, self, opCode, loc) DO
        RETURN M3ToObliq (Matrix4.RotateZ (m, a));
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObMatrix4.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
