<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObOrthoCameraGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObOrthoCameraGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sat Mar  5 20:17:39 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObOrthoCameraGO.i3">ObOrthoCameraGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/CameraGO.i3">CameraGO</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="ObCameraGO.i3">ObCameraGO</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObProp.i3">ObProp</A>,
       <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObPointProp.i3">ObPointProp</A>, <A HREF="ObRealProp.i3">ObRealProp</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/OrthoCameraGO.i3">OrthoCameraGO</A>,
       <A HREF="../../anim3D/src/OrthoCameraGOProxy.i3">OrthoCameraGOProxy</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;OrthoCameraGO&quot;;
</PRE>***************************************************************************
 Wrapper for OrthoCameraGO.T                                               
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObCameraGO.T BRANDED &quot;ObOrthoCameraGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (cam : OrthoCameraGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a OrthoCameraGO.T&gt;&quot;, po := cam) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      cam.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,        4, Code.New),
            NewOpCode (&quot;Height&quot;,    -1, Code.Height),
            NewOpCode (&quot;SetHeight&quot;,  2, Code.SetHeight)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;OrthoCameraGO.obl&quot;);
    TProto := loader.get (&quot;OrthoCameraGO_TProto&quot;);

    (*** Register the proxy maker ***)
    OrthoCameraGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New, Height, SetHeight};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH from   = ObPointProp.GetOverloadedVal(args, 1, self, opCode, loc),
           to     = ObPointProp.GetOverloadedVal(args, 2, self, opCode, loc),
           up     = ObPointProp.GetOverloadedVal(args, 3, self, opCode, loc),
           height = ObRealProp.GetOverloadedVal (args, 4, self, opCode, loc),
           cam    = NEW (OrthoCameraGO.T).init () DO
        cam.setProp (CameraGO.From.bind (from));
        cam.setProp (CameraGO.To.bind (to));
        cam.setProp (CameraGO.Up.bind (up));
        cam.setProp (OrthoCameraGO.Height.bind (height));
        RETURN cam.proxy.obj;
      END;
    | Code.Height =&gt;
      RETURN ObProp.NameToObliq (OrthoCameraGO.Height);
    | Code.SetHeight =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           pv = ObRealProp.GetOverloadedVal  (args, 2, self, opCode, loc) DO
        go.setProp (OrthoCameraGO.Height.bind (pv));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObOrthoCameraGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
