<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObPerspCameraGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObPerspCameraGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sat Mar  5 20:17:39 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObPerspCameraGO.i3">ObPerspCameraGO</A></implements></module>;

IMPORT <A HREF="../../anim3D/src/CameraGO.i3">CameraGO</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="ObCameraGO.i3">ObCameraGO</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObProp.i3">ObProp</A>,
       <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObPointProp.i3">ObPointProp</A>, <A HREF="ObRealProp.i3">ObRealProp</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/PerspCameraGO.i3">PerspCameraGO</A>,
       <A HREF="../../anim3D/src/PerspCameraGOProxy.i3">PerspCameraGOProxy</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;PerspCameraGO&quot;;
</PRE>***************************************************************************
 Wrapper for PerspCameraGO.T                                               
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObCameraGO.T BRANDED &quot;ObPerspCameraGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (cam : PerspCameraGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a PerspCameraGO.T&gt;&quot;, po := cam) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      cam.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,      4, Code.New),
            NewOpCode (&quot;Fovy&quot;,    -1, Code.Fovy),
            NewOpCode (&quot;SetFovy&quot;,  2, Code.SetFovy)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;PerspCameraGO.obl&quot;);
    TProto := loader.get (&quot;PerspCameraGO_TProto&quot;);

    (*** Register the proxy maker ***)
    PerspCameraGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New, Fovy, SetFovy};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH from = ObPointProp.GetOverloadedVal (args, 1, self, opCode, loc),
           to   = ObPointProp.GetOverloadedVal (args, 2, self, opCode, loc),
           up   = ObPointProp.GetOverloadedVal (args, 3, self, opCode, loc),
           fovy = ObRealProp.GetOverloadedVal  (args, 4, self, opCode, loc),
           cam  = NEW (PerspCameraGO.T).init () DO
        cam.setProp (CameraGO.From.bind (from));
        cam.setProp (CameraGO.To.bind (to));
        cam.setProp (CameraGO.Up.bind (up));
        cam.setProp (PerspCameraGO.Fovy.bind (fovy));
        RETURN cam.proxy.obj;
      END;
    | Code.Fovy =&gt;
      RETURN ObProp.NameToObliq (PerspCameraGO.Fovy);
    | Code.SetFovy =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           pv = ObRealProp.GetOverloadedVal  (args, 2, self, opCode, loc) DO
        go.setProp (PerspCameraGO.Fovy.bind (pv));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObPerspCameraGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
