<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObPoint3.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObPoint3.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 19 14:00:00 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObPoint3.i3">ObPoint3</A></implements></module>;

IMPORT <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObReal.i3">ObReal</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/Point3.i3">Point3</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;Point3&quot;;
</PRE>***************************************************************************
 Wrapper for Point3.T                                                      
***************************************************************************

<P><PRE>REVEAL
  <A NAME="T">T</A> = ObValue.ValArray;

PROCEDURE <A NAME="M3ToObliq"><procedure>M3ToObliq</procedure></A> (val : Point3.T) : T =
  BEGIN
    WITH x = ObReal.M3ToObliq (val.x),
         y = ObReal.M3ToObliq (val.y),
         z = ObReal.M3ToObliq (val.z) DO
      RETURN Obliq.NewArray (Obliq.Vals {x, y, z});
    END;
  END M3ToObliq;

PROCEDURE <A NAME="ObliqToM3"><procedure>ObliqToM3</procedure></A> (val : T) : Point3.T RAISES {ObValue.Error} =
  VAR
    vals : ARRAY [0 .. 2] OF Obliq.Val;
  BEGIN
    Obliq.ToArray (val, vals);
    WITH x = ObReal.ObliqToM3 (vals[0]),
         y = ObReal.ObliqToM3 (vals[1]),
         z = ObReal.ObliqToM3 (vals[2]) DO
      RETURN Point3.T {x, y, z};
    END;
  END ObliqToM3;

PROCEDURE <A NAME="GetArg"><procedure>GetArg</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : Point3.T RAISES {ObValue.Error} =
  VAR
    vals : ARRAY [0 .. 2] OF Obliq.Val;
  BEGIN
    TRY
      Obliq.ToArray (args[idx], vals);
      WITH x = ObReal.ObliqToM3 (vals[0]),
           y = ObReal.ObliqToM3 (vals[1]),
           z = ObReal.ObliqToM3 (vals[2]) DO
        RETURN Point3.T {x, y, z};
      END;
    EXCEPT
    | ObValue.Error =&gt;
      ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
      RETURN Point3.Origin;   (* ... only to suppress compiler warning *)
    END;
  END GetArg;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;Plus&quot;,        2, Code.Plus),
            NewOpCode (&quot;Minus&quot;,       2, Code.Minus),
            NewOpCode (&quot;ScaleToLen&quot;,  2, Code.ScaleToLen),
            NewOpCode (&quot;TimesScalar&quot;, 2, Code.TimesScalar),
            NewOpCode (&quot;Length&quot;,      1, Code.Length),
            NewOpCode (&quot;MidPoint&quot;,    2, Code.MidPoint),
            NewOpCode (&quot;Distance&quot;,    2, Code.Distance)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {Plus, Minus, ScaleToLen, TimesScalar,
          Length, MidPoint, Distance};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.Plus =&gt;
      WITH p1 = GetArg (args, 1, self, opCode, loc),
           p2 = GetArg (args, 2, self, opCode, loc) DO
        RETURN M3ToObliq (Point3.Plus (p1, p2));
      END;
    | Code.Minus =&gt;
      WITH p1 = GetArg (args, 1, self, opCode, loc),
           p2 = GetArg (args, 2, self, opCode, loc) DO
        RETURN M3ToObliq (Point3.Minus (p1, p2));
      END;
    | Code.ScaleToLen =&gt;
      WITH p =        GetArg (args, 1, self, opCode, loc),
           s = ObReal.GetArg (args, 2, self, opCode, loc) DO
        RETURN M3ToObliq (Point3.ScaleToLen (p, s));
      END;
    | Code.TimesScalar =&gt;
      WITH p =        GetArg (args, 1, self, opCode, loc),
           s = ObReal.GetArg (args, 2, self, opCode, loc) DO
        RETURN M3ToObliq (Point3.TimesScalar (p, s));
      END;
    | Code.Length =&gt;
      WITH p = GetArg (args, 1, self, opCode, loc) DO
        RETURN ObReal.M3ToObliq (Point3.Length (p));
      END;
    | Code.MidPoint =&gt;
      WITH a = GetArg (args, 1, self, opCode, loc),
           b = GetArg (args, 2, self, opCode, loc) DO
        RETURN M3ToObliq (Point3.MidPoint (a, b));
      END;
    | Code.Distance =&gt;
      WITH a = GetArg (args, 1, self, opCode, loc),
           b = GetArg (args, 2, self, opCode, loc) DO
        RETURN ObReal.M3ToObliq (Point3.Distance (a, b));
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObPoint3.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
