<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObPointProp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObPointProp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sat May 28 11:15:36 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObPointProp.i3">ObPointProp</A></implements></module>;

IMPORT <A HREF="ObAnimHandle.i3">ObAnimHandle</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObLongReal.i3">ObLongReal</A>, <A HREF="ObPoint3.i3">ObPoint3</A>, <A HREF="ObProp.i3">ObProp</A>,
       <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObReal.i3">ObReal</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/Point3.i3">Point3</A>, <A HREF="../../anim3D/src/PointProp.i3">PointProp</A>,
       <A HREF="../../anim3D/src/PointPropProxy.i3">PointPropProxy</A>, <A HREF="../../anim3D/src/Prop.i3">Prop</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;
</PRE>***************************************************************************
 Wrapper for PointProp.Name                                                
***************************************************************************

<P><PRE>TYPE
  Name = ObProp.Name BRANDED &quot;ObPointProp.Name&quot; OBJECT END;

PROCEDURE <A NAME="AddNameObj"><procedure>AddNameObj</procedure></A> (pn : PointProp.Name) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {NameProto}),
         raw = NEW (Name, what := &quot;&lt;a PointProp.Name&gt;&quot;, po := pn) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      pn.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddNameObj;

PROCEDURE <A NAME="GetName"><procedure>GetName</procedure></A> (args    : ObValue.ArgArray;
                   idx     : INTEGER;
                   package : ObLib.T;
                   opCode  : ObLib.OpCode;
                   loc     : SynLocation.T) : PointProp.Name
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Name (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetName;
</PRE>***************************************************************************
 Wrapper for PointProp.Val                                                 
***************************************************************************

<P>
<P><PRE>TYPE
  Val = ObProp.Val BRANDED &quot;ObPointProp.Val&quot; OBJECT END;

PROCEDURE <A NAME="AddValObj"><procedure>AddValObj</procedure></A> (pv : PointProp.Val) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {ValProto}),
         raw = NEW (Val, what := &quot;&lt;a PointProp.Val&gt;&quot;, po := pv) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      pv.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddValObj;

PROCEDURE <A NAME="GetVal"><procedure>GetVal</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : PointProp.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Val (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetVal;

PROCEDURE <A NAME="GetOverloadedVal"><procedure>GetOverloadedVal</procedure></A> (args    : ObValue.ArgArray;
                            idx     : INTEGER;
                            package : ObLib.T;
                            opCode  : ObLib.OpCode;
                            loc     : SynLocation.T) : PointProp.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  VAR
    vals : ARRAY [0 .. 2] OF Obliq.Val;
  BEGIN
    TYPECASE args[idx] OF
    | ObValue.ValArray =&gt;
      TRY
        Obliq.ToArray (args[idx], vals);
        WITH x = ObReal.ObliqToM3 (vals[0]),
             y = ObReal.ObliqToM3 (vals[1]),
             z = ObReal.ObliqToM3 (vals[2]),
             p = Point3.T {x, y, z} DO
          RETURN PointProp.NewConst (p);
        END;
      EXCEPT
      | ObValue.Error =&gt;
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;   (* ... only to suppress compiler warning *)
      END;
    | ObValue.ValObj =&gt;
      WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
        TYPECASE raw OF
        | Val (node) =&gt;
          RETURN node.po;
        ELSE
          ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
          RETURN NIL;      (* ... only to suppress compiler warning *)
        END;
      END;
    ELSE
      ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
      RETURN NIL;   (* ... only to suppress compiler warning *)
    END;
  END GetOverloadedVal;

PROCEDURE <A NAME="ObliqToM3"><procedure>ObliqToM3</procedure></A> (val : Obliq.Val) : PointProp.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  VAR
    vals : ARRAY [0 .. 2] OF Obliq.Val;
  BEGIN
    TYPECASE val OF
    | ObValue.ValArray =&gt;
      Obliq.ToArray (val, vals);
      WITH x = ObReal.ObliqToM3 (vals[0]),
           y = ObReal.ObliqToM3 (vals[1]),
           z = ObReal.ObliqToM3 (vals[2]),
           p = Point3.T {x, y, z} DO
        RETURN PointProp.NewConst (p);
      END;
    | ObValue.ValObj =&gt;
      WITH raw = Obliq.ObjectSelect (val, &quot;raw&quot;) DO
        TYPECASE raw OF
        | Val (node) =&gt;
          RETURN node.po;
        ELSE
          Obliq.RaiseError (&quot;Expected (Point3 + PointPropVal)&quot;);
          RETURN NIL;      (* ... only to suppress compiler warning *)
        END;
      END;
    ELSE
      Obliq.RaiseError (&quot;Expected (Point3 + PointPropVal)&quot;);
      RETURN NIL;   (* ... only to suppress compiler warning *)
    END;
  END ObliqToM3;
</PRE>***************************************************************************
 Wrapper for PointProp.Beh                                                 
***************************************************************************

<P><PRE>TYPE
  Beh = ObProp.Beh BRANDED &quot;ObPointProp.Beh&quot; OBJECT END;

PROCEDURE <A NAME="GetBeh"><procedure>GetBeh</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : PointProp.Beh
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Beh (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetBeh;
</PRE>***************************************************************************
 Wrapper for PointProp.ConstBeh                                            
***************************************************************************

<P>
<P><PRE>TYPE
  ConstBeh = Beh BRANDED &quot;ObPointProp.ConstBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddConstBehObj"><procedure>AddConstBehObj</procedure></A> (beh : PointProp.ConstBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {ConstBehProto}),
         raw = NEW (ConstBeh, what := &quot;&lt;a PointProp.ConstBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddConstBehObj;

PROCEDURE <A NAME="GetConstBeh"><procedure>GetConstBeh</procedure></A> (args    : ObValue.ArgArray;
                       idx     : INTEGER;
                       package : ObLib.T;
                       opCode  : ObLib.OpCode;
                       loc     : SynLocation.T) : PointProp.ConstBeh
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | ConstBeh (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetConstBeh;
</PRE>***************************************************************************
 Wrapper for PointProp.SyncBeh                                             
***************************************************************************

<P>
<P><PRE>TYPE
  SyncBeh = Beh BRANDED &quot;ObPointProp.SyncBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddSyncBehObj"><procedure>AddSyncBehObj</procedure></A> (beh : PointProp.SyncBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {SyncBehProto}),
         raw = NEW (SyncBeh, what := &quot;&lt;a PointProp.SyncBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddSyncBehObj;

PROCEDURE <A NAME="GetSyncBeh"><procedure>GetSyncBeh</procedure></A> (args    : ObValue.ArgArray;
                       idx     : INTEGER;
                       package : ObLib.T;
                       opCode  : ObLib.OpCode;
                       loc     : SynLocation.T) : PointProp.SyncBeh
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | SyncBeh (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetSyncBeh;
</PRE>***************************************************************************
 Wrapper for PointProp.AsyncBeh                                            
***************************************************************************

<P>
<P><PRE>TYPE
  AsyncBeh = Beh BRANDED &quot;ObPointProp.AsyncBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddAsyncBehObj"><procedure>AddAsyncBehObj</procedure></A> (beh : PointProp.AsyncBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {AsyncBehProto}),
         raw = NEW (AsyncBeh, what := &quot;&lt;a PointProp.AsyncBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (AsyncBehProxy, obj := obj);
    END;
  END AddAsyncBehObj;

TYPE
  AsyncBehProxy = PointPropProxy.AsyncBehProxy BRANDED OBJECT
  OVERRIDES
    compute := AsyncBehCompute;
  END;

PROCEDURE <A NAME="AsyncBehCompute"><procedure>AsyncBehCompute</procedure></A> (proxy : AsyncBehProxy; time : LONGREAL) : Point3.T
    RAISES {Prop.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {Obliq.NewReal (time)},
           obj  = NARROW (proxy.obj, Obliq.Val),
           res  = Obliq.ObjectInvoke (obj, &quot;compute&quot;, args) DO
        RETURN ObPoint3.ObliqToM3 (res);
      END;
    EXCEPT
    | ObValue.Error (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END AsyncBehCompute;
</PRE>***************************************************************************
 Wrapper for PointProp.DepBeh                                              
***************************************************************************

<P>
<P><PRE>TYPE
  DepBeh = Beh BRANDED &quot;ObPointProp.DepBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddDepBehObj"><procedure>AddDepBehObj</procedure></A> (beh : PointProp.DepBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {DepBehProto}),
         raw = NEW (DepBeh, what := &quot;&lt;a PointProp.DepBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (DepBehProxy, obj := obj);
    END;
  END AddDepBehObj;

TYPE
  DepBehProxy = PointPropProxy.DepBehProxy BRANDED OBJECT
  OVERRIDES
    compute := DepBehCompute;
  END;

PROCEDURE <A NAME="DepBehCompute"><procedure>DepBehCompute</procedure></A> (proxy : DepBehProxy; time : LONGREAL) : Point3.T
    RAISES {Prop.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {Obliq.NewReal (time)},
           obj  = NARROW (proxy.obj, Obliq.Val),
           res  = Obliq.ObjectInvoke (obj, &quot;compute&quot;, args) DO
        RETURN ObPoint3.ObliqToM3 (res);
      END;
    EXCEPT
    | ObValue.Error (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END DepBehCompute;
</PRE>***************************************************************************
 Wrapper for PointProp.Request                                             
***************************************************************************

<P>
<P><PRE>TYPE
  Request = ObProp.Request BRANDED &quot;ObPointProp.Request&quot; OBJECT END;

PROCEDURE <A NAME="AddRequestObj"><procedure>AddRequestObj</procedure></A> (req : PointProp.Request) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {RequestProto}),
         raw = NEW (Request, what := &quot;&lt;a PointProp.Request&gt;&quot;, po := req) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      req.proxy := NEW (RequestProxy, obj := obj);
    END;
  END AddRequestObj;

PROCEDURE <A NAME="GetRequest"><procedure>GetRequest</procedure></A> (args    : ObValue.ArgArray;
                      idx     : INTEGER;
                      package : ObLib.T;
                      opCode  : ObLib.OpCode;
                      loc     : SynLocation.T) : PointProp.Request
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Request (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetRequest;

TYPE
  RequestProxy = PointPropProxy.RequestProxy BRANDED OBJECT
  OVERRIDES
    value := RequestValue;
  END;

PROCEDURE <A NAME="RequestValue"><procedure>RequestValue</procedure></A> (proxy    : RequestProxy;
                        startval : Point3.T;
                        reltime  : REAL) : Point3.T
    RAISES {Prop.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {ObPoint3.M3ToObliq (startval),
                              ObReal.M3ToObliq (reltime)},
           obj  = NARROW (proxy.obj, Obliq.Val),
           res  = Obliq.ObjectInvoke (obj, &quot;value&quot;, args) DO
        RETURN ObPoint3.ObliqToM3 (res);
      END;
    EXCEPT
    | ObValue.Error (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END RequestValue;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes := NEW (REF OpCodes, NUMBER (Code));
  BEGIN
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;NameBind&quot;,           2, Code.NameBind),
            NewOpCode (&quot;ValGetBeh&quot;,          1, Code.ValGetBeh),
            NewOpCode (&quot;ValSetBeh&quot;,          2, Code.ValSetBeh),
            NewOpCode (&quot;ValGet&quot;,             1, Code.ValGet),
            NewOpCode (&quot;ValValue&quot;,           2, Code.ValValue),
            NewOpCode (&quot;NewConst&quot;,           1, Code.NewConst),
            NewOpCode (&quot;NewSync&quot;,            2, Code.NewSync),
            NewOpCode (&quot;NewAsync&quot;,           1, Code.NewAsync),
            NewOpCode (&quot;NewDep&quot;,             1, Code.NewDep),
            NewOpCode (&quot;ConstBehSet&quot;,        2, Code.ConstBehSet),
            NewOpCode (&quot;NewConstBeh&quot;,        1, Code.NewConstBeh),
            NewOpCode (&quot;SyncBehAddRequest&quot;,  2, Code.SyncBehAddRequest),
            NewOpCode (&quot;SyncBehLinMoveTo&quot;,   4, Code.SyncBehLinMoveTo),
            NewOpCode (&quot;SyncBehLinMoveBy&quot;,   4, Code.SyncBehLinMoveBy),
            NewOpCode (&quot;NewSyncBeh&quot;,         2, Code.NewSyncBeh),
            NewOpCode (&quot;NewAsyncBeh&quot;,        1, Code.NewAsyncBeh),
            NewOpCode (&quot;NewDepBeh&quot;,          1, Code.NewDepBeh),
            NewOpCode (&quot;NewRequest&quot;,         3, Code.NewRequest)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  NameProto     : ObValue.Val;
  ValProto      : ObValue.Val;
  ConstBehProto : ObValue.Val;
  SyncBehProto  : ObValue.Val;
  AsyncBehProto : ObValue.Val;
  DepBehProto   : ObValue.Val;
  RequestProto  : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** retrieve the prototypes ***)
    loader.load (&quot;PointProp.obl&quot;);
    NameProto     := loader.get (&quot;PointProp_NameProto&quot;);
    ValProto      := loader.get (&quot;PointProp_ValProto&quot;);
    ConstBehProto := loader.get (&quot;PointProp_ConstBehProto&quot;);
    SyncBehProto  := loader.get (&quot;PointProp_SyncBehProto&quot;);
    AsyncBehProto := loader.get (&quot;PointProp_AsyncBehProto&quot;);
    DepBehProto   := loader.get (&quot;PointProp_DepBehProto&quot;);
    RequestProto  := loader.get (&quot;PointProp_RequestProto&quot;);

    (*** Register the proxy makers ***)
    PointPropProxy.NamePM     := AddNameObj;
    PointPropProxy.ValPM      := AddValObj;
    PointPropProxy.ConstBehPM := AddConstBehObj;
    PointPropProxy.SyncBehPM  := AddSyncBehObj;
    PointPropProxy.AsyncBehPM := AddAsyncBehObj;
    PointPropProxy.DepBehPM   := AddDepBehObj;
    PointPropProxy.RequestPM  := AddRequestObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {NameBind,
          ValGetBeh, ValSetBeh, ValGet, ValValue,
             NewConst, NewSync, NewAsync, NewDep,
          ConstBehSet, NewConstBeh,
          SyncBehAddRequest, SyncBehLinMoveTo, SyncBehLinMoveBy,
             NewSyncBeh,
          NewAsyncBeh,
          NewDepBeh,
          NewRequest};

  OpCode = ObLib.OpCode BRANDED OBJECT
    code: Code;
  END;

  Package = ObLib.T BRANDED OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

CONST
  pkgname = &quot;PointProp&quot;;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.NameBind =&gt;
      WITH pn   = GetName (args, 1, self, opCode, loc),
           pv   = GetVal  (args, 2, self, opCode, loc),
           prop = pn.bind (pv) DO
        RETURN prop.proxy.obj;
      END;
    | Code.ValGetBeh =&gt;
      WITH pv = GetVal (args, 1, self, opCode, loc) DO
        RETURN pv.beh.proxy.obj;
      END;
    | Code.ValSetBeh =&gt;
      WITH pv  = GetVal (args, 1, self, opCode, loc),
           beh = GetBeh (args, 2, self, opCode, loc) DO
        pv.beh := beh;
        RETURN ObValue.valOk;
      END;
    | Code.ValGet =&gt;
      WITH pv = GetVal (args, 1, self, opCode, loc) DO
        TRY
          RETURN ObPoint3.M3ToObliq (pv.get ());
        EXCEPT
        | Prop.BadMethod =&gt;
          ObValue.RaiseException (ObProp.BadMethod, opCode.name, loc);
          RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
        END;
      END;
    | Code.ValValue =&gt;
      WITH pv   = GetVal (args, 1, self, opCode, loc),
           time = ObLongReal.GetArg (args, 2, self, opCode, loc) DO
        TRY
          RETURN ObPoint3.M3ToObliq (pv.value (time));
        EXCEPT
        | Prop.BadMethod =&gt;
          ObValue.RaiseException (ObProp.BadMethod, opCode.name, loc);
          RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
        END;
      END;
    | Code.NewConst =&gt;
      (*** AddValObj creates the actual Obliq object ***)
      WITH r   = ObPoint3.GetArg (args, 1, self, opCode, loc),
           val = PointProp.NewConst (r) DO
        RETURN val.proxy.obj;
      END;
    | Code.NewSync =&gt;
      WITH ah  = ObAnimHandle.GetT (args, 1, self, opCode, loc),
           r   = ObPoint3.GetArg (args, 2, self, opCode, loc),
           val = PointProp.NewSync (ah, r) DO
        RETURN val.proxy.obj;
      END;
    | Code.NewAsync =&gt;
      WITH beh = NEW (PointProp.AsyncBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        WITH val = PointProp.NewAsync (beh) DO
          RETURN val.proxy.obj;
        END;
      END;
    | Code.NewDep =&gt;
      WITH beh = NEW (PointProp.DepBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        WITH val = PointProp.NewDep (beh) DO
          RETURN val.proxy.obj;
        END;
      END;
    | Code.ConstBehSet =&gt;
      WITH beh = GetConstBeh (args, 1, self, opCode, loc),
           r   = ObPoint3.GetArg (args, 2, self, opCode, loc) DO
        beh.set (r);
        RETURN ObValue.valOk;
      END;
    | Code.NewConstBeh =&gt;
      WITH r   = ObPoint3.GetArg (args, 1, self, opCode, loc),
           beh = NEW (PointProp.ConstBeh).init (r) DO
        RETURN beh.proxy.obj;
      END;
    | Code.SyncBehAddRequest =&gt;
      WITH beh = GetSyncBeh (args, 1, self, opCode, loc),
           req = GetRequest (args, 2, self, opCode, loc) DO
        TRY
          beh.addRequest (req);
        EXCEPT
        | Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.SyncBehLinMoveTo =&gt;
      WITH beh   = GetSyncBeh (args, 1, self, opCode, loc),
           r     = ObPoint3.GetArg (args, 2, self, opCode, loc),
           start = ObReal.GetArg (args, 3, self, opCode, loc),
           dur   = ObReal.GetArg (args, 4, self, opCode, loc) DO
        TRY
          beh.linMoveTo (r, start, dur);
        EXCEPT
          Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.SyncBehLinMoveBy =&gt;
      WITH beh   = GetSyncBeh (args, 1, self, opCode, loc),
           r     = ObPoint3.GetArg (args, 2, self, opCode, loc),
           start = ObReal.GetArg (args, 3, self, opCode, loc),
           dur   = ObReal.GetArg (args, 4, self, opCode, loc) DO
        TRY
          beh.linMoveBy (r, start, dur);
        EXCEPT
          Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.NewSyncBeh =&gt;
      WITH ah  = ObAnimHandle.GetT (args, 1, self, opCode, loc),
           r   = ObPoint3.GetArg (args, 2, self, opCode, loc),
           beh = NEW (PointProp.SyncBeh).init (ah, r) DO
        RETURN beh.proxy.obj;
      END;
    | Code.NewAsyncBeh =&gt;
      WITH beh = NEW (PointProp.AsyncBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        RETURN obj;
      END;
    | Code.NewDepBeh =&gt;
      WITH beh = NEW (PointProp.DepBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        RETURN obj;
      END;
    | Code.NewRequest =&gt;
      WITH start = ObReal.GetArg (args, 1, self, opCode, loc),
           dur   = ObReal.GetArg (args, 2, self, opCode, loc),
           req   = NEW (PointProp.Request).init (start, dur),
           obj   = NARROW (req.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;value&quot;, args[3]);
        RETURN obj;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObPointProp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
