<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObPolygonGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObPolygonGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 19 14:00:00 PST 1994 by najork                   

<P><PRE>MODULE <module><implements><A HREF="ObPolygonGO.i3">ObPolygonGO</A></implements></module>;

IMPORT <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObPoint3.i3">ObPoint3</A>, <A HREF="ObShape.i3">ObShape</A>, <A HREF="ObSurfaceGO.i3">ObSurfaceGO</A>, <A HREF="ObPointProp.i3">ObPointProp</A>,
       <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/Point3.i3">Point3</A>, <A HREF="../../anim3D/src/PointProp.i3">PointProp</A>, <A HREF="../../anim3D/src/PolygonGO.i3">PolygonGO</A>,
       <A HREF="../../anim3D/src/PolygonGOProxy.i3">PolygonGOProxy</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;PolygonGO&quot;;
</PRE>***************************************************************************
 Wrapper for PolygonGO.T                                                   
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObSurfaceGO.T BRANDED &quot;ObPolygonGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (pgon : PolygonGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a PolygonGO.T&gt;&quot;, po := pgon) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      pgon.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,              1, Code.New),
            NewOpCode (&quot;NewWithShapeHint&quot;, 2, Code.NewWithShapeHint)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);

    (* DONT KNOW YET WHETHER TO INHIBIT TRANSMISSIONS ... *)

  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;PolygonGO.obl&quot;);
    TProto := loader.get (&quot;PolygonGO_TProto&quot;);

    (*** Register the proxy maker ***)
    PolygonGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {New, NewWithShapeHint};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="IsPointArray"><procedure>IsPointArray</procedure></A> (val : Obliq.Val) : BOOLEAN RAISES {ObValue.Error} =
  BEGIN
    FOR i := 0 TO Obliq.ArraySize (val) - 1 DO
      IF NOT ISTYPE (Obliq.ArrayGet (val, i), ObPoint3.T) THEN
        RETURN FALSE;
      END;
    END;
    RETURN TRUE;
  END IsPointArray;

PROCEDURE <A NAME="GetPointArray"><procedure>GetPointArray</procedure></A> (val : Obliq.Val) : REF ARRAY OF Point3.T
    RAISES {ObValue.Error} =
  BEGIN
    WITH size = Obliq.ArraySize (val),
         pts  = NEW (REF ARRAY OF Point3.T, size) DO
      FOR i := 0 TO size - 1 DO
        pts[i] := ObPoint3.ObliqToM3 (Obliq.ArrayGet (val, i));
      END;
      RETURN pts;
    END;
  END GetPointArray;

PROCEDURE <A NAME="GetPointPropValArray"><procedure>GetPointPropValArray</procedure></A> (val : Obliq.Val) : REF ARRAY OF PointProp.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH size = Obliq.ArraySize (val),
         pts  = NEW (REF ARRAY OF PointProp.Val, size) DO
      FOR i := 0 TO size - 1 DO
        pts[i] := ObPointProp.ObliqToM3 (Obliq.ArrayGet (val, i));
      END;
      RETURN pts;
    END;
  END GetPointPropValArray;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      IF IsPointArray (args[1]) THEN
        WITH pts = GetPointArray (args[1]),
             go  = PolygonGO.NewStatic (pts^) DO
          RETURN go.proxy.obj;
        END;
      ELSE
        WITH pts = GetPointPropValArray (args[1]),
             go  = PolygonGO.New (pts^) DO
          RETURN go.proxy.obj;
        END;
      END;
    | Code.NewWithShapeHint =&gt;
      IF IsPointArray (args[1]) THEN
        WITH pts = GetPointArray (args[1]),
             shp = ObShape.GetArg (args, 2, self, opCode, loc),
             go  = PolygonGO.NewStatic (pts^, shp) DO
          RETURN go.proxy.obj;
        END;
      ELSE
        WITH pts = GetPointPropValArray (args[1]),
             shp = ObShape.GetArg (args, 2, self, opCode, loc),
             go  = PolygonGO.New (pts^, shp) DO
          RETURN go.proxy.obj;
        END;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObPolygonGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
