<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObProp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObProp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sat May 28 17:58:15 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObProp.i3">ObProp</A></implements></module>;

IMPORT <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObReal.i3">ObReal</A>, <A HREF="ObProxiedObj.i3">ObProxiedObj</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>,
       <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/Prop.i3">Prop</A>, <A HREF="../../anim3D/src/PropProxy.i3">PropProxy</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;Prop&quot;;
</PRE>***************************************************************************
 Wrapper for Prop.T                                                        
***************************************************************************

<P><PRE>TYPE T = ObProxiedObj.T BRANDED &quot;ObProp.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (prop : Prop.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a Prop.T&gt;&quot;, po := prop) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      prop.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;

PROCEDURE <A NAME="GetT"><procedure>GetT</procedure></A> (args    : ObValue.ArgArray;
                idx     : INTEGER;
                package : ObLib.T;
                opCode  : ObLib.OpCode;
                loc     : SynLocation.T) : Prop.T
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
        T (node) =&gt; RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetT;
</PRE>***************************************************************************
 Wrapper for Prop.Name                                                     
***************************************************************************

<P>
<P><PRE>REVEAL <A NAME="Name">Name</A> = ObProxiedObj.T BRANDED &quot;ObProp.Name&quot; OBJECT END;

PROCEDURE <A NAME="GetName"><procedure>GetName</procedure></A> (args    : ObValue.ArgArray;
                   idx     : INTEGER;
                   package : ObLib.T;
                   opCode  : ObLib.OpCode;
                   loc     : SynLocation.T) : Prop.Name
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
        Name (node) =&gt; RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetName;

PROCEDURE <A NAME="NameToObliq"><procedure>NameToObliq</procedure></A> (pn : Prop.Name) : ObValue.Val =
  BEGIN
    IF pn.proxy = NIL THEN
      pn.makeProxy ();
    END;
    &lt;* ASSERT pn.proxy # NIL *&gt;
    RETURN pn.proxy.obj;
  END NameToObliq;
</PRE>***************************************************************************
 Wrapper for Prop.Val                                                      
***************************************************************************

<P>
<P><PRE>REVEAL <A NAME="Val">Val</A> = ObProxiedObj.T BRANDED &quot;ObProp.Val&quot; OBJECT END;
</PRE>***************************************************************************
 Wrapper for Prop.Beh                                                      
***************************************************************************

<P>
<P><PRE>REVEAL <A NAME="Beh">Beh</A> = ObProxiedObj.T BRANDED &quot;ObProp.Beh&quot; OBJECT END;
</PRE>***************************************************************************
 Wrapper for Prop.Request                                                  
***************************************************************************

<P>
<P><PRE>REVEAL <A NAME="Request">Request</A> = ObProxiedObj.T BRANDED &quot;ObProp.Request&quot; OBJECT END;

PROCEDURE <A NAME="GetRequest"><procedure>GetRequest</procedure></A> (args    : ObValue.ArgArray;
                      idx     : INTEGER;
                      package : ObLib.T;
                      opCode  : ObLib.OpCode;
                      loc     : SynLocation.T) : Prop.Request
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
        Request (node) =&gt; RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetRequest;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes := NEW (REF OpCodes, NUMBER (Code));
  BEGIN
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;BadMethod&quot;,   -1, Code.BadMethod),
            NewOpCode (&quot;BadInterval&quot;, -1, Code.BadInterval),
            NewOpCode (&quot;RequestStart&quot;, 1, Code.RequestStart),
            NewOpCode (&quot;RequestDur&quot;,   1, Code.RequestDur)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));

    BadMethod :=
        NEW (ObValue.ValException, name := pkgname &amp; &quot;_BadMethod&quot;);
    BadInterval :=
        NEW (ObValue.ValException, name := pkgname &amp; &quot;_BadInterval&quot;);

    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** retrieve the prototype ***)
    loader.load (&quot;Prop.obl&quot;);
    TProto := loader.get (&quot;Prop_TProto&quot;);

    (*** Register the proxy makers ***)
    PropProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {BadMethod, BadInterval, RequestStart, RequestDur};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.BadMethod =&gt;
      RETURN BadMethod;
    | Code.BadInterval =&gt;
      RETURN BadInterval;
    | Code.RequestStart =&gt;
      WITH req = GetRequest (args, 1, self, opCode, loc) DO
        RETURN ObReal.M3ToObliq (req.start);
      END;
    | Code.RequestDur =&gt;
      WITH req = GetRequest (args, 1, self, opCode, loc) DO
        RETURN ObReal.M3ToObliq (req.dur);
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObProp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
