<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObProtoLoader.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObProtoLoader.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Mon May 30 14:28:15 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObProtoLoader.i3">ObProtoLoader</A></implements></module>;

IMPORT <A HREF="../../bundleintf/src/Bundle.i3">Bundle</A>, <A HREF="../derived/ObLib3DBundle.i3">ObLib3DBundle</A>, <A HREF="../../obliq/src/ObLibOnline.i3">ObLibOnline</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../obliqparse/src/ObliqParser.i3">ObliqParser</A>,
       <A HREF="../../synex/src/SynScan.i3">SynScan</A>, <A HREF="../../synloc/src/SynWr.i3">SynWr</A>, <A HREF="../../synex/src/SynParse.i3">SynParse</A>, <A HREF="../../rw/src/Common/TextRd.i3">TextRd</A>;

REVEAL
  <A NAME="T">T</A> = Public BRANDED OBJECT
    env    : Obliq.Env;
    parser : SynParse.T;
    bundle : Bundle.T;
  OVERRIDES
    init := Init;
    load := Load;
    get  := Get;
  END;

PROCEDURE <A NAME="Init"><procedure>Init</procedure></A> (self : T) : T =
  BEGIN
    self.env    := Obliq.EmptyEnv ();
    self.parser := ObliqParser.New (SynWr.out);
    self.bundle := ObLib3DBundle.Get ();

    ObLibOnline.RegisterScanner (self.parser.Scanner ());

    RETURN self;
  END Init;

PROCEDURE <A NAME="Load"><procedure>Load</procedure></A> (self : T; name : TEXT) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH rd = TextRd.New (Bundle.Get (self.bundle, name)) DO
      ObliqParser.ReadFrom (self.parser, &quot;&quot;, rd, TRUE, TRUE);
    END;
    LOOP
      TRY
        SynScan.FirstPrompt (self.parser.Scanner());
        WITH phrase = ObliqParser.ParsePhrase (self.parser) DO
          EVAL ObliqParser.EvalPhrase (self.parser, phrase, self.env);
        END;
      EXCEPT
      | ObliqParser.Eof =&gt; RETURN;
      END;
    END;
  END Load;

PROCEDURE <A NAME="Get"><procedure>Get</procedure></A> (self : T; qualName : TEXT) : Obliq.Val =
  &lt;* FATAL ObliqParser.Eof, ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    ObliqParser.ReadFrom (self.parser, &quot;&quot;, TextRd.New (qualName &amp; &quot;;&quot;), TRUE);
    RETURN Obliq.EvalPhrase (ObliqParser.ParsePhrase (self.parser), self.env);
  END Get;

BEGIN
END ObProtoLoader.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
