<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObQuadMeshGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObQuadMeshGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 19 14:00:00 PST 1994 by najork                   

<P><PRE>MODULE <module><implements><A HREF="ObQuadMeshGO.i3">ObQuadMeshGO</A></implements></module>;

IMPORT <A HREF="../../color/src/Color.i3">Color</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="ObColor.i3">ObColor</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObInt.i3">ObInt</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObPoint3.i3">ObPoint3</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>,
       <A HREF="ObShape.i3">ObShape</A>, <A HREF="ObSurfaceGO.i3">ObSurfaceGO</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/Point3.i3">Point3</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../anim3D/src/QuadMeshGO.i3">QuadMeshGO</A>,
       <A HREF="../../anim3D/src/QuadMeshGOProxy.i3">QuadMeshGOProxy</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;QuadMeshGO&quot;;
</PRE>***************************************************************************
 Wrapper for QuadMeshGO.T                                                  
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObSurfaceGO.T BRANDED &quot;ObQuadMeshGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (qm : QuadMeshGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a QuadMeshGO.T&gt;&quot;, po := qm) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      qm.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;

PROCEDURE <A NAME="GetArg"><procedure>GetArg</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : QuadMeshGO.T
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
        T (node) =&gt; RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetArg;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name : TEXT; arity : INTEGER; code : Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;BadSize&quot;,         -1, Code.BadSize),
            NewOpCode (&quot;ColorsUndefined&quot;, -1, Code.ColorsUndefined),
            NewOpCode (&quot;New&quot;,              1, Code.New),
            NewOpCode (&quot;NewWithShapeHint&quot;, 2, Code.NewWithShapeHint),
            NewOpCode (&quot;AddFacetColors&quot;,   2, Code.AddFacetColors),
            NewOpCode (&quot;SetColorOfFacet&quot;,  4, Code.SetColorOfFacet)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    BadSize   :=
        NEW (ObValue.ValException, name := pkgname &amp; &quot;_BadSize&quot;);
    ColorsUndefined :=
        NEW (ObValue.ValException, name := pkgname &amp; &quot;_ColorsUndefined&quot;);

    (* DONT KNOW YET WHETHER TO INHIBIT TRANSMISSIONS ... *)

    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;QuadMeshGO.obl&quot;);
    TProto := loader.get (&quot;QuadMeshGO_TProto&quot;);

    (*** Register the proxy maker ***)
    QuadMeshGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {BadSize, ColorsUndefined,
          New, NewWithShapeHint,
          AddFacetColors, SetColorOfFacet};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

VAR
  BadSize         : ObValue.ValException;
  ColorsUndefined : ObValue.ValException;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.BadSize =&gt;
      RETURN BadSize;
    | Code.ColorsUndefined =&gt;
      RETURN ColorsUndefined;
    | Code.New =&gt;
      TRY
        WITH m = Obliq.ArraySize (args[1]),
             n = Obliq.ArraySize (Obliq.ArrayGet (args[1], 0)),
             points = NEW (REF ARRAY OF ARRAY OF Point3.T, m, n) DO
          FOR i := 0 TO m - 1 DO
            WITH slice = Obliq.ArrayGet (args[1], i) DO
              FOR j := 0 TO n - 1 DO
                points[i][j] := ObPoint3.ObliqToM3 (Obliq.ArrayGet (slice, j));
              END;
            END;
          END;
          WITH qm = NEW (QuadMeshGO.T).init (points^) DO
            RETURN qm.proxy.obj;
          END;
        END;
      EXCEPT
      | ObValue.Error =&gt;
        ObValue.BadArgType(1, &quot;[m*[n*Point3]]&quot;, self.name, opCode.name, loc);
        RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
      END;
    | Code.NewWithShapeHint =&gt;
      TRY
        WITH m = Obliq.ArraySize (args[1]),
             n = Obliq.ArraySize (Obliq.ArrayGet (args[1], 0)),
             points = NEW (REF ARRAY OF ARRAY OF Point3.T, m, n) DO
          FOR i := 0 TO m - 1 DO
            WITH slice = Obliq.ArrayGet (args[1], i) DO
              FOR j := 0 TO n - 1 DO
                points[i][j] := ObPoint3.ObliqToM3 (Obliq.ArrayGet (slice, j));
              END;
            END;
          END;
          WITH shape = ObShape.GetArg (args, 2, self, opCode, loc),
               qm    = NEW (QuadMeshGO.T).init (points^, shape) DO
            RETURN qm.proxy.obj;
          END;
        END;
      EXCEPT
      | ObValue.Error =&gt;
        ObValue.BadArgType(1, &quot;[m*[n*Point3]]&quot;, self.name, opCode.name, loc);
        RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
      END;
    | Code.AddFacetColors =&gt;
      TRY
        WITH qm = GetArg (args, 1, self, opCode, loc),
             m  = Obliq.ArraySize (args[1]),
             n  = Obliq.ArraySize (Obliq.ArrayGet (args[1], 0)),
             colors = NEW (REF ARRAY OF ARRAY OF Color.T, m, n) DO
          FOR i := 0 TO m - 1 DO
            WITH slice = Obliq.ArrayGet (args[1], i) DO
              FOR j := 0 TO n - 1 DO
                colors[i][j] := ObColor.ObliqToM3 (Obliq.ArrayGet (slice, j));
              END;
            END;
          END;
          qm.addFacetColors (colors^);
          RETURN ObValue.valOk;
        END;
      EXCEPT
      | ObValue.Error =&gt;
        ObValue.BadArgType(1, &quot;[m*[n*Color]]&quot;, self.name, opCode.name, loc);
        RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
      | QuadMeshGO.BadSize =&gt;
        ObValue.RaiseException (BadSize, self.name &amp; &quot;_&quot; &amp; opCode.name, loc);
        RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
      END;
    | Code.SetColorOfFacet =&gt;
      WITH quadmesh = GetArg         (args, 1, self, opCode, loc),
           i        = ObInt.GetArg   (args, 2, self, opCode, loc),
           j        = ObInt.GetArg   (args, 3, self, opCode, loc),
           color    = ObColor.GetArg (args, 4, self, opCode, loc) DO
        TRY
          quadmesh.setColorOfFacet (i, j, color);
          RETURN ObValue.valOk;
        EXCEPT
        | QuadMeshGO.ColorsUndefined =&gt;
          ObValue.RaiseException (ColorsUndefined,
                                  self.name &amp; &quot;_&quot; &amp; opCode.name, loc);
          RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
        END;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObQuadMeshGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
