<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObRasterModeProp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObRasterModeProp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Mon May 30 09:59:32 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObRasterModeProp.i3">ObRasterModeProp</A></implements></module>;

IMPORT <A HREF="ObAnimHandle.i3">ObAnimHandle</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObLongReal.i3">ObLongReal</A>, <A HREF="ObProp.i3">ObProp</A>,
       <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObReal.i3">ObReal</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/Prop.i3">Prop</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>,
       <A HREF="../../anim3D/src/RasterModeProp.i3">RasterModeProp</A>, <A HREF="../../anim3D/src/RasterModePropProxy.i3">RasterModePropProxy</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>, <A HREF="../../text/src/Text.i3">Text</A>;
</PRE>***************************************************************************
 Wrapper for RasterModeProp.Kind                                           
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="NewKind"><procedure>NewKind</procedure></A> (kind : RasterModeProp.Kind) : ObValue.Val =
  BEGIN
    CASE kind OF
    | RasterModeProp.Kind.Hollow =&gt; RETURN Obliq.NewText (&quot;Hollow&quot;);
    | RasterModeProp.Kind.Solid  =&gt; RETURN Obliq.NewText (&quot;Solid&quot;);
    | RasterModeProp.Kind.Empty  =&gt; RETURN Obliq.NewText (&quot;Empty&quot;);
    END;
  END NewKind;

EXCEPTION BadKind(TEXT);

PROCEDURE <A NAME="KindToM3"><procedure>KindToM3</procedure></A> (val : ObValue.Val) : RasterModeProp.Kind
    RAISES {BadKind} =
  BEGIN
    TYPECASE val OF
    | ObValue.ValText (node) =&gt;
      IF Text.Equal (node.text, &quot;Hollow&quot;) THEN
        RETURN RasterModeProp.Kind.Hollow;
      ELSIF Text.Equal (node.text, &quot;Solid&quot;) THEN
        RETURN RasterModeProp.Kind.Solid;
      ELSIF Text.Equal (node.text, &quot;Empty&quot;) THEN
        RETURN RasterModeProp.Kind.Empty;
      ELSE
        RAISE BadKind(&quot;Unknown RasterMode&quot;);
      END;
    ELSE
      RAISE BadKind(&quot;RasterMode must be a Text&quot;);
    END;
  END KindToM3;

PROCEDURE <A NAME="GetKind"><procedure>GetKind</procedure></A> (args    : ObValue.ArgArray;
                   idx     : INTEGER;
                   package : ObLib.T;
                   opCode  : ObLib.OpCode;
                   loc     : SynLocation.T) : RasterModeProp.Kind
    RAISES {ObValue.Error} =
  BEGIN
    TRY
      RETURN KindToM3 (args[idx]);
    EXCEPT
    | BadKind =&gt;
      ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
      RETURN RasterModeProp.Kind.Solid; (* to suppress compiler warning *)
    END;
  END GetKind;
</PRE>***************************************************************************
 Wrapper for RasterModeProp.Name                                           
***************************************************************************

<P><PRE>TYPE
  Name = ObProp.Name BRANDED &quot;ObRasterModeProp.Name&quot; OBJECT END;

PROCEDURE <A NAME="AddNameObj"><procedure>AddNameObj</procedure></A> (pn : RasterModeProp.Name) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {NameProto}),
         raw = NEW (Name, what := &quot;&lt;a RasterModeProp.Name&gt;&quot;, po := pn) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      pn.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddNameObj;

PROCEDURE <A NAME="GetName"><procedure>GetName</procedure></A> (args    : ObValue.ArgArray;
                   idx     : INTEGER;
                   package : ObLib.T;
                   opCode  : ObLib.OpCode;
                   loc     : SynLocation.T) : RasterModeProp.Name
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Name (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetName;
</PRE>***************************************************************************
 Wrapper for RasterModeProp.Val                                            
***************************************************************************

<P>
<P><PRE>TYPE
  Val = ObProp.Val BRANDED &quot;ObRasterModeProp.Val&quot; OBJECT END;

PROCEDURE <A NAME="AddValObj"><procedure>AddValObj</procedure></A> (pv : RasterModeProp.Val) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {ValProto}),
         raw = NEW (Val, what := &quot;&lt;a RasterModeProp.Val&gt;&quot;, po := pv) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      pv.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddValObj;

PROCEDURE <A NAME="GetVal"><procedure>GetVal</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : RasterModeProp.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Val (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetVal;

PROCEDURE <A NAME="GetOverloadedVal"><procedure>GetOverloadedVal</procedure></A> (args    : ObValue.ArgArray;
                            idx     : INTEGER;
                            package : ObLib.T;
                            opCode  : ObLib.OpCode;
                            loc     : SynLocation.T) : RasterModeProp.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    TYPECASE args[idx] OF
    | ObValue.ValText (node) =&gt;
      IF Text.Equal (node.text, &quot;Hollow&quot;) THEN
        RETURN RasterModeProp.NewConst (RasterModeProp.Kind.Hollow);
      ELSIF Text.Equal (node.text, &quot;Solid&quot;) THEN
        RETURN RasterModeProp.NewConst (RasterModeProp.Kind.Solid);
      ELSIF Text.Equal (node.text, &quot;Empty&quot;) THEN
        RETURN RasterModeProp.NewConst (RasterModeProp.Kind.Empty);
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    | ObValue.ValObj =&gt;
      WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
        TYPECASE raw OF
        | Val (node) =&gt;
          RETURN node.po;
        ELSE
          ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
          RETURN NIL;      (* ... only to suppress compiler warning *)
        END;
      END;
    ELSE
      ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
      RETURN NIL;   (* ... only to suppress compiler warning *)
    END;
  END GetOverloadedVal;
</PRE>***************************************************************************
 Wrapper for RasterModeProp.Beh                                            
***************************************************************************

<P><PRE>TYPE
  Beh = ObProp.Beh BRANDED &quot;ObRasterModeProp.Beh&quot; OBJECT END;

PROCEDURE <A NAME="GetBeh"><procedure>GetBeh</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : RasterModeProp.Beh
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Beh (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetBeh;
</PRE>***************************************************************************
 Wrapper for RasterModeProp.ConstBeh                                       
***************************************************************************

<P>
<P><PRE>TYPE
  ConstBeh = Beh BRANDED &quot;ObRasterModeProp.ConstBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddConstBehObj"><procedure>AddConstBehObj</procedure></A> (beh : RasterModeProp.ConstBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {ConstBehProto}),
         raw = NEW (ConstBeh, what := &quot;&lt;a RasterModeProp.ConstBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddConstBehObj;

PROCEDURE <A NAME="GetConstBeh"><procedure>GetConstBeh</procedure></A> (args    : ObValue.ArgArray;
                       idx     : INTEGER;
                       package : ObLib.T;
                       opCode  : ObLib.OpCode;
                       loc     : SynLocation.T) : RasterModeProp.ConstBeh
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | ConstBeh (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetConstBeh;
</PRE>***************************************************************************
 Wrapper for RasterModeProp.SyncBeh                                        
***************************************************************************

<P>
<P><PRE>TYPE
  SyncBeh = Beh BRANDED &quot;ObRasterModeProp.SyncBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddSyncBehObj"><procedure>AddSyncBehObj</procedure></A> (beh : RasterModeProp.SyncBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {SyncBehProto}),
         raw = NEW (SyncBeh, what := &quot;&lt;a RasterModeProp.SyncBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddSyncBehObj;

PROCEDURE <A NAME="GetSyncBeh"><procedure>GetSyncBeh</procedure></A> (args    : ObValue.ArgArray;
                       idx     : INTEGER;
                       package : ObLib.T;
                       opCode  : ObLib.OpCode;
                       loc     : SynLocation.T) : RasterModeProp.SyncBeh
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | SyncBeh (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetSyncBeh;
</PRE>***************************************************************************
 Wrapper for RasterModeProp.AsyncBeh                                       
***************************************************************************

<P>
<P><PRE>TYPE
  AsyncBeh = Beh BRANDED &quot;ObRasterModeProp.AsyncBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddAsyncBehObj"><procedure>AddAsyncBehObj</procedure></A> (beh : RasterModeProp.AsyncBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {AsyncBehProto}),
         raw = NEW (AsyncBeh, what := &quot;&lt;a RasterModeProp.AsyncBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (AsyncBehProxy, obj := obj);
    END;
  END AddAsyncBehObj;

TYPE
  AsyncBehProxy = RasterModePropProxy.AsyncBehProxy BRANDED OBJECT
  OVERRIDES
    compute := AsyncBehCompute;
  END;

PROCEDURE <A NAME="AsyncBehCompute"><procedure>AsyncBehCompute</procedure></A> (proxy : AsyncBehProxy;
                           time  : LONGREAL) : RasterModeProp.Kind
    RAISES {Prop.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {Obliq.NewReal (time)},
           obj  = NARROW (proxy.obj, Obliq.Val),
           res  = Obliq.ObjectInvoke (obj, &quot;compute&quot;, args) DO
        RETURN KindToM3 (res);
      END;
    EXCEPT
    | BadKind (msg) =&gt;
      RAISE Prop.BadMethod (msg);
    | ObValue.Error (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END AsyncBehCompute;
</PRE>***************************************************************************
 Wrapper for RasterModeProp.DepBeh                                         
***************************************************************************

<P>
<P><PRE>TYPE
  DepBeh = Beh BRANDED &quot;ObRasterModeProp.DepBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddDepBehObj"><procedure>AddDepBehObj</procedure></A> (beh : RasterModeProp.DepBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {DepBehProto}),
         raw = NEW (DepBeh, what := &quot;&lt;a RasterModeProp.DepBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (DepBehProxy, obj := obj);
    END;
  END AddDepBehObj;

TYPE
  DepBehProxy = RasterModePropProxy.DepBehProxy BRANDED OBJECT
  OVERRIDES
    compute := DepBehCompute;
  END;

PROCEDURE <A NAME="DepBehCompute"><procedure>DepBehCompute</procedure></A> (proxy : DepBehProxy;
                         time  : LONGREAL) : RasterModeProp.Kind
    RAISES {Prop.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {Obliq.NewReal (time)},
           obj  = NARROW (proxy.obj, Obliq.Val),
           res  = Obliq.ObjectInvoke (obj, &quot;compute&quot;, args) DO
        RETURN KindToM3 (res);
      END;
    EXCEPT
    | BadKind (msg) =&gt;
      RAISE Prop.BadMethod (msg);
    | ObValue.Error (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END DepBehCompute;
</PRE>***************************************************************************
 Wrapper for RasterModeProp.Request                                        
***************************************************************************

<P>
<P><PRE>TYPE
  Request = ObProp.Request BRANDED &quot;ObRasterModeProp.Request&quot; OBJECT END;

PROCEDURE <A NAME="AddRequestObj"><procedure>AddRequestObj</procedure></A> (req : RasterModeProp.Request) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {RequestProto}),
         raw = NEW (Request, what := &quot;&lt;a RasterModeProp.Request&gt;&quot;, po := req) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      req.proxy := NEW (RequestProxy, obj := obj);
    END;
  END AddRequestObj;

PROCEDURE <A NAME="GetRequest"><procedure>GetRequest</procedure></A> (args    : ObValue.ArgArray;
                      idx     : INTEGER;
                      package : ObLib.T;
                      opCode  : ObLib.OpCode;
                      loc     : SynLocation.T) : RasterModeProp.Request
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Request (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetRequest;

TYPE
  RequestProxy = RasterModePropProxy.RequestProxy BRANDED OBJECT
  OVERRIDES
    value := RequestValue;
  END;

PROCEDURE <A NAME="RequestValue"><procedure>RequestValue</procedure></A> (proxy    : RequestProxy;
                        startval : RasterModeProp.Kind;
                        reltime  : REAL) : RasterModeProp.Kind
    RAISES {Prop.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {NewKind (startval), ObReal.M3ToObliq (reltime)},
           obj  = NARROW (proxy.obj, Obliq.Val),
           res  = Obliq.ObjectInvoke (obj, &quot;value&quot;, args) DO
        RETURN KindToM3 (res);
      END;
    EXCEPT
    | BadKind (msg) =&gt;
      RAISE Prop.BadMethod (msg);
    | ObValue.Error (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END RequestValue;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes := NEW (REF OpCodes, NUMBER (Code));
  BEGIN
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;NameBind&quot;,           2, Code.NameBind),
            NewOpCode (&quot;ValGetBeh&quot;,          1, Code.ValGetBeh),
            NewOpCode (&quot;ValSetBeh&quot;,          2, Code.ValSetBeh),
            NewOpCode (&quot;ValGet&quot;,             1, Code.ValGet),
            NewOpCode (&quot;ValValue&quot;,           2, Code.ValValue),
            NewOpCode (&quot;NewConst&quot;,           1, Code.NewConst),
            NewOpCode (&quot;NewSync&quot;,            2, Code.NewSync),
            NewOpCode (&quot;NewAsync&quot;,           1, Code.NewAsync),
            NewOpCode (&quot;NewDep&quot;,             1, Code.NewDep),
            NewOpCode (&quot;ConstBehSet&quot;,        2, Code.ConstBehSet),
            NewOpCode (&quot;NewConstBeh&quot;,        1, Code.NewConstBeh),
            NewOpCode (&quot;SyncBehAddRequest&quot;,  2, Code.SyncBehAddRequest),
            NewOpCode (&quot;SyncBehChange&quot;,      3, Code.SyncBehChange),
            NewOpCode (&quot;NewSyncBeh&quot;,         2, Code.NewSyncBeh),
            NewOpCode (&quot;NewAsyncBeh&quot;,        1, Code.NewAsyncBeh),
            NewOpCode (&quot;NewDepBeh&quot;,          1, Code.NewDepBeh),
            NewOpCode (&quot;NewRequest&quot;,         3, Code.NewRequest)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  NameProto     : ObValue.Val;
  ValProto      : ObValue.Val;
  ConstBehProto : ObValue.Val;
  SyncBehProto  : ObValue.Val;
  AsyncBehProto : ObValue.Val;
  DepBehProto   : ObValue.Val;
  RequestProto  : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** retrieve the prototypes ***)
    loader.load (&quot;RasterModeProp.obl&quot;);
    NameProto     := loader.get (&quot;RasterModeProp_NameProto&quot;);
    ValProto      := loader.get (&quot;RasterModeProp_ValProto&quot;);
    ConstBehProto := loader.get (&quot;RasterModeProp_ConstBehProto&quot;);
    SyncBehProto  := loader.get (&quot;RasterModeProp_SyncBehProto&quot;);
    AsyncBehProto := loader.get (&quot;RasterModeProp_AsyncBehProto&quot;);
    DepBehProto   := loader.get (&quot;RasterModeProp_DepBehProto&quot;);
    RequestProto  := loader.get (&quot;RasterModeProp_RequestProto&quot;);

    (*** Register the proxy makers ***)
    RasterModePropProxy.NamePM     := AddNameObj;
    RasterModePropProxy.ValPM      := AddValObj;
    RasterModePropProxy.ConstBehPM := AddConstBehObj;
    RasterModePropProxy.SyncBehPM  := AddSyncBehObj;
    RasterModePropProxy.AsyncBehPM := AddAsyncBehObj;
    RasterModePropProxy.DepBehPM   := AddDepBehObj;
    RasterModePropProxy.RequestPM  := AddRequestObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {NameBind,
          ValGetBeh, ValSetBeh, ValGet, ValValue,
             NewConst, NewSync, NewAsync, NewDep,
          ConstBehSet, NewConstBeh,
          SyncBehAddRequest, SyncBehChange, NewSyncBeh,
          NewAsyncBeh,
          NewDepBeh,
          NewRequest};

  OpCode = ObLib.OpCode BRANDED OBJECT
    code: Code;
  END;

  Package = ObLib.T BRANDED OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

CONST
  pkgname = &quot;RasterModeProp&quot;;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.NameBind =&gt;
      WITH pn   = GetName (args, 1, self, opCode, loc),
           pv   = GetVal  (args, 2, self, opCode, loc),
           prop = pn.bind (pv) DO
        RETURN prop.proxy.obj;
      END;
    | Code.ValGetBeh =&gt;
      WITH pv = GetVal (args, 1, self, opCode, loc) DO
        RETURN pv.beh.proxy.obj;
      END;
    | Code.ValSetBeh =&gt;
      WITH pv  = GetVal (args, 1, self, opCode, loc),
           beh = GetBeh (args, 2, self, opCode, loc) DO
        pv.beh := beh;
        RETURN ObValue.valOk;
      END;
    | Code.ValGet =&gt;
      WITH pv = GetVal (args, 1, self, opCode, loc) DO
        TRY
          RETURN NewKind (pv.get ());
        EXCEPT
        | Prop.BadMethod =&gt;
          ObValue.RaiseException (ObProp.BadMethod, opCode.name, loc);
          RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
        END;
      END;
    | Code.ValValue =&gt;
      WITH pv   = GetVal (args, 1, self, opCode, loc),
           time = ObLongReal.GetArg (args, 2, self, opCode, loc) DO
        TRY
          RETURN NewKind (pv.value (time));
        EXCEPT
        | Prop.BadMethod =&gt;
          ObValue.RaiseException (ObProp.BadMethod, opCode.name, loc);
          RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
        END;
      END;
    | Code.NewConst =&gt;
      (*** AddValObj creates the actual Obliq object ***)
      WITH lt  = GetKind (args, 1, self, opCode, loc),
           val = RasterModeProp.NewConst (lt) DO
        RETURN val.proxy.obj;
      END;
    | Code.NewSync =&gt;
      WITH ah  = ObAnimHandle.GetT (args, 1, self, opCode, loc),
           lt  = GetKind (args, 2, self, opCode, loc),
           val = RasterModeProp.NewSync (ah, lt) DO
        RETURN val.proxy.obj;
      END;
    | Code.NewAsync =&gt;
      WITH beh = NEW (RasterModeProp.AsyncBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        WITH val = RasterModeProp.NewAsync (beh) DO
          RETURN val.proxy.obj;
        END;
      END;
    | Code.NewDep =&gt;
      WITH beh = NEW (RasterModeProp.DepBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        WITH val = RasterModeProp.NewDep (beh) DO
          RETURN val.proxy.obj;
        END;
      END;
    | Code.ConstBehSet =&gt;
      WITH beh = GetConstBeh (args, 1, self, opCode, loc),
           lt  = GetKind     (args, 2, self, opCode, loc) DO
        beh.set (lt);
        RETURN ObValue.valOk;
      END;
    | Code.NewConstBeh =&gt;
      WITH lt    = GetKind (args, 1, self, opCode, loc),
           beh   = NEW (RasterModeProp.ConstBeh).init (lt) DO
        RETURN beh.proxy.obj;
      END;
    | Code.SyncBehAddRequest =&gt;
      WITH beh = GetSyncBeh (args, 1, self, opCode, loc),
           req = GetRequest (args, 2, self, opCode, loc) DO
        TRY
          beh.addRequest (req);
        EXCEPT
        | Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.SyncBehChange =&gt;
      WITH beh   = GetSyncBeh    (args, 1, self, opCode, loc),
           lt    = GetKind       (args, 2, self, opCode, loc),
           start = ObReal.GetArg (args, 3, self, opCode, loc) DO
        TRY
          beh.change (lt, start);
        EXCEPT
          Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.NewSyncBeh =&gt;
      WITH ah    = ObAnimHandle.GetT (args, 1, self, opCode, loc),
           lt    = GetKind           (args, 2, self, opCode, loc),
           beh   = NEW (RasterModeProp.SyncBeh).init (ah, lt) DO
        RETURN beh.proxy.obj;
      END;
    | Code.NewAsyncBeh =&gt;
      WITH beh = NEW (RasterModeProp.AsyncBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        RETURN obj;
      END;
    | Code.NewDepBeh =&gt;
      WITH beh   = NEW (RasterModeProp.DepBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        RETURN obj;
      END;
    | Code.NewRequest =&gt;
      WITH start = ObReal.GetArg (args, 1, self, opCode, loc),
           dur   = ObReal.GetArg (args, 2, self, opCode, loc),
           req   = NEW (RasterModeProp.Request).init (start, dur),
           obj   = NARROW (req.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;value&quot;, args[3]);
        RETURN obj;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObRasterModeProp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
