<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObReal.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObReal.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM>                                                                           </EM></BLOCKQUOTE><PRE>
</PRE>       Created on Tue Jan 20 14:00:00 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObReal.i3">ObReal</A></implements></module>;

IMPORT <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

PROCEDURE <A NAME="M3ToObliq"><procedure>M3ToObliq</procedure></A> (val : REAL) : ObValue.Val =
  BEGIN
    RETURN NEW (ObValue.ValReal, real := FLOAT (val, LONGREAL));
  END M3ToObliq;

PROCEDURE <A NAME="ObliqToM3"><procedure>ObliqToM3</procedure></A> (val : ObValue.Val) : REAL RAISES {ObValue.Error} =
  BEGIN
    TYPECASE val OF
    | ObValue.ValReal (node) =&gt; RETURN FLOAT (node.real);
    | ObValue.ValInt  (node) =&gt; RETURN FLOAT (node.int);
    ELSE
      Obliq.RaiseError (&quot;Expected Real or Int&quot;);
      RETURN 0.0;          (* ... only to suppress compiler warning *)
    END;
  END ObliqToM3;

PROCEDURE <A NAME="GetArg"><procedure>GetArg</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : REAL RAISES {ObValue.Error} =
  BEGIN
    TYPECASE args[idx] OF
    | ObValue.ValReal (node) =&gt; RETURN FLOAT (node.real);
    | ObValue.ValInt  (node) =&gt; RETURN FLOAT (node.int);
    ELSE
      ObValue.BadArgType (idx, &quot;real&quot;, package.name, opCode.name, loc);
      RETURN 0.0;           (* ... only to suppress compiler warning *)
    END;
  END GetArg;

BEGIN
END ObReal.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
