<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObRealProp.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObRealProp.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sat May 28 11:15:36 PDT 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObRealProp.i3">ObRealProp</A></implements></module>;

IMPORT <A HREF="ObAnimHandle.i3">ObAnimHandle</A>, <A HREF="ObAux.i3">ObAux</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObLongReal.i3">ObLongReal</A>, <A HREF="ObProp.i3">ObProp</A>,
       <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObReal.i3">ObReal</A>, <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/Prop.i3">Prop</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../anim3D/src/RealProp.i3">RealProp</A>,
       <A HREF="../../anim3D/src/RealPropProxy.i3">RealPropProxy</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;
</PRE>***************************************************************************
 Wrapper for RealProp.Name                                                 
***************************************************************************

<P><PRE>TYPE
  Name = ObProp.Name BRANDED &quot;ObRealProp.Name&quot; OBJECT END;

PROCEDURE <A NAME="AddNameObj"><procedure>AddNameObj</procedure></A> (pn : RealProp.Name) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {NameProto}),
         raw = NEW (Name, what := &quot;&lt;a RealProp.Name&gt;&quot;, po := pn) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      pn.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddNameObj;

PROCEDURE <A NAME="GetName"><procedure>GetName</procedure></A> (args    : ObValue.ArgArray;
                   idx     : INTEGER;
                   package : ObLib.T;
                   opCode  : ObLib.OpCode;
                   loc     : SynLocation.T) : RealProp.Name
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Name (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetName;
</PRE>***************************************************************************
 Wrapper for RealProp.Val                                                  
***************************************************************************

<P>
<P><PRE>TYPE
  Val = ObProp.Val BRANDED &quot;ObRealProp.Val&quot; OBJECT END;

PROCEDURE <A NAME="AddValObj"><procedure>AddValObj</procedure></A> (pv : RealProp.Val) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {ValProto}),
         raw = NEW (Val, what := &quot;&lt;a RealProp.Val&gt;&quot;, po := pv) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      pv.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddValObj;

PROCEDURE <A NAME="GetVal"><procedure>GetVal</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : RealProp.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Val (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetVal;

PROCEDURE <A NAME="GetOverloadedVal"><procedure>GetOverloadedVal</procedure></A> (args    : ObValue.ArgArray;
                            idx     : INTEGER;
                            package : ObLib.T;
                            opCode  : ObLib.OpCode;
                            loc     : SynLocation.T) : RealProp.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    TYPECASE args[idx] OF
    | ObValue.ValReal (node) =&gt; RETURN RealProp.NewConst (FLOAT (node.real));
    | ObValue.ValInt  (node) =&gt; RETURN RealProp.NewConst (FLOAT (node.int));
    | ObValue.ValObj =&gt;
      WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
        TYPECASE raw OF
        | Val (node) =&gt;
          RETURN node.po;
        ELSE
          ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
          RETURN NIL;      (* ... only to suppress compiler warning *)
        END;
      END;
    ELSE
      ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
      RETURN NIL;   (* ... only to suppress compiler warning *)
    END;
  END GetOverloadedVal;
</PRE>***************************************************************************
 Wrapper for RealProp.Beh                                                  
***************************************************************************

<P><PRE>TYPE
  Beh = ObProp.Beh BRANDED &quot;ObRealProp.Beh&quot; OBJECT END;

PROCEDURE <A NAME="GetBeh"><procedure>GetBeh</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : RealProp.Beh
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Beh (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetBeh;
</PRE>***************************************************************************
 Wrapper for RealProp.ConstBeh                                             
***************************************************************************

<P>
<P><PRE>TYPE
  ConstBeh = Beh BRANDED &quot;ObRealProp.ConstBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddConstBehObj"><procedure>AddConstBehObj</procedure></A> (beh : RealProp.ConstBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {ConstBehProto}),
         raw = NEW (ConstBeh, what := &quot;&lt;a RealProp.ConstBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddConstBehObj;

PROCEDURE <A NAME="GetConstBeh"><procedure>GetConstBeh</procedure></A> (args    : ObValue.ArgArray;
                       idx     : INTEGER;
                       package : ObLib.T;
                       opCode  : ObLib.OpCode;
                       loc     : SynLocation.T) : RealProp.ConstBeh
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | ConstBeh (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetConstBeh;
</PRE>***************************************************************************
 Wrapper for RealProp.SyncBeh                                              
***************************************************************************

<P>
<P><PRE>TYPE
  SyncBeh = Beh BRANDED &quot;ObRealProp.SyncBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddSyncBehObj"><procedure>AddSyncBehObj</procedure></A> (beh : RealProp.SyncBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {SyncBehProto}),
         raw = NEW (SyncBeh, what := &quot;&lt;a RealProp.SyncBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddSyncBehObj;

PROCEDURE <A NAME="GetSyncBeh"><procedure>GetSyncBeh</procedure></A> (args    : ObValue.ArgArray;
                       idx     : INTEGER;
                       package : ObLib.T;
                       opCode  : ObLib.OpCode;
                       loc     : SynLocation.T) : RealProp.SyncBeh
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | SyncBeh (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetSyncBeh;
</PRE>***************************************************************************
 Wrapper for RealProp.AsyncBeh                                             
***************************************************************************

<P>
<P><PRE>TYPE
  AsyncBeh = Beh BRANDED &quot;ObRealProp.AsyncBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddAsyncBehObj"><procedure>AddAsyncBehObj</procedure></A> (beh : RealProp.AsyncBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {AsyncBehProto}),
         raw = NEW (AsyncBeh, what := &quot;&lt;a RealProp.AsyncBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (AsyncBehProxy, obj := obj);
    END;
  END AddAsyncBehObj;

TYPE
  AsyncBehProxy = RealPropProxy.AsyncBehProxy BRANDED OBJECT
  OVERRIDES
    compute := AsyncBehCompute;
  END;

PROCEDURE <A NAME="AsyncBehCompute"><procedure>AsyncBehCompute</procedure></A> (proxy : AsyncBehProxy; time : LONGREAL) : REAL
    RAISES {Prop.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {Obliq.NewReal (time)},
           obj  = NARROW (proxy.obj, Obliq.Val),
           res  = Obliq.ObjectInvoke (obj, &quot;compute&quot;, args) DO
        RETURN ObReal.ObliqToM3 (res);
      END;
    EXCEPT
    | ObValue.Error (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END AsyncBehCompute;
</PRE>***************************************************************************
 Wrapper for RealProp.DepBeh                                               
***************************************************************************

<P>
<P><PRE>TYPE
  DepBeh = Beh BRANDED &quot;ObRealProp.DepBeh&quot; OBJECT END;

PROCEDURE <A NAME="AddDepBehObj"><procedure>AddDepBehObj</procedure></A> (beh : RealProp.DepBeh) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {DepBehProto}),
         raw = NEW (DepBeh, what := &quot;&lt;a RealProp.DepBeh&gt;&quot;, po := beh) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      beh.proxy := NEW (DepBehProxy, obj := obj);
    END;
  END AddDepBehObj;

TYPE
  DepBehProxy = RealPropProxy.DepBehProxy BRANDED OBJECT
  OVERRIDES
    compute := DepBehCompute;
  END;

PROCEDURE <A NAME="DepBehCompute"><procedure>DepBehCompute</procedure></A> (proxy : DepBehProxy; time : LONGREAL) : REAL
    RAISES {Prop.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {Obliq.NewReal (time)},
           obj  = NARROW (proxy.obj, Obliq.Val),
           res  = Obliq.ObjectInvoke (obj, &quot;compute&quot;, args) DO
        RETURN FLOAT (ObReal.ObliqToM3 (res));
      END;
    EXCEPT
    | ObValue.Error (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END DepBehCompute;
</PRE>***************************************************************************
 Wrapper for RealProp.Request                                              
***************************************************************************

<P>
<P><PRE>TYPE
  Request = ObProp.Request BRANDED &quot;ObRealProp.Request&quot; OBJECT END;

PROCEDURE <A NAME="AddRequestObj"><procedure>AddRequestObj</procedure></A> (req : RealProp.Request) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {RequestProto}),
         raw = NEW (Request, what := &quot;&lt;a RealProp.Request&gt;&quot;, po := req) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      req.proxy := NEW (RequestProxy, obj := obj);
    END;
  END AddRequestObj;

PROCEDURE <A NAME="GetRequest"><procedure>GetRequest</procedure></A> (args    : ObValue.ArgArray;
                      idx     : INTEGER;
                      package : ObLib.T;
                      opCode  : ObLib.OpCode;
                      loc     : SynLocation.T) : RealProp.Request
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | Request (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetRequest;

TYPE
  RequestProxy = RealPropProxy.RequestProxy BRANDED OBJECT
  OVERRIDES
    value := RequestValue;
  END;

PROCEDURE <A NAME="RequestValue"><procedure>RequestValue</procedure></A> (proxy    : RequestProxy;
                        startval : REAL;
                        reltime  : REAL) : REAL
    RAISES {Prop.BadMethod} =
  BEGIN
    TRY
      WITH args = Obliq.Vals {ObReal.M3ToObliq (startval),
                              ObReal.M3ToObliq (reltime)},
           obj  = NARROW (proxy.obj, Obliq.Val),
           res  = Obliq.ObjectInvoke (obj, &quot;value&quot;, args) DO
        RETURN FLOAT (ObReal.ObliqToM3 (res));
      END;
    EXCEPT
    | ObValue.Error (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ErrorToText (packet));
    | ObValue.Exception (packet) =&gt;
      RAISE Prop.BadMethod (ObAux.ExceptionToText (packet));
    END;
  END RequestValue;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name: TEXT; arity: INTEGER; code: Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes := NEW (REF OpCodes, NUMBER (Code));
  BEGIN
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;NameBind&quot;,           2, Code.NameBind),
            NewOpCode (&quot;ValGetBeh&quot;,          1, Code.ValGetBeh),
            NewOpCode (&quot;ValSetBeh&quot;,          2, Code.ValSetBeh),
            NewOpCode (&quot;ValGet&quot;,             1, Code.ValGet),
            NewOpCode (&quot;ValValue&quot;,           2, Code.ValValue),
            NewOpCode (&quot;NewConst&quot;,           1, Code.NewConst),
            NewOpCode (&quot;NewSync&quot;,            2, Code.NewSync),
            NewOpCode (&quot;NewAsync&quot;,           1, Code.NewAsync),
            NewOpCode (&quot;NewDep&quot;,             1, Code.NewDep),
            NewOpCode (&quot;ConstBehSet&quot;,        2, Code.ConstBehSet),
            NewOpCode (&quot;NewConstBeh&quot;,        1, Code.NewConstBeh),
            NewOpCode (&quot;SyncBehAddRequest&quot;,  2, Code.SyncBehAddRequest),
            NewOpCode (&quot;SyncBehLinChangeTo&quot;, 4, Code.SyncBehLinChangeTo),
            NewOpCode (&quot;SyncBehLinChangeBy&quot;, 4, Code.SyncBehLinChangeBy),
            NewOpCode (&quot;NewSyncBeh&quot;,         2, Code.NewSyncBeh),
            NewOpCode (&quot;NewAsyncBeh&quot;,        1, Code.NewAsyncBeh),
            NewOpCode (&quot;NewDepBeh&quot;,          1, Code.NewDepBeh),
            NewOpCode (&quot;NewRequest&quot;,         3, Code.NewRequest)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  NameProto     : ObValue.Val;
  ValProto      : ObValue.Val;
  ConstBehProto : ObValue.Val;
  SyncBehProto  : ObValue.Val;
  AsyncBehProto : ObValue.Val;
  DepBehProto   : ObValue.Val;
  RequestProto  : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** retrieve the prototypes ***)
    loader.load (&quot;RealProp.obl&quot;);
    NameProto     := loader.get (&quot;RealProp_NameProto&quot;);
    ValProto      := loader.get (&quot;RealProp_ValProto&quot;);
    ConstBehProto := loader.get (&quot;RealProp_ConstBehProto&quot;);
    SyncBehProto  := loader.get (&quot;RealProp_SyncBehProto&quot;);
    AsyncBehProto := loader.get (&quot;RealProp_AsyncBehProto&quot;);
    DepBehProto   := loader.get (&quot;RealProp_DepBehProto&quot;);
    RequestProto  := loader.get (&quot;RealProp_RequestProto&quot;);

    (*** Register the proxy makers ***)
    RealPropProxy.NamePM     := AddNameObj;
    RealPropProxy.ValPM      := AddValObj;
    RealPropProxy.ConstBehPM := AddConstBehObj;
    RealPropProxy.SyncBehPM  := AddSyncBehObj;
    RealPropProxy.AsyncBehPM := AddAsyncBehObj;
    RealPropProxy.DepBehPM   := AddDepBehObj;
    RealPropProxy.RequestPM  := AddRequestObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {NameBind,
          ValGetBeh, ValSetBeh, ValGet, ValValue,
             NewConst, NewSync, NewAsync, NewDep,
          ConstBehSet, NewConstBeh,
          SyncBehAddRequest, SyncBehLinChangeTo, SyncBehLinChangeBy,
             NewSyncBeh,
          NewAsyncBeh,
          NewDepBeh,
          NewRequest};

  OpCode = ObLib.OpCode BRANDED OBJECT
    code: Code;
  END;

  Package = ObLib.T BRANDED OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

CONST
  pkgname = &quot;RealProp&quot;;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.NameBind =&gt;
      WITH pn   = GetName (args, 1, self, opCode, loc),
           pv   = GetVal  (args, 2, self, opCode, loc),
           prop = pn.bind (pv) DO
        RETURN prop.proxy.obj;
      END;
    | Code.ValGetBeh =&gt;
      WITH pv = GetVal (args, 1, self, opCode, loc) DO
        RETURN pv.beh.proxy.obj;
      END;
    | Code.ValSetBeh =&gt;
      WITH pv  = GetVal (args, 1, self, opCode, loc),
           beh = GetBeh (args, 2, self, opCode, loc) DO
        pv.beh := beh;
        RETURN ObValue.valOk;
      END;
    | Code.ValGet =&gt;
      WITH pv = GetVal (args, 1, self, opCode, loc) DO
        TRY
          RETURN ObReal.M3ToObliq (pv.get ());
        EXCEPT
        | Prop.BadMethod =&gt;
          ObValue.RaiseException (ObProp.BadMethod, opCode.name, loc);
          RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
        END;
      END;
    | Code.ValValue =&gt;
      WITH pv   = GetVal (args, 1, self, opCode, loc),
           time = ObLongReal.GetArg (args, 2, self, opCode, loc) DO
        TRY
          RETURN ObReal.M3ToObliq (pv.value (time));
        EXCEPT
        | Prop.BadMethod =&gt;
          ObValue.RaiseException (ObProp.BadMethod, opCode.name, loc);
          RETURN ObValue.valOk;   (* ... only to suppress compiler warning *)
        END;
      END;
    | Code.NewConst =&gt;
      (*** AddValObj creates the actual Obliq object ***)
      WITH r   = ObReal.GetArg (args, 1, self, opCode, loc),
           val = RealProp.NewConst (r) DO
        RETURN val.proxy.obj;
      END;
    | Code.NewSync =&gt;
      WITH ah  = ObAnimHandle.GetT (args, 1, self, opCode, loc),
           r   = ObReal.GetArg (args, 2, self, opCode, loc),
           val = RealProp.NewSync (ah, r) DO
        RETURN val.proxy.obj;
      END;
    | Code.NewAsync =&gt;
      WITH beh  = NEW (RealProp.AsyncBeh).init (),
           obj  = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        WITH val = RealProp.NewAsync (beh) DO
          RETURN val.proxy.obj;
        END;
      END;
    | Code.NewDep =&gt;
      WITH beh = NEW (RealProp.DepBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        WITH val = RealProp.NewDep (beh) DO
          RETURN val.proxy.obj;
        END;
      END;
    | Code.ConstBehSet =&gt;
      WITH beh = GetConstBeh (args, 1, self, opCode, loc),
           r   = ObReal.GetArg (args, 2, self, opCode, loc) DO
        beh.set (r);
        RETURN ObValue.valOk;
      END;
    | Code.NewConstBeh =&gt;
      WITH r   = ObReal.GetArg (args, 1, self, opCode, loc),
           beh = NEW (RealProp.ConstBeh).init (r) DO
        RETURN beh.proxy.obj;
      END;
    | Code.SyncBehAddRequest =&gt;
      WITH beh = GetSyncBeh (args, 1, self, opCode, loc),
           req = GetRequest (args, 2, self, opCode, loc) DO
        TRY
          beh.addRequest (req);
        EXCEPT
        | Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.SyncBehLinChangeTo =&gt;
      WITH beh   = GetSyncBeh (args, 1, self, opCode, loc),
           r     = ObReal.GetArg (args, 2, self, opCode, loc),
           start = ObReal.GetArg (args, 3, self, opCode, loc),
           dur   = ObReal.GetArg (args, 4, self, opCode, loc) DO
        TRY
          beh.linChangeTo (r, start, dur);
        EXCEPT
          Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.SyncBehLinChangeBy =&gt;
      WITH beh   = GetSyncBeh (args, 1, self, opCode, loc),
           r     = ObReal.GetArg (args, 2, self, opCode, loc),
           start = ObReal.GetArg (args, 3, self, opCode, loc),
           dur   = ObReal.GetArg (args, 4, self, opCode, loc) DO
        TRY
          beh.linChangeBy (r, start, dur);
        EXCEPT
          Prop.BadInterval =&gt;
          ObValue.RaiseException (ObProp.BadInterval, opCode.name, loc);
        END;
        RETURN ObValue.valOk;
      END;
    | Code.NewSyncBeh =&gt;
      WITH ah  = ObAnimHandle.GetT (args, 1, self, opCode, loc),
           r   = ObReal.GetArg (args, 2, self, opCode, loc),
           beh = NEW (RealProp.SyncBeh).init (ah, r) DO
        RETURN beh.proxy.obj;
      END;
    | Code.NewAsyncBeh =&gt;
      WITH beh = NEW (RealProp.AsyncBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        RETURN obj;
      END;
    | Code.NewDepBeh =&gt;
      WITH beh = NEW (RealProp.DepBeh).init (),
           obj = NARROW (beh.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;compute&quot;, args[1]);
        RETURN obj;
      END;
    | Code.NewRequest =&gt;
      WITH start = ObReal.GetArg (args, 1, self, opCode, loc),
           dur   = ObReal.GetArg (args, 2, self, opCode, loc),
           req   = NEW (RealProp.Request).init (start, dur),
           obj   = NARROW (req.proxy.obj, Obliq.Val) DO
        Obliq.ObjectUpdate (obj, &quot;value&quot;, args[3]);
        RETURN obj;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObRealProp.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
