<HTML>
<HEAD>
<TITLE>SRC Modula-3: obliqlib3D/src/ObRootGO.m3</TITLE>
</HEAD>
<BODY>
<A NAME="0TOP0">
<H2>obliqlib3D/src/ObRootGO.m3</H2></A><HR>
<inModule>
<PRE><A HREF="../../COPYRIGHT.html">Copyright (C) 1994, Digital Equipment Corp.</A>
</PRE><BLOCKQUOTE><EM> Digital Internal Use Only                                                 </EM></BLOCKQUOTE><PRE>
</PRE>                                                                           
       Created on Sat Mar  5 20:42:30 PST 1994 by najork                   

<P>
<P><PRE>MODULE <module><implements><A HREF="ObRootGO.i3">ObRootGO</A></implements></module>;

IMPORT <A HREF="ObAux.i3">ObAux</A>, <A HREF="ObBooleanProp.i3">ObBooleanProp</A>, <A HREF="ObCameraGO.i3">ObCameraGO</A>, <A HREF="ObColorProp.i3">ObColorProp</A>, <A HREF="../../obliqrt/src/ObCommand.i3">ObCommand</A>, <A HREF="ObGO.i3">ObGO</A>,
       <A HREF="ObGraphicsBase.i3">ObGraphicsBase</A>, <A HREF="ObGroupGO.i3">ObGroupGO</A>, <A HREF="../../obliqrt/src/ObLib.i3">ObLib</A>, <A HREF="ObProp.i3">ObProp</A>, <A HREF="ObProtoLoader.i3">ObProtoLoader</A>, <A HREF="ObRealProp.i3">ObRealProp</A>,
       <A HREF="../../obliqrt/src/ObValue.i3">ObValue</A>, <A HREF="../../obliqrt/src/Obliq.i3">Obliq</A>, <A HREF="../../anim3D/src/ProxiedObj.i3">ProxiedObj</A>, <A HREF="../../anim3D/src/RootGO.i3">RootGO</A>, <A HREF="../../anim3D/src/RootGOProxy.i3">RootGOProxy</A>, <A HREF="../../synloc/src/SynLocation.i3">SynLocation</A>;

CONST
  pkgname = &quot;RootGO&quot;;
</PRE>***************************************************************************
 Wrapper for RootGO.T                                                      
***************************************************************************

<P>
<P><PRE>TYPE
  T = ObGroupGO.T BRANDED &quot;ObRootGO.T&quot; OBJECT END;

PROCEDURE <A NAME="AddTObj"><procedure>AddTObj</procedure></A> (root : RootGO.T) =
  &lt;* FATAL ObValue.Error, ObValue.Exception *&gt;
  BEGIN
    WITH obj = Obliq.ObjectClone (Obliq.Vals {TProto}),
         raw = NEW (T, what := &quot;&lt;a RootGO.T&gt;&quot;, po := root) DO
      Obliq.ObjectUpdate (obj, &quot;raw&quot;, raw);
      root.proxy := NEW (ProxiedObj.Proxy, obj := obj);
    END;
  END AddTObj;

PROCEDURE <A NAME="GetArg"><procedure>GetArg</procedure></A> (args    : ObValue.ArgArray;
                  idx     : INTEGER;
                  package : ObLib.T;
                  opCode  : ObLib.OpCode;
                  loc     : SynLocation.T) : RootGO.T
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    WITH raw = Obliq.ObjectSelect (args[idx], &quot;raw&quot;) DO
      TYPECASE raw OF
      | T (node) =&gt;
        RETURN node.po;
      ELSE
        ObValue.BadArgType (idx, pkgname, package.name, opCode.name, loc);
        RETURN NIL;      (* ... only to suppress compiler warning *)
      END;
    END;
  END GetArg;
</PRE>***************************************************************************
 Setup procedures                                                          
***************************************************************************

<P>
<P><PRE>PROCEDURE <A NAME="SetupPackage"><procedure>SetupPackage</procedure></A> () =

  PROCEDURE NewOpCode (name : TEXT; arity : INTEGER; code : Code) : OpCode =
    BEGIN
      RETURN NEW (OpCode, name := name, arity := arity, code := code);
    END NewOpCode;

  TYPE
    OpCodes = ARRAY OF ObLib.OpCode;
  VAR
    opCodes: REF OpCodes;
  BEGIN
    opCodes := NEW (REF OpCodes, NUMBER (Code));
    opCodes^ :=
        OpCodes {
            NewOpCode (&quot;New&quot;,                   2, Code.New),
            NewOpCode (&quot;NewStd&quot;,                0, Code.NewStd),
            NewOpCode (&quot;NewStdWithBase&quot;,        1, Code.NewStdWithBase),
            NewOpCode (&quot;ChangeCamera&quot;,          2, Code.ChangeCamera),
            NewOpCode (&quot;Background&quot;,           -1, Code.Background),
            NewOpCode (&quot;DepthcueSwitch&quot;,       -1, Code.DepthcueSwitch),
            NewOpCode (&quot;DepthcueColor&quot;,        -1, Code.DepthcueColor),
            NewOpCode (&quot;DepthcueFrontPlane&quot;,   -1, Code.DepthcueFrontPlane),
            NewOpCode (&quot;DepthcueBackPlane&quot;,    -1, Code.DepthcueBackPlane),
            NewOpCode (&quot;DepthcueFrontScale&quot;,   -1, Code.DepthcueFrontScale),
            NewOpCode (&quot;DepthcueBackScale&quot;,    -1, Code.DepthcueBackScale),
            NewOpCode (&quot;SetBackground&quot;,         2, Code.SetBackground),
            NewOpCode (&quot;SetDepthcueSwitch&quot;,     2, Code.SetDepthcueSwitch),
            NewOpCode (&quot;SetDepthcueColor&quot;,      2, Code.SetDepthcueColor),
            NewOpCode (&quot;SetDepthcueFrontPlane&quot;, 2, Code.SetDepthcueFrontPlane),
            NewOpCode (&quot;SetDepthcueBackPlane&quot;,  2, Code.SetDepthcueBackPlane),
            NewOpCode (&quot;SetDepthcueFrontScale&quot;, 2, Code.SetDepthcueFrontScale),
            NewOpCode (&quot;SetDepthcueBackScale&quot;,  2, Code.SetDepthcueBackScale)
        };

    ObLib.Register (NEW (Package, name := pkgname, opCodes := opCodes));
    ObLib.RegisterHelp (pkgname, Help);
  END SetupPackage;

VAR
  TProto : ObValue.Val;

PROCEDURE <A NAME="SetupModule"><procedure>SetupModule</procedure></A> (loader : ObProtoLoader.T) =
  BEGIN
    (*** Retrieve the prototype ***)
    loader.load (&quot;RootGO.obl&quot;);
    TProto := loader.get (&quot;RootGO_TProto&quot;);

    (*** Register the proxy maker ***)
    RootGOProxy.MkProxyT := AddTObj;
  END SetupModule;
</PRE>***************************************************************************
 Execution machinery                                                       
***************************************************************************

<P>
<P><PRE>TYPE
  Code = {ChangeCamera, New, NewStd, NewStdWithBase,
          Background, DepthcueSwitch, DepthcueColor, DepthcueFrontPlane,
          DepthcueBackPlane, DepthcueFrontScale, DepthcueBackScale,
          SetBackground, SetDepthcueSwitch, SetDepthcueColor,
          SetDepthcueFrontPlane, SetDepthcueBackPlane, SetDepthcueFrontScale,
          SetDepthcueBackScale};

  OpCode = ObLib.OpCode OBJECT
    code: Code;
  END;

  Package = ObLib.T OBJECT
  OVERRIDES
    Eval := DoEval;
  END;

PROCEDURE <A NAME="DoEval"><procedure>DoEval</procedure></A> (self         : Package;
                  opCode       : ObLib.OpCode;
     &lt;* UNUSED *&gt; arity        : ObLib.OpArity;
                  READONLY args: ObValue.ArgArray;
     &lt;* UNUSED *&gt; temp         : BOOLEAN;
                  loc          : SynLocation.T) : ObValue.Val
    RAISES {ObValue.Error, ObValue.Exception} =
  BEGIN
    CASE NARROW (opCode, OpCode).code OF
    | Code.New =&gt;
      WITH cam  = ObCameraGO.GetArg     (args, 1, self, opCode, loc),
           base = ObGraphicsBase.GetArg (args, 2, self, opCode, loc),
           root = RootGO.New (cam, base) DO
        RETURN root.proxy.obj;
      END;
    | Code.NewStd =&gt;
      WITH root = RootGO.NewStd () DO
        RETURN root.proxy.obj;
      END;
    | Code.NewStdWithBase =&gt;
      WITH base = ObGraphicsBase.GetArg (args, 1, self, opCode, loc),
           root = RootGO.NewStd (base) DO
        RETURN root.proxy.obj;
      END;
    | Code.ChangeCamera =&gt;
      WITH root = GetArg            (args, 1, self, opCode, loc),
           cam  = ObCameraGO.GetArg (args, 2, self, opCode, loc) DO
        root.changeCamera (cam);
        RETURN ObValue.valOk;
      END;
    | Code.Background =&gt;
      RETURN ObProp.NameToObliq (RootGO.Background);
    | Code.SetBackground =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           pv = ObColorProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (RootGO.Background.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.DepthcueSwitch =&gt;
      RETURN ObProp.NameToObliq (RootGO.DepthcueSwitch);
    | Code.SetDepthcueSwitch =&gt;
      WITH go = ObGO.GetArg                   (args, 1, self, opCode, loc),
           pv = ObBooleanProp.GetOverloadedVal(args, 2, self, opCode, loc) DO
        go.setProp (RootGO.DepthcueSwitch.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.DepthcueColor =&gt;
      RETURN ObProp.NameToObliq (RootGO.DepthcueColour);
    | Code.SetDepthcueColor =&gt;
      WITH go = ObGO.GetArg                  (args, 1, self, opCode, loc),
           pv = ObColorProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (RootGO.DepthcueColour.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.DepthcueFrontPlane =&gt;
      RETURN ObProp.NameToObliq (RootGO.DepthcueFrontPlane);
    | Code.SetDepthcueFrontPlane =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           pv = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (RootGO.DepthcueFrontPlane.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.DepthcueBackPlane =&gt;
      RETURN ObProp.NameToObliq (RootGO.DepthcueBackPlane);
    | Code.SetDepthcueBackPlane =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           pv = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (RootGO.DepthcueBackPlane.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.DepthcueFrontScale =&gt;
      RETURN ObProp.NameToObliq (RootGO.DepthcueFrontScale);
    | Code.SetDepthcueFrontScale =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           pv = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (RootGO.DepthcueFrontScale.bind (pv));
        RETURN ObValue.valOk;
      END;
    | Code.DepthcueBackScale =&gt;
      RETURN ObProp.NameToObliq (RootGO.DepthcueBackScale);
    | Code.SetDepthcueBackScale =&gt;
      WITH go = ObGO.GetArg                 (args, 1, self, opCode, loc),
           pv = ObRealProp.GetOverloadedVal (args, 2, self, opCode, loc) DO
        go.setProp (RootGO.DepthcueBackScale.bind (pv));
        RETURN ObValue.valOk;
      END;
    END;
  END DoEval;
</PRE>***************************************************************************
 Help                                                                      
***************************************************************************

<P><PRE>PROCEDURE <A NAME="Help"><procedure>Help</procedure></A> (self : ObCommand.T; arg : TEXT; &lt;* UNUSED *&gt; data : REFANY) =
  BEGIN
    ObAux.Help (self, arg, pkgname);
  END Help;

BEGIN
END ObRootGO.
</PRE>
</inModule>
<PRE>























</PRE>
</BODY>
</HTML>
